/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.security.PrivilegedAction;
import oracle.aurora.rdbms.ClassResolver;
import oracle.aurora.rdbms.Resolver;

public class ObjectInputStreamWithResolver
extends ObjectInputStream {
    private ClassLoader loader;

    public ObjectInputStreamWithResolver(InputStream in) throws IOException, StreamCorruptedException {
        super(in);
        this.loader = (ClassResolver)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ClassResolver();
            }
        });
    }

    public ObjectInputStreamWithResolver(InputStream in, Resolver resolver) throws IOException, StreamCorruptedException {
        super(in);
        if (resolver == null) {
            throw new IllegalArgumentException("Illegal null resolver argument to ObjectInputStreamWithResolver");
        }
        final Resolver res = resolver;
        this.loader = (ClassResolver)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ClassResolver(res);
            }
        });
    }

    private Class primitiveType(char type) {
        switch (type) {
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        String cname = classDesc.getName();
        if (cname.startsWith("[")) {
            Class<?> component;
            int dcount = 1;
            while (cname.charAt(dcount) == '[') {
                ++dcount;
            }
            if (cname.charAt(dcount) == 'L') {
                component = this.loader.loadClass(cname.substring(dcount + 1, cname.length() - 1));
            } else {
                if (cname.length() != dcount + 1) {
                    throw new ClassNotFoundException(cname);
                }
                component = this.primitiveType(cname.charAt(dcount));
            }
            int[] dim = new int[dcount];
            for (int i = 0; i < dcount; ++i) {
                dim[i] = 0;
            }
            return Array.newInstance(component, dim).getClass();
        }
        return this.loader.loadClass(cname);
    }
}

