/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.compiler;

import java.util.Enumeration;
import oracle.aurora.compiler.Option;
import oracle.aurora.compiler.QName;

public abstract class OptionTable {
    public String get(QName level, Option opt) {
        Enumeration values = this.getMultiValued(level, opt);
        StringBuffer value = new StringBuffer();
        if (values.hasMoreElements()) {
            value.append((String)values.nextElement());
        } else {
            value.append(opt.defaultValue);
        }
        while (values.hasMoreElements()) {
            value.append(opt.separator);
            value.append((String)values.nextElement());
        }
        return value.toString();
    }

    public Enumeration getMultiValued(QName level, Option opt) {
        LookupState state = new LookupState(level.getFullName(), opt);
        return state;
    }

    public void reset(QName name, Option opt) {
        this.resetValues(name.getFullName(), opt.id);
    }

    public void set(QName name, Option opt, String value) {
        if (opt.unique) {
            this.resetValues(name.getFullName(), opt.id);
        }
        this.addValue(name.getFullName(), opt.id, value);
    }

    protected abstract Enumeration getValues(String var1, String var2);

    protected abstract void resetValues(String var1, String var2);

    protected abstract void addValue(String var1, String var2, String var3);

    private class LookupState
    implements Enumeration {
        String level;
        Enumeration values;
        boolean done;
        Option opt;

        LookupState(String level, Option opt) {
            this.level = level;
            this.opt = opt;
            this.done = false;
            this.values = OptionTable.this.getValues(level, opt.id);
        }

        void advanceLevel() {
            if (!this.opt.inherited) {
                this.done = true;
            } else {
                int x = this.level.lastIndexOf(46);
                if (x < 0 && !this.level.equals("")) {
                    x = 0;
                }
                if (x >= 0) {
                    this.level = this.level.substring(0, x);
                    this.values = OptionTable.this.getValues(this.level, this.opt.id);
                } else {
                    this.done = true;
                }
            }
        }

        void makeReady() {
            while (!this.done && !this.values.hasMoreElements()) {
                this.advanceLevel();
            }
        }

        public boolean hasMoreElements() {
            this.makeReady();
            return !this.done;
        }

        public Object nextElement() {
            this.makeReady();
            Object result = null;
            if (!this.done) {
                result = this.values.nextElement();
            }
            if (this.opt.unique) {
                this.done = true;
            }
            return result;
        }
    }
}

