/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.share.nls;

import java.awt.Component;
import java.util.Locale;
import oracle.bali.share.collection.OptimisticHashMap;

public final class LocaleUtils {
    public static final Locale ARABIC = new Locale("ar", "", "");
    public static final Locale CHINESE = Locale.CHINESE;
    public static final Locale CZECH = new Locale("cs", "", "");
    public static final Locale DANISH = new Locale("da", "", "");
    public static final Locale DUTCH = new Locale("nl", "", "");
    public static final Locale ENGLISH = Locale.ENGLISH;
    public static final Locale FINNISH = new Locale("fi", "", "");
    public static final Locale FRENCH = Locale.FRENCH;
    public static final Locale GERMAN = Locale.GERMAN;
    public static final Locale HUNGARIAN = new Locale("hu", "", "");
    public static final Locale ITALIAN = Locale.ITALIAN;
    public static final Locale JAPANESE = Locale.JAPANESE;
    public static final Locale KOREAN = Locale.KOREAN;
    public static final Locale NORWEGIAN = new Locale("no", "", "");
    public static final Locale POLISH = new Locale("pl", "", "");
    public static final Locale PORTUGUESE = new Locale("pt", "", "");
    public static final Locale RUSSIAN = new Locale("ru", "", "");
    public static final Locale SLOVAK = new Locale("sk", "", "");
    public static final Locale SPANISH = new Locale("es", "", "");
    public static final Locale SWEDISH = new Locale("sv", "", "");
    public static final Locale SIMPLIFIED_CHINESE = Locale.SIMPLIFIED_CHINESE;
    public static final Locale TRADITIONAL_CHINESE = Locale.TRADITIONAL_CHINESE;
    public static final Locale BRAZIL = new Locale("pt", "BR", "");
    public static final Locale CANADA = Locale.CANADA;
    public static final Locale CANADA_FRENCH = Locale.CANADA_FRENCH;
    public static final Locale CHINA = Locale.CHINA;
    public static final Locale FRANCE = Locale.FRANCE;
    public static final Locale GERMANY = Locale.GERMANY;
    public static final Locale ITALY = Locale.ITALY;
    public static final Locale JAPAN = Locale.JAPAN;
    public static final Locale KOREA = Locale.KOREA;
    public static final Locale PRC = Locale.PRC;
    public static final Locale TAIWAN = Locale.TAIWAN;
    public static final Locale UK = Locale.UK;
    public static final Locale US = Locale.US;
    public static final int DIRECTION_DEFAULT = 0;
    public static final int DIRECTION_LEFTTORIGHT = 1;
    public static final int DIRECTION_RIGHTTOLEFT = 2;
    private static final String[] _LANG_TO_TERRITORY = new String[]{"aa", "DJ", "ab", "GE", "af", "ZA", "am", "ET", "ar", "EG", "as", "IN", "ay", "BO", "az", "AZ", "ba", "RU", "be", "BY", "bg", "BG", "bh", "IN", "bi", "VU", "bn", "BD", "bo", "CN", "br", "FR", "ca", "ES", "co", "FR", "cs", "CZ", "cy", "GB", "da", "DK", "de", "DE", "dz", "BT", "el", "GR", "en", "US", "eo", "FR", "es", "ES", "et", "EE", "eu", "ES", "fa", "IR", "fi", "FI", "fj", "FJ", "fo", "GB", "fr", "FR", "fy", "NL", "ga", "IE", "gd", "GB", "gl", "ES", "gn", "PY", "gu", "IN", "ha", "NG", "he", "IL", "hi", "IN", "hr", "HR", "hu", "HU", "hy", "AM", "ia", "FR", "id", "ID", "ie", "FR", "ik", "US", "in", "ID", "is", "IS", "it", "IT", "iu", "GL", "iw", "IL", "ja", "JP", "ji", "IL", "jw", "ID", "ka", "GE", "kk", "KZ", "kl", "GL", "km", "KH", "kn", "IN", "ko", "KR", "ks", "IN", "ku", "TR", "ky", "KG", "la", "VA", "ln", "ZR", "lo", "LA", "lt", "LT", "lv", "LV", "mg", "MG", "mi", "NZ", "mk", "MK", "ml", "IN", "mn", "MN", "mo", "MD", "mr", "IN", "ms", "MY", "mt", "MT", "my", "MM", "na", "NR", "ne", "NP", "nl", "NL", "no", "NO", "oc", "FR", "om", "ET", "or", "IN", "pa", "IN", "pl", "PL", "ps", "AF", "pt", "PT", "qu", "PE", "rm", "CH", "rn", "BI", "ro", "RO", "ru", "RU", "rw", "RW", "sa", "IN", "sd", "PK", "sg", "CF", "sh", "YU", "si", "LK", "sk", "SK", "sl", "SI", "sm", "WS", "sn", "ZW", "so", "So", "sq", "AL", "sr", "YU", "ss", "SZ", "st", "LS", "su", "SD", "sv", "SE", "sw", "TZ", "ta", "IN", "te", "IN", "tg", "TJ", "th", "TH", "ti", "ER", "tk", "TM", "tl", "PH", "tn", "BW", "to", "TO", "tr", "TK", "ts", "ZA", "tt", "RU", "tw", "BF", "ug", "CN", "uk", "UA", "ur", "PK", "uz", "UZ", "vi", "VN", "vo", "DE", "wo", "SN", "xh", "ZA", "yi", "IL", "yo", "NG", "za", "CN", "zh", "CN", "zu", "ZA"};
    private static OptimisticHashMap _sLangToTerritoryMap;

    public static Locale getDefaultableLocale(Component component) {
        Locale locale = null;
        try {
            locale = component.getLocale();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static int getReadingDirectionForLocale(Locale locale) {
        String string;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((string = locale.getLanguage()).equals("ar") || string.equals("he") || string.equals("iw")) {
            return 2;
        }
        return 1;
    }

    public static Locale getLocaleForIANAString(String string) {
        String string2;
        if (string == null || "".equals(string)) {
            return null;
        }
        String string3 = "";
        String string4 = "";
        int n = string.indexOf(45);
        if (n < 0) {
            string2 = string;
        } else {
            string2 = string.substring(0, n);
            int n2 = n + 1;
            if ((n = string.indexOf(45, n2)) < 0) {
                string3 = string.substring(n2);
            } else {
                string3 = string.substring(n2, n);
                string4 = string.substring(n + 1);
            }
        }
        return new Locale(string2, string3, string4);
    }

    public static Locale getLocaleWithCountry(Locale locale) {
        if (locale == null) {
            return null;
        }
        if ("".equals(locale.getCountry())) {
            String string = locale.getLanguage();
            String string2 = LocaleUtils._languageToTerritory(string);
            String string3 = locale.getVariant();
            return new Locale(string, string2, string3);
        }
        return locale;
    }

    private static String _languageToTerritory(String string) {
        String string2;
        if (_sLangToTerritoryMap == null) {
            int n = _LANG_TO_TERRITORY.length;
            OptimisticHashMap optimisticHashMap = new OptimisticHashMap((int)((double)n * 0.7));
            for (int i = 0; i < n; ++i) {
                String string3 = _LANG_TO_TERRITORY[i];
                String string4 = _LANG_TO_TERRITORY[++i];
                optimisticHashMap.put(string3, string4);
            }
            _sLangToTerritoryMap = optimisticHashMap;
        }
        if ((string2 = (String)_sLangToTerritoryMap.get(string)) != null) {
            return string2;
        }
        _sLangToTerritoryMap.put(string, "");
        return "";
    }

    private LocaleUtils() {
    }
}

