/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.cleaner.FileSelector;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.cleaner.PackedOffsets;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.FileSummaryLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DbLsn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilizationProfile
implements EnvConfigObserver {
    private EnvironmentImpl env;
    private UtilizationTracker tracker;
    private DatabaseImpl fileSummaryDb;
    private SortedMap<Long, FileSummary> fileSummaryMap;
    private boolean cachePopulated;
    private boolean rmwFixEnabled;
    private FilesToMigrate filesToMigrate;
    int minUtilization;
    int minFileUtilization;
    int minAge;

    public UtilizationProfile(EnvironmentImpl env, UtilizationTracker tracker) throws DatabaseException {
        this.env = env;
        this.tracker = tracker;
        this.fileSummaryMap = new TreeMap<Long, FileSummary>();
        this.filesToMigrate = new FilesToMigrate();
        this.rmwFixEnabled = env.getConfigManager().getBoolean(EnvironmentParams.CLEANER_RMW_FIX);
        this.envConfigUpdate(env.getConfigManager(), null);
        env.addConfigObserver(this);
    }

    @Override
    public void envConfigUpdate(DbConfigManager cm, EnvironmentMutableConfig ignore) throws DatabaseException {
        this.minAge = cm.getInt(EnvironmentParams.CLEANER_MIN_AGE);
        this.minUtilization = cm.getInt(EnvironmentParams.CLEANER_MIN_UTILIZATION);
        this.minFileUtilization = cm.getInt(EnvironmentParams.CLEANER_MIN_FILE_UTILIZATION);
    }

    public boolean isRMWFixEnabled() {
        return this.rmwFixEnabled;
    }

    synchronized int getNumberOfFiles() throws DatabaseException {
        return this.fileSummaryMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getTotalLogSize() {
        long size = 0L;
        UtilizationProfile utilizationProfile = this;
        synchronized (utilizationProfile) {
            for (FileSummary summary : this.fileSummaryMap.values()) {
                size += (long)summary.totalSize;
            }
        }
        for (TrackedFileSummary summary : this.tracker.getTrackedFiles()) {
            size += (long)summary.totalSize;
        }
        return size;
    }

    synchronized Long getCheapestFileToClean(SortedSet<Long> files) throws DatabaseException {
        if (files.size() == 1) {
            return files.first();
        }
        assert (this.cachePopulated);
        Long bestFile = null;
        int bestCost = Integer.MAX_VALUE;
        SortedMap<Long, FileSummary> currentFileSummaryMap = this.getFileSummaryMap(true);
        for (Long file : files) {
            FileSummary summary = (FileSummary)currentFileSummaryMap.get(file);
            if (summary == null) {
                return file;
            }
            int thisCost = summary.getNonObsoleteCount();
            if (bestFile != null && thisCost >= bestCost) continue;
            bestFile = file;
            bestCost = thisCost;
        }
        return bestFile;
    }

    synchronized Long getBestFileForCleaning(FileSelector fileSelector, boolean forceCleaning, Set<Long> lowUtilizationFiles, boolean isBacklog) throws DatabaseException {
        long firstActiveTxnFile;
        if (lowUtilizationFiles != null) {
            lowUtilizationFiles.clear();
        }
        assert (this.cachePopulated);
        SortedMap<Long, FileSummary> currentFileSummaryMap = this.getFileSummaryMap(true);
        if (currentFileSummaryMap.size() == 0) {
            return null;
        }
        int useMinUtilization = this.minUtilization;
        int useMinFileUtilization = this.minFileUtilization;
        int useMinAge = this.minAge;
        long firstActiveFile = currentFileSummaryMap.lastKey();
        long firstActiveTxnLsn = this.env.getTxnManager().getFirstActiveLsn();
        if (firstActiveTxnLsn != -1L && firstActiveFile > (firstActiveTxnFile = DbLsn.getFileNumber(firstActiveTxnLsn))) {
            firstActiveFile = firstActiveTxnFile;
        }
        long lastFileToClean = firstActiveFile - (long)useMinAge;
        Iterator<Map.Entry<Long, FileSummary>> iter = currentFileSummaryMap.entrySet().iterator();
        Long bestFile = null;
        int bestUtilization = 101;
        long totalSize = 0L;
        long totalObsoleteSize = 0L;
        while (iter.hasNext()) {
            Map.Entry<Long, FileSummary> entry = iter.next();
            Long file = entry.getKey();
            long fileNum = file;
            FileSummary summary = entry.getValue();
            int obsoleteSize = summary.getObsoleteSize();
            if (fileSelector.isFileCleaningInProgress(file)) {
                totalSize += (long)(summary.totalSize - obsoleteSize);
                totalObsoleteSize += (long)this.estimateUPObsoleteSize(summary);
                continue;
            }
            totalSize += (long)summary.totalSize;
            totalObsoleteSize += (long)obsoleteSize;
            if (fileNum > lastFileToClean) continue;
            int thisUtilization = UtilizationProfile.utilization(obsoleteSize, summary.totalSize);
            if (bestFile == null || thisUtilization < bestUtilization) {
                bestFile = file;
                bestUtilization = thisUtilization;
            }
            if (lowUtilizationFiles == null || thisUtilization >= useMinUtilization) continue;
            lowUtilizationFiles.add(file);
        }
        int totalUtilization = UtilizationProfile.utilization(totalObsoleteSize, totalSize);
        if (totalUtilization < useMinUtilization || bestUtilization < useMinFileUtilization) {
            return bestFile;
        }
        if (!isBacklog && this.filesToMigrate.hasNext()) {
            return this.filesToMigrate.next();
        }
        if (forceCleaning) {
            return bestFile;
        }
        return null;
    }

    public static int utilization(long obsoleteSize, long totalSize) {
        if (totalSize != 0L) {
            return (int)((totalSize - obsoleteSize) * 100L / totalSize);
        }
        return 0;
    }

    private int estimateUPObsoleteSize(FileSummary summary) {
        return 0;
    }

    private synchronized FileSummary getFileSummary(Long file) {
        FileSummary summary = (FileSummary)this.fileSummaryMap.get(file);
        TrackedFileSummary trackedSummary = this.tracker.getTrackedFile(file);
        if (trackedSummary != null) {
            FileSummary totals = new FileSummary();
            totals.add(summary);
            totals.add(trackedSummary);
            summary = totals;
        }
        return summary;
    }

    public void flushLocalTracker(LocalUtilizationTracker localTracker) throws DatabaseException {
        this.env.getLogManager().transferToUtilizationTracker(localTracker);
        this.flushFileUtilization(localTracker.getTrackedFiles());
        this.flushDbUtilization(localTracker);
    }

    public void flushFileUtilization(Collection<TrackedFileSummary> activeFiles) throws DatabaseException {
        if (!DbInternal.getCheckpointUP(this.env.getConfigManager().getEnvironmentConfig())) {
            return;
        }
        for (TrackedFileSummary activeFile : activeFiles) {
            long fileNum = activeFile.getFileNumber();
            TrackedFileSummary tfs = this.tracker.getTrackedFile(fileNum);
            if (tfs == null) continue;
            this.flushFileSummary(tfs);
        }
    }

    private void flushDbUtilization(LocalUtilizationTracker localTracker) throws DatabaseException {
        if (!DbInternal.getCheckpointUP(this.env.getConfigManager().getEnvironmentConfig())) {
            return;
        }
        for (DatabaseImpl databaseImpl : localTracker.getTrackedDbs()) {
            if (databaseImpl.isDeleted() || !databaseImpl.isDirtyUtilization()) continue;
            this.env.getDbTree().modifyDbRoot(databaseImpl);
        }
    }

    public synchronized SortedMap<Long, FileSummary> getFileSummaryMap(boolean includeTrackedFiles) throws DatabaseException {
        assert (this.cachePopulated);
        if (includeTrackedFiles) {
            TreeMap<Long, FileSummary> map = new TreeMap<Long, FileSummary>();
            for (Long file : this.fileSummaryMap.keySet()) {
                FileSummary summary = this.getFileSummary(file);
                map.put(file, summary);
            }
            for (TrackedFileSummary summary : this.tracker.getTrackedFiles()) {
                Long fileNum = summary.getFileNumber();
                if (map.containsKey(fileNum)) continue;
                map.put(fileNum, summary);
            }
            return map;
        }
        return new TreeMap<Long, FileSummary>(this.fileSummaryMap);
    }

    public synchronized void clearCache() {
        int memorySize = this.fileSummaryMap.size() * MemoryBudget.UTILIZATION_PROFILE_ENTRY;
        MemoryBudget mb = this.env.getMemoryBudget();
        mb.updateAdminMemoryUsage(0 - memorySize);
        this.fileSummaryMap = new TreeMap<Long, FileSummary>();
        this.cachePopulated = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFile(Long fileNum, Set<DatabaseId> databases) throws DatabaseException {
        UtilizationProfile utilizationProfile = this;
        synchronized (utilizationProfile) {
            assert (this.cachePopulated);
            FileSummary oldSummary = (FileSummary)this.fileSummaryMap.remove(fileNum);
            if (oldSummary != null) {
                MemoryBudget mb = this.env.getMemoryBudget();
                mb.updateAdminMemoryUsage(0 - MemoryBudget.UTILIZATION_PROFILE_ENTRY);
            }
        }
        this.deleteFileSummary(fileNum, databases);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFileSummary(final Long fileNum, Set<DatabaseId> databases) throws DatabaseException {
        TrackedFileSummary tfs;
        boolean clearedTrackedFile;
        BasicLocker locker;
        block18: {
            final LogManager logManager = this.env.getLogManager();
            final DbTree dbTree = this.env.getDbTree();
            DatabaseImpl idDatabase = dbTree.getDb(DbTree.ID_DB_ID);
            DatabaseImpl nameDatabase = dbTree.getDb(DbTree.NAME_DB_ID);
            boolean logRoot = false;
            if (logManager.removeDbFileSummary(idDatabase, fileNum)) {
                logRoot = true;
            }
            if (logManager.removeDbFileSummary(nameDatabase, fileNum)) {
                logRoot = true;
            }
            if (logRoot) {
                this.env.logMapTreeRoot();
            }
            if (databases != null) {
                for (DatabaseId dbId : databases) {
                    Object var12_12;
                    if (dbId.equals(DbTree.ID_DB_ID) || dbId.equals(DbTree.NAME_DB_ID)) continue;
                    DatabaseImpl db = dbTree.getDb(dbId);
                    try {
                        if (db != null && logManager.removeDbFileSummary(db, fileNum)) {
                            dbTree.modifyDbRoot(db);
                        }
                        var12_12 = null;
                        dbTree.releaseDb(db);
                    }
                    catch (Throwable throwable) {
                        var12_12 = null;
                        dbTree.releaseDb(db);
                        throw throwable;
                    }
                }
            } else {
                CursorImpl.traverseDbWithCursor(idDatabase, LockType.NONE, true, new CursorImpl.WithCursor(){

                    public boolean withCursor(CursorImpl cursor, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
                        DatabaseImpl db;
                        MapLN mapLN = (MapLN)cursor.getCurrentLN(LockType.NONE);
                        if (mapLN != null && logManager.removeDbFileSummary(db = mapLN.getDatabase(), fileNum)) {
                            dbTree.modifyDbRoot(db, -1L, false);
                        }
                        return true;
                    }
                });
            }
            locker = null;
            CursorImpl cursor = null;
            clearedTrackedFile = false;
            try {
                locker = BasicLocker.createBasicLocker(this.env, false, true);
                cursor = new CursorImpl(this.fileSummaryDb, locker);
                cursor.setAllowEviction(true);
                DatabaseEntry keyEntry = new DatabaseEntry();
                DatabaseEntry dataEntry = new DatabaseEntry();
                long fileNumVal = fileNum;
                OperationStatus status = OperationStatus.SUCCESS;
                status = this.getFirstFSLN(cursor, fileNumVal, keyEntry, dataEntry, LockType.WRITE) ? OperationStatus.SUCCESS : OperationStatus.NOTFOUND;
                while (status == OperationStatus.SUCCESS) {
                    this.env.getEvictor().doCriticalEviction(true);
                    FileSummaryLN ln = (FileSummaryLN)cursor.getCurrentLN(LockType.NONE);
                    if (ln != null) {
                        if (fileNumVal != ln.getFileNumber(keyEntry.getData())) break;
                        TrackedFileSummary tfs2 = this.tracker.getTrackedFile(fileNumVal);
                        if (tfs2 != null) {
                            ln.setTrackedSummary(tfs2);
                            clearedTrackedFile = true;
                        }
                        cursor.latchBIN();
                        cursor.delete(ReplicationContext.NO_REPLICATE);
                    }
                    status = cursor.getNext(keyEntry, dataEntry, LockType.WRITE, true, false);
                }
                Object var19_19 = null;
                if (cursor == null) break block18;
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                if (cursor != null) {
                    cursor.releaseBINs();
                    cursor.close();
                }
                if (locker != null) {
                    locker.operationEnd();
                }
                throw throwable;
            }
            cursor.releaseBINs();
            cursor.close();
        }
        if (locker != null) {
            locker.operationEnd();
        }
        if (!clearedTrackedFile && (tfs = this.tracker.getTrackedFile(fileNum)) != null) {
            this.env.getLogManager().removeTrackedFile(tfs);
        }
    }

    public void flushFileSummary(TrackedFileSummary tfs) throws DatabaseException {
        if (tfs.getAllowFlush()) {
            this.putFileSummary(tfs);
        }
    }

    private synchronized PackedOffsets putFileSummary(TrackedFileSummary tfs) throws DatabaseException {
        if (this.env.isReadOnly()) {
            throw new DatabaseException("Cannot write file summary in a read-only environment");
        }
        if (tfs.isEmpty()) {
            return null;
        }
        if (!this.cachePopulated) {
            return null;
        }
        long fileNum = tfs.getFileNumber();
        Long fileNumLong = fileNum;
        FileSummary summary = (FileSummary)this.fileSummaryMap.get(fileNumLong);
        if (summary == null) {
            if (!this.fileSummaryMap.isEmpty() && fileNum < this.fileSummaryMap.lastKey() && !this.env.getFileManager().isFileValid(fileNum)) {
                this.env.getLogManager().removeTrackedFile(tfs);
                return null;
            }
            summary = new FileSummary();
        }
        FileSummary tmp = new FileSummary();
        tmp.add(summary);
        tmp.add(tfs);
        int sequence = tmp.getEntriesCounted();
        FileSummaryLN ln = new FileSummaryLN(this.env, summary);
        ln.setTrackedSummary(tfs);
        this.insertFileSummary(ln, fileNum, sequence);
        summary = ln.getBaseSummary();
        if (this.fileSummaryMap.put(fileNumLong, summary) == null) {
            MemoryBudget mb = this.env.getMemoryBudget();
            mb.updateAdminMemoryUsage(MemoryBudget.UTILIZATION_PROFILE_ENTRY);
        }
        return ln.getObsoleteOffsets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TrackedFileSummary getObsoleteDetail(Long fileNum, PackedOffsets packedOffsets, boolean logUpdate) throws DatabaseException {
        BasicLocker locker;
        TrackedFileSummary tfs;
        ArrayList<long[]> list;
        block19: {
            if (!this.env.getCleaner().trackDetail) {
                return null;
            }
            assert (this.cachePopulated);
            long fileNumVal = fileNum;
            list = new ArrayList<long[]>();
            tfs = this.env.getLogManager().getUnflushableTrackedSummary(fileNumVal);
            locker = null;
            CursorImpl cursor = null;
            try {
                locker = BasicLocker.createBasicLocker(this.env, false, true);
                cursor = new CursorImpl(this.fileSummaryDb, locker);
                cursor.setAllowEviction(true);
                DatabaseEntry keyEntry = new DatabaseEntry();
                DatabaseEntry dataEntry = new DatabaseEntry();
                OperationStatus status = OperationStatus.SUCCESS;
                if (!this.getFirstFSLN(cursor, fileNumVal, keyEntry, dataEntry, LockType.NONE)) {
                    status = OperationStatus.NOTFOUND;
                }
                while (status == OperationStatus.SUCCESS) {
                    this.env.getEvictor().doCriticalEviction(true);
                    FileSummaryLN ln = (FileSummaryLN)cursor.getCurrentLN(LockType.NONE);
                    if (ln != null) {
                        if (fileNumVal != ln.getFileNumber(keyEntry.getData())) break;
                        PackedOffsets offsets = ln.getObsoleteOffsets();
                        if (offsets != null) {
                            list.add(offsets.toArray());
                        }
                        cursor.evict();
                    }
                    status = cursor.getNext(keyEntry, dataEntry, LockType.NONE, true, false);
                }
                Object var16_19 = null;
                if (cursor == null) break block19;
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                if (cursor != null) {
                    cursor.releaseBINs();
                    cursor.close();
                }
                if (locker != null) {
                    locker.operationEnd();
                }
                throw throwable;
            }
            cursor.releaseBINs();
            cursor.close();
        }
        if (locker != null) {
            locker.operationEnd();
        }
        if (!tfs.isEmpty()) {
            PackedOffsets offsets = null;
            if (logUpdate) {
                offsets = this.putFileSummary(tfs);
                if (offsets != null) {
                    list.add(offsets.toArray());
                }
            } else {
                long[] offsetList = tfs.getObsoleteOffsets();
                if (offsetList != null) {
                    list.add(offsetList);
                }
            }
        }
        int size = 0;
        for (int i = 0; i < list.size(); ++i) {
            long[] a = (long[])list.get(i);
            size += a.length;
        }
        long[] offsets = new long[size];
        int index = 0;
        for (int i = 0; i < list.size(); ++i) {
            long[] a = (long[])list.get(i);
            System.arraycopy(a, 0, offsets, index, a.length);
            index += a.length;
        }
        assert (index == offsets.length);
        packedOffsets.pack(offsets);
        return tfs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean populateCache() throws DatabaseException {
        BasicLocker locker;
        int oldMemorySize;
        block19: {
            assert (!this.cachePopulated);
            if (!this.openFileSummaryDatabase()) {
                return false;
            }
            oldMemorySize = this.fileSummaryMap.size() * MemoryBudget.UTILIZATION_PROFILE_ENTRY;
            Object[] existingFiles = this.env.getFileManager().getAllFileNumbers();
            locker = null;
            CursorImpl cursor = null;
            try {
                locker = BasicLocker.createBasicLocker(this.env, false, true);
                cursor = new CursorImpl(this.fileSummaryDb, locker);
                cursor.setAllowEviction(true);
                DatabaseEntry keyEntry = new DatabaseEntry();
                DatabaseEntry dataEntry = new DatabaseEntry();
                if (cursor.positionFirstOrLast(true, null)) {
                    OperationStatus status = cursor.getCurrentAlreadyLatched(keyEntry, dataEntry, LockType.NONE, true);
                    if (status != OperationStatus.SUCCESS) {
                        status = cursor.getNext(keyEntry, dataEntry, LockType.NONE, true, false);
                    }
                    while (status == OperationStatus.SUCCESS) {
                        this.env.getEvictor().doCriticalEviction(false);
                        FileSummaryLN ln = (FileSummaryLN)cursor.getCurrentLN(LockType.NONE);
                        if (ln == null) {
                            status = cursor.getNext(keyEntry, dataEntry, LockType.NONE, true, false);
                            continue;
                        }
                        byte[] keyBytes = keyEntry.getData();
                        boolean isOldVersion = ln.hasStringKey(keyBytes);
                        long fileNum = ln.getFileNumber(keyBytes);
                        Long fileNumLong = fileNum;
                        if (Arrays.binarySearch(existingFiles, fileNumLong) >= 0) {
                            FileSummary summary = ln.getBaseSummary();
                            this.fileSummaryMap.put(fileNumLong, summary);
                            if (isOldVersion && !this.env.isReadOnly()) {
                                this.insertFileSummary(ln, fileNum, 0);
                                cursor.latchBIN();
                                cursor.delete(ReplicationContext.NO_REPLICATE);
                            } else {
                                cursor.evict();
                            }
                        } else {
                            this.fileSummaryMap.remove(fileNumLong);
                            if (!this.env.isReadOnly()) {
                                if (isOldVersion) {
                                    cursor.latchBIN();
                                    cursor.delete(ReplicationContext.NO_REPLICATE);
                                } else {
                                    this.deleteFileSummary(fileNumLong, null);
                                }
                            }
                        }
                        if (isOldVersion) {
                            status = cursor.getNext(keyEntry, dataEntry, LockType.NONE, true, false);
                            continue;
                        }
                        if (this.getFirstFSLN(cursor, fileNum + 1L, keyEntry, dataEntry, LockType.NONE)) continue;
                        status = OperationStatus.NOTFOUND;
                    }
                }
                Object var16_14 = null;
                if (cursor == null) break block19;
            }
            catch (Throwable throwable) {
                Object var16_15 = null;
                if (cursor != null) {
                    cursor.releaseBINs();
                    cursor.close();
                }
                if (locker != null) {
                    locker.operationEnd();
                }
                int newMemorySize = this.fileSummaryMap.size() * MemoryBudget.UTILIZATION_PROFILE_ENTRY;
                MemoryBudget mb = this.env.getMemoryBudget();
                mb.updateAdminMemoryUsage(newMemorySize - oldMemorySize);
                throw throwable;
            }
            cursor.releaseBINs();
            cursor.close();
        }
        if (locker != null) {
            locker.operationEnd();
        }
        int newMemorySize = this.fileSummaryMap.size() * MemoryBudget.UTILIZATION_PROFILE_ENTRY;
        MemoryBudget mb = this.env.getMemoryBudget();
        mb.updateAdminMemoryUsage(newMemorySize - oldMemorySize);
        this.cachePopulated = true;
        return true;
    }

    private boolean getFirstFSLN(CursorImpl cursor, long fileNum, DatabaseEntry keyEntry, DatabaseEntry dataEntry, LockType lockType) throws DatabaseException {
        boolean exactKeyMatch;
        byte[] keyBytes = FileSummaryLN.makePartialKey(fileNum);
        keyEntry.setData(keyBytes);
        int result = cursor.searchAndPosition(keyEntry, dataEntry, CursorImpl.SearchMode.SET_RANGE, lockType);
        if ((result & 1) == 0) {
            return false;
        }
        boolean bl = exactKeyMatch = (result & 2) != 0;
        if (exactKeyMatch && cursor.getCurrentAlreadyLatched(keyEntry, dataEntry, lockType, true) != OperationStatus.KEYEMPTY) {
            return true;
        }
        cursor.evict(!exactKeyMatch);
        OperationStatus status = cursor.getNext(keyEntry, dataEntry, lockType, true, !exactKeyMatch);
        return status == OperationStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean openFileSummaryDatabase() throws DatabaseException {
        boolean bl;
        boolean operationOk;
        Txn autoTxn;
        block6: {
            boolean bl2;
            block5: {
                if (this.fileSummaryDb != null) {
                    return true;
                }
                DbTree dbTree = this.env.getDbTree();
                autoTxn = null;
                operationOk = false;
                try {
                    autoTxn = Txn.createAutoTxn(this.env, new TransactionConfig(), true, ReplicationContext.NO_REPLICATE);
                    DatabaseImpl db = dbTree.getDb(autoTxn, "_jeUtilization", null);
                    if (db == null) {
                        if (this.env.isReadOnly()) {
                            bl2 = false;
                            Object var7_7 = null;
                            if (autoTxn == null) return bl2;
                            break block5;
                        }
                        db = dbTree.createInternalDb(autoTxn, "_jeUtilization", new DatabaseConfig());
                    }
                    this.fileSummaryDb = db;
                    operationOk = true;
                    bl = true;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (autoTxn == null) throw throwable;
                    ((Locker)autoTxn).operationEnd(operationOk);
                    throw throwable;
                }
            }
            ((Locker)autoTxn).operationEnd(operationOk);
            return bl2;
        }
        Object var7_8 = null;
        if (autoTxn == null) return bl;
        ((Locker)autoTxn).operationEnd(operationOk);
        return bl;
    }

    public DatabaseImpl getFileSummaryDb() {
        return this.fileSummaryDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean insertFileSummary(FileSummaryLN ln, long fileNum, int sequence) throws DatabaseException {
        boolean bl;
        BasicLocker locker;
        block8: {
            CursorImpl cursor;
            block6: {
                boolean bl2;
                block7: {
                    byte[] keyBytes = FileSummaryLN.makeFullKey(fileNum, sequence);
                    locker = null;
                    cursor = null;
                    try {
                        locker = BasicLocker.createBasicLocker(this.env, false, true);
                        cursor = new CursorImpl(this.fileSummaryDb, locker);
                        OperationStatus status = cursor.putLN(keyBytes, ln, false, ReplicationContext.NO_REPLICATE);
                        if (status != OperationStatus.KEYEXIST) break block6;
                        this.env.getLogger().log(Level.SEVERE, "Cleaner duplicate key sequence file=0x" + Long.toHexString(fileNum) + " sequence=0x" + Long.toHexString(sequence));
                        bl2 = false;
                        Object var12_10 = null;
                        if (cursor == null) break block7;
                    }
                    catch (Throwable throwable) {
                        block9: {
                            Object var12_12 = null;
                            if (cursor != null) {
                                cursor.close();
                            }
                            if (locker == null) break block9;
                            locker.operationEnd();
                        }
                        throw throwable;
                    }
                    cursor.close();
                }
                if (locker != null) {
                    locker.operationEnd();
                }
                return bl2;
            }
            BIN bin = cursor.latchBIN();
            ln.addExtraMarshaledMemorySize(bin);
            cursor.releaseBIN();
            cursor.evict();
            bl = true;
            Object var12_11 = null;
            if (cursor == null) break block8;
            cursor.close();
        }
        if (locker != null) {
            locker.operationEnd();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyFileSummaryDatabase() throws DatabaseException {
        boolean ok;
        BasicLocker locker;
        block9: {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            this.openFileSummaryDatabase();
            locker = null;
            CursorImpl cursor = null;
            ok = true;
            try {
                locker = BasicLocker.createBasicLocker(this.env, false, true);
                cursor = new CursorImpl(this.fileSummaryDb, locker);
                cursor.setAllowEviction(true);
                if (cursor.positionFirstOrLast(true, null)) {
                    OperationStatus status = cursor.getCurrentAlreadyLatched(key, data, LockType.NONE, true);
                    while (status == OperationStatus.SUCCESS) {
                        this.env.getEvictor().doCriticalEviction(true);
                        FileSummaryLN ln = (FileSummaryLN)cursor.getCurrentLN(LockType.NONE);
                        if (ln == null) continue;
                        long fileNumVal = ln.getFileNumber(key.getData());
                        PackedOffsets offsets = ln.getObsoleteOffsets();
                        if (offsets != null) {
                            long[] vals = offsets.toArray();
                            for (int i = 0; i < vals.length; ++i) {
                                long lsn = DbLsn.makeLsn(fileNumVal, vals[i]);
                                if (this.verifyLsnIsObsolete(lsn)) continue;
                                ok = false;
                            }
                        }
                        cursor.evict();
                        status = cursor.getNext(key, data, LockType.NONE, true, false);
                    }
                }
                Object var16_13 = null;
                if (cursor == null) break block9;
            }
            catch (Throwable throwable) {
                Object var16_14 = null;
                if (cursor != null) {
                    cursor.close();
                }
                if (locker != null) {
                    locker.operationEnd();
                }
                throw throwable;
            }
            cursor.close();
        }
        if (locker != null) {
            locker.operationEnd();
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyLsnIsObsolete(long lsn) throws DatabaseException {
        boolean bl;
        block16: {
            IN bin;
            DatabaseImpl db;
            block14: {
                boolean bl2;
                block15: {
                    int index;
                    block12: {
                        boolean bl3;
                        block13: {
                            block10: {
                                boolean bl4;
                                block11: {
                                    LNLogEntry entry;
                                    block8: {
                                        boolean bl5;
                                        block9: {
                                            LogEntry o = this.env.getLogManager().getLogEntry(lsn);
                                            if (!(o instanceof LNLogEntry)) {
                                                return true;
                                            }
                                            entry = (LNLogEntry)o;
                                            if (entry.getLN().isDeleted()) {
                                                return true;
                                            }
                                            DatabaseId dbId = entry.getDbId();
                                            db = this.env.getDbTree().getDb(dbId);
                                            bin = null;
                                            try {
                                                if (db != null && !db.isDeleted()) break block8;
                                                bl5 = true;
                                                Object var14_9 = null;
                                                this.env.getDbTree().releaseDb(db);
                                                if (bin == null) break block9;
                                            }
                                            catch (Throwable throwable) {
                                                block17: {
                                                    Object var14_14 = null;
                                                    this.env.getDbTree().releaseDb(db);
                                                    if (bin == null) break block17;
                                                    bin.releaseLatch();
                                                }
                                                throw throwable;
                                            }
                                            bin.releaseLatch();
                                        }
                                        return bl5;
                                    }
                                    Tree tree = db.getTree();
                                    TreeLocation location = new TreeLocation();
                                    boolean parentFound = tree.getParentBINForChildLN(location, entry.getKey(), entry.getDupKey(), entry.getLN(), false, true, false, CacheMode.UNCHANGED);
                                    bin = location.bin;
                                    index = location.index;
                                    if (parentFound) break block10;
                                    bl4 = true;
                                    Object var14_10 = null;
                                    this.env.getDbTree().releaseDb(db);
                                    if (bin == null) break block11;
                                    bin.releaseLatch();
                                }
                                return bl4;
                            }
                            if (!bin.isEntryKnownDeleted(index)) break block12;
                            bl3 = true;
                            Object var14_11 = null;
                            this.env.getDbTree().releaseDb(db);
                            if (bin == null) break block13;
                            bin.releaseLatch();
                        }
                        return bl3;
                    }
                    if (bin.getLsn(index) == lsn) break block14;
                    bl2 = true;
                    Object var14_12 = null;
                    this.env.getDbTree().releaseDb(db);
                    if (bin == null) break block15;
                    bin.releaseLatch();
                }
                return bl2;
            }
            System.err.println("lsn " + DbLsn.getNoFormatString(lsn) + " was found in tree.");
            bl = false;
            Object var14_13 = null;
            this.env.getDbTree().releaseDb(db);
            if (bin == null) break block16;
            bin.releaseLatch();
        }
        return bl;
    }

    void close() {
        this.clearCache();
        if (this.fileSummaryDb != null) {
            this.fileSummaryDb.releaseTreeAdminMemory();
        }
    }

    private class FilesToMigrate {
        private long[] forceCleanFiles;
        private int upgradeToVersion;
        private boolean checkLogVersion;
        private boolean nextAvailable;
        private long nextFile;

        FilesToMigrate() throws DatabaseException {
            String forceCleanProp = UtilizationProfile.this.env.getConfigManager().get(EnvironmentParams.CLEANER_FORCE_CLEAN_FILES);
            this.parseForceCleanFiles(forceCleanProp);
            this.upgradeToVersion = UtilizationProfile.this.env.getConfigManager().getInt(EnvironmentParams.CLEANER_UPGRADE_TO_LOG_VERSION);
            if (this.upgradeToVersion == -1) {
                this.upgradeToVersion = 6;
            }
            this.checkLogVersion = this.upgradeToVersion != 0;
            this.nextAvailable = false;
            this.nextFile = -1L;
        }

        boolean hasNext() throws DatabaseException {
            if (this.nextAvailable) {
                return true;
            }
            long foundFile = -1L;
            for (long file : UtilizationProfile.this.fileSummaryMap.tailMap(this.nextFile + 1L).keySet()) {
                if (this.isForceCleanFile(file)) {
                    foundFile = file;
                    break;
                }
                if (!this.checkLogVersion) continue;
                try {
                    int logVersion = UtilizationProfile.this.env.getFileManager().getFileLogVersion(file);
                    if (logVersion < this.upgradeToVersion) {
                        foundFile = file;
                        break;
                    }
                    this.checkLogVersion = false;
                }
                catch (DatabaseException e) {
                    this.nextFile = file;
                    throw e;
                }
            }
            if (foundFile != -1L) {
                this.nextFile = foundFile;
                this.nextAvailable = true;
                return true;
            }
            return false;
        }

        long next() throws NoSuchElementException, DatabaseException {
            if (this.hasNext()) {
                this.nextAvailable = false;
                return this.nextFile;
            }
            throw new NoSuchElementException();
        }

        private boolean isForceCleanFile(long file) {
            if (this.forceCleanFiles != null) {
                for (int i = 0; i < this.forceCleanFiles.length; i += 2) {
                    long from = this.forceCleanFiles[i];
                    long to = this.forceCleanFiles[i + 1];
                    if (file < from || file > to) continue;
                    return true;
                }
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void parseForceCleanFiles(String propValue) throws IllegalArgumentException {
            if (propValue == null || propValue.length() == 0) {
                this.forceCleanFiles = null;
                return;
            }
            String errPrefix = "Error in " + EnvironmentParams.CLEANER_FORCE_CLEAN_FILES.getName() + "=" + propValue + ": ";
            StringTokenizer tokens = new StringTokenizer(propValue, ",-", true);
            ArrayList<Long> list = new ArrayList<Long>();
            while (tokens.hasMoreTokens()) {
                long fromNum;
                String fromStr = tokens.nextToken();
                try {
                    fromNum = Long.parseLong(fromStr, 16);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(errPrefix + "Invalid hex file number: " + fromStr);
                }
                long toNum = -1L;
                if (tokens.hasMoreTokens()) {
                    String delim = tokens.nextToken();
                    if (",".equals(delim)) {
                        toNum = fromNum;
                    } else {
                        if (!"-".equals(delim)) throw new IllegalArgumentException(errPrefix + "Expected '-' or ',': " + delim);
                        if (!tokens.hasMoreTokens()) throw new IllegalArgumentException(errPrefix + "Expected file number: " + delim);
                        String toStr = tokens.nextToken();
                        try {
                            toNum = Long.parseLong(toStr, 16);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException(errPrefix + "Invalid hex file number: " + toStr);
                        }
                    }
                } else {
                    toNum = fromNum;
                }
                assert (toNum != -1L);
                list.add(fromNum);
                list.add(toNum);
            }
            this.forceCleanFiles = new long[list.size()];
            for (int i = 0; i < this.forceCleanFiles.length; ++i) {
                this.forceCleanFiles[i] = (Long)list.get(i);
            }
        }
    }
}

