/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.xkms.util;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.Hashtable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XKMSUtils {
    public static final String DEFAULT_SecretKEY_Algo = "HmacSHA1";
    public static final AlgorithmIdentifier sha_1 = new AlgorithmIdentifier(new ASN1ObjectID(ASN1Utils.oiwAlgID, 26));
    public static final AlgorithmIdentifier md5 = new AlgorithmIdentifier(new ASN1ObjectID(ASN1Utils.rsaID, 2, 5));
    public static final AlgorithmIdentifier dsaWithSHA1 = new AlgorithmIdentifier(new ASN1ObjectID(ASN1Utils.xcmID, 3));
    public static final AlgorithmIdentifier id_dsa_with_sha_1 = new AlgorithmIdentifier(dsaWithSHA1.getOID(), false);
    public static final AlgorithmIdentifier id_dsaWithSHA = new AlgorithmIdentifier(new ASN1ObjectID(ASN1Utils.oiwAlgID, 13));
    public static final AlgorithmIdentifier dsaWithSHA = new AlgorithmIdentifier(id_dsaWithSHA.getOID(), false);
    public static final AlgorithmIdentifier id_dsaWithSHA1Old = new AlgorithmIdentifier(new ASN1ObjectID(ASN1Utils.oiwAlgID, 27));
    public static final AlgorithmIdentifier dsaWithSHA1Old = new AlgorithmIdentifier(id_dsaWithSHA1Old.getOID(), false);
    public static final AlgorithmIdentifier rsaEncryption = new AlgorithmIdentifier(new ASN1ObjectID(ASN1Utils.pkcsID, 1, 1));
    public static final AlgorithmIdentifier dh_public_number = new AlgorithmIdentifier(new ASN1ObjectID(new int[]{1, 2, 840, 10046, 2, 1}));
    public static final AlgorithmIdentifier id_alg_ESDH = new AlgorithmIdentifier(new ASN1ObjectID(ASN1Utils.pkcsID, 9, 16, 3, 5));
    public static final AlgorithmIdentifier id_alg_XKMS3DESwrap = new AlgorithmIdentifier(new ASN1ObjectID(ASN1Utils.pkcsID, 9, 16, 3, 6));
    public static final AlgorithmIdentifier id_alg_XKMSRC2wrap = new AlgorithmIdentifier(new ASN1ObjectID(ASN1Utils.pkcsID, 9, 16, 3, 7));
    public static final AlgorithmIdentifier rc2_cbc = new AlgorithmIdentifier(new ASN1ObjectID(ASN1Utils.rsaID, 3, 2));
    public static final AlgorithmIdentifier hmac_SHA_1 = new AlgorithmIdentifier(new ASN1ObjectID(ASN1Utils.iana, 1, 2));
    public static final AlgorithmIdentifier des_ede3_cbc = new AlgorithmIdentifier(new ASN1ObjectID(ASN1Utils.rsaID, 3, 7));
    private static Hashtable algoNamemap = null;
    private static Hashtable algoIdmap = null;

    public static byte[] secretString2Bytes(String secret) throws UnsupportedEncodingException {
        byte[] saslBytes = XKMSUtils.doSASLStringPrep(new String(secret.getBytes("UTF-8"), "UTF-8"));
        return new String(saslBytes, "UTF-8").getBytes("UTF-8");
    }

    private static byte[] doSASLStringPrep(String uStr) throws UnsupportedEncodingException {
        String tmp = uStr.trim();
        StringBuffer sb = new StringBuffer();
        sb = new StringBuffer();
        for (int i = 0; i < tmp.length(); ++i) {
            char c = tmp.charAt(i);
            if (c == '\u00a0' || c == '\u1680' || c >= '\u2000' && c <= '\u200b' || c == '\u202f' || c == '\u205f' || c == '\u3000' || c == '\u007f' || c >= '\u0000' && c <= '\u001f' || c >= '\u0080' && c <= '\u009f' || c == '\u06dd' || c == '\u070f' || c == '\u180e' || c == '\u200c' || c == '\u200d' || c == '\u2028' || c == '\u2029' || c == '\u2060' || c == '\u2061' || c == '\u2062' || c == '\u2063' || c >= '\u206a' && c <= '\u206f' || c == '\ufeff' || c >= '\ufff9' && c <= '\ufffc' || c >= '\ue000' && c <= '\uf8ff' || c >= '\ufdd0' && c <= '\ufdef' || c == '\ufffe' || c == '\uffff' || c >= '\ud800' && c <= '\udfff' || c == '\ufff9' || c == '\ufffa' || c == '\ufffb' || c == '\ufffc' || c == '\ufffd' || c >= '\u2ff0' && c <= '\u2ffb' || c == '\u0340' || c == '\u0341' || c == '\u200e' || c == '\u200f' || c >= '\u202a' && c <= '\u202e' || c >= '\u206a' && c <= '\u206f') continue;
            sb.append(c);
        }
        return sb.toString().toLowerCase().getBytes("UTF-8");
    }

    public static byte[] doMacAuthN(byte[] data, AlgorithmIdentifier hashAlgID) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        String algoName = XKMSUtils.getAlgoName(hashAlgID);
        Mac mac = Mac.getInstance(algoName);
        SecretKeySpec sks = new SecretKeySpec(new byte[]{1}, DEFAULT_SecretKEY_Algo);
        mac.init(sks);
        mac.update(data);
        byte[] macBytes = mac.doFinal();
        return macBytes;
    }

    public static byte[] doMacRC(byte[] data, AlgorithmIdentifier hashAlgID) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        String algoName = XKMSUtils.getAlgoName(hashAlgID);
        Mac mac = Mac.getInstance(algoName);
        SecretKeySpec sks = new SecretKeySpec(new byte[]{2}, DEFAULT_SecretKEY_Algo);
        mac.init(sks);
        mac.update(data);
        byte[] macBytes = mac.doFinal();
        return macBytes;
    }

    public static byte[] doMacRCI(byte[] data, AlgorithmIdentifier hashAlgID) throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        String algoName = XKMSUtils.getAlgoName(hashAlgID);
        Mac mac = Mac.getInstance(algoName);
        SecretKeySpec sks = new SecretKeySpec(new byte[]{2}, DEFAULT_SecretKEY_Algo);
        mac.init(sks);
        mac.update(data);
        byte[] pass1 = mac.doFinal();
        mac = Mac.getInstance(algoName);
        sks = new SecretKeySpec(new byte[]{3}, DEFAULT_SecretKEY_Algo);
        mac.init(sks);
        return mac.doFinal(pass1);
    }

    public static byte[] doMacPrivateKey(byte[] data, AlgorithmIdentifier hashAlgID, int length) throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        String algoName = XKMSUtils.getAlgoName(hashAlgID);
        Mac mac = Mac.getInstance(algoName);
        SecretKeySpec sks = new SecretKeySpec(new byte[]{4}, DEFAULT_SecretKEY_Algo);
        mac.init(sks);
        byte[] privKey = mac.doFinal(data);
        if (length <= privKey.length) {
            byte[] keybytes = new byte[length];
            System.arraycopy(privKey, privKey.length - length, keybytes, 0, length);
            return keybytes;
        }
        byte[] keybytes = new byte[length];
        byte[] key = new byte[]{4};
        boolean done = false;
        byte[] prev = privKey;
        int free = length - privKey.length;
        System.arraycopy(privKey, 0, keybytes, 0, privKey.length);
        int n = 1;
        while (!done || n - 1 < length) {
            key = XKMSUtils.xor(prev, key);
            mac = Mac.getInstance(algoName);
            sks = new SecretKeySpec(key, DEFAULT_SecretKEY_Algo);
            mac.init(sks);
            prev = mac.doFinal(data);
            if (prev.length >= free) {
                System.arraycopy(prev, 0, keybytes, length - free, free);
                return keybytes;
            }
            System.arraycopy(prev, 0, keybytes, length - free, prev.length);
            free -= prev.length;
            ++n;
        }
        return keybytes;
    }

    public static void insertChild(XMLElement parent, XMLElement e, String[] tag, String[] ns) throws DOMException {
        XKMSUtils.insertChild((Element)parent.getNode(), (Element)e.getNode(), tag, ns);
    }

    public static void insertChild(Element parent, Element e, String[] tag, String[] ns) throws DOMException {
        Node after = null;
        if (tag != null && ns != null) {
            if (tag.length != ns.length) {
                throw new IllegalArgumentException("Tag list and namespace list must correspond");
            }
            for (int i = tag.length - 1; i >= 0 && after == null; --i) {
                NodeList nList = XMLElement.getChildElementsByTagNameNS((Element)parent, (String)ns[i], (String)tag[i]);
                if (nList.getLength() <= 0) continue;
                after = nList.item(nList.getLength() - 1);
            }
        } else if (tag == null ^ ns == null) {
            throw new IllegalArgumentException("Tag list and namespace list must correspond");
        }
        Node before = null;
        before = after != null ? after.getNextSibling() : parent.getFirstChild();
        if (before != null) {
            parent.insertBefore(e, before);
        } else {
            parent.appendChild(e);
        }
    }

    public static void removeChildren(Element parent, String tag, String ns) {
        NodeList nList = XMLElement.getChildElementsByTagNameNS((Element)parent, (String)ns, (String)tag);
        for (int i = nList.getLength(); i > 0; --i) {
            parent.removeChild(nList.item(i - 1));
        }
    }

    public static byte[] generateNonce(Date time, BigInteger serialNo, byte[] secretKey, AlgorithmIdentifier hmacAlgID) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        byte[] t = Utils.formatDate((Date)time, (boolean)true).getBytes();
        byte[] s = serialNo.toString().getBytes();
        String algoName = XKMSUtils.getAlgoName(hmacAlgID);
        Mac mac = Mac.getInstance(algoName);
        SecretKeySpec sks = new SecretKeySpec(secretKey, DEFAULT_SecretKEY_Algo);
        mac.init(sks);
        mac.update(t, 0, t.length);
        mac.update(s, 0, s.length);
        byte[] m = mac.doFinal();
        byte[] nonce = new byte[t.length + s.length + m.length];
        System.arraycopy(t, 0, nonce, 0, t.length);
        System.arraycopy(s, 0, nonce, t.length, s.length);
        System.arraycopy(m, 0, nonce, t.length + s.length, m.length);
        return nonce;
    }

    public static XMLElement getInstance(Element element) throws DOMException {
        return XMLUtils.getInstance((Element)element, null, (String)"http://www.w3.org/2002/03/xkms#");
    }

    private static void setMapping() {
        algoNamemap = new Hashtable();
        algoIdmap = new Hashtable();
        XKMSUtils.setAlgoName("SHA 1", sha_1);
        XKMSUtils.setAlgoName("MD5", md5);
        XKMSUtils.setAlgoName("SHA1withDSA", id_dsa_with_sha_1);
        XKMSUtils.setAlgoName("SHAwithDSA", dsaWithSHA);
        XKMSUtils.setAlgoName("RSA", rsaEncryption);
        XKMSUtils.setAlgoName("DESede", id_alg_XKMS3DESwrap);
        XKMSUtils.setAlgoName("RC2", id_alg_XKMSRC2wrap);
        XKMSUtils.setAlgoName("DES/CBC", des_ede3_cbc);
        XKMSUtils.setAlgoName("RC2/CBC", rc2_cbc);
        XKMSUtils.setAlgoName(DEFAULT_SecretKEY_Algo, hmac_SHA_1);
    }

    private static AlgorithmIdentifier setAlgoName(String name, AlgorithmIdentifier oid) {
        algoNamemap.put(oid, name);
        return algoIdmap.put(name.toUpperCase(), oid);
    }

    public static AlgorithmIdentifier getAlgoID(String name) throws NoSuchAlgorithmException {
        AlgorithmIdentifier oid;
        if (algoIdmap == null) {
            XKMSUtils.setMapping();
        }
        if ((oid = (AlgorithmIdentifier)algoIdmap.get(name.toUpperCase())) == null) {
            throw new NoSuchAlgorithmException();
        }
        return oid;
    }

    public static String getAlgoName(AlgorithmIdentifier oid) throws NoSuchAlgorithmException {
        String name;
        if (algoNamemap == null) {
            XKMSUtils.setMapping();
        }
        if ((name = (String)algoNamemap.get(oid)) == null) {
            throw new NoSuchAlgorithmException();
        }
        return name;
    }

    public static byte[] xor(byte[] a, byte[] b) {
        int aLen = a.length;
        int bLen = b.length;
        if (aLen >= bLen) {
            byte[] c = new byte[aLen];
            for (int i = 0; i < aLen; ++i) {
                c[i] = i < bLen ? (byte)(a[i] ^ b[i]) : a[i];
            }
            return c;
        }
        return XKMSUtils.xor(b, a);
    }
}

