/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.xkms;

import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.xkms.Message;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Result
extends Message {
    public Result(Element element) throws DOMException {
        super(element);
    }

    public Result(Document owner) throws DOMException {
        super(owner, "Result");
    }

    public Result(Document owner, String systemId) throws DOMException {
        super(owner, "Result", systemId);
    }

    public Result(Document owner, String tagName, String systemId) throws DOMException {
        super(owner, tagName, systemId);
    }

    public void setResultCode(String major, String minor) throws DOMException {
        this.setAttribute("ResultMajor", major);
        this.setAttribute("ResultMinor", minor);
        this.clearSignature();
    }

    public String getResultMajor() {
        if (this.hasAttribute("ResultMajor")) {
            return this.getAttribute("ResultMajor");
        }
        return null;
    }

    public String getResultMinor() {
        if (this.hasAttribute("ResultMinor")) {
            return this.getAttribute("ResultMinor");
        }
        return null;
    }

    public void setRequestID(String requestID) throws DOMException {
        this.setAttribute("RequestId", requestID);
        this.clearSignature();
    }

    public String getRequestID() {
        if (this.hasAttribute("RequestId")) {
            return this.getAttribute("RequestId");
        }
        return null;
    }

    public void setRequestSignatureValue(byte[] sigBytes, String id) throws DOMException {
        this.removeChildren("RequestSignatureValue", "http://www.w3.org/2002/03/xkms#");
        Element rw = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "RequestSignatureValue");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)rw);
        rw.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64((byte[])sigBytes, (boolean)false)));
        if (id != null) {
            rw.setAttribute("Id", id);
        }
        this.insertChild(rw, new String[]{"Signature", "MessageExtension", "OpaqueClientData"}, new String[]{"http://www.w3.org/2000/09/xmldsig#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#"});
        this.clearSignature();
    }

    public Element getRequestSignatureValue() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "RequestSignatureValue");
        if (nList.getLength() != 0) {
            return (Element)nList.item(0);
        }
        return null;
    }

    public byte[] getRequestSignatureBytes() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "RequestSignatureValue");
        if (nList.getLength() != 0) {
            Element s = (Element)nList.item(0);
            s.normalize();
            Text sText = (Text)s.getFirstChild();
            if (sText != null) {
                return Base64.fromBase64((String)sText.getData());
            }
        }
        return null;
    }
}

