/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.xkms;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.xkms.Message;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class Request
extends Message {
    protected Request(Element element) throws DOMException {
        super(element);
    }

    protected Request(Document owner, String tagName) throws DOMException {
        super(owner, tagName);
    }

    protected Request(Document owner, String tagName, String systemId) throws DOMException {
        super(owner, tagName, systemId);
    }

    public void setOriginalRequestID(String origRequestID) throws DOMException {
        this.setAttribute("OriginalRequestId", origRequestID);
        this.clearSignature();
    }

    public String getOriginalRequestID() {
        if (this.hasAttribute("OriginalRequestId")) {
            return this.getAttribute("OriginalRequestId");
        }
        return null;
    }

    public void setResponseLimit(BigInteger limit) throws DOMException {
        this.setAttribute("ResponseLimit", limit.toString());
        this.clearSignature();
    }

    public BigInteger getResponseLimit() {
        if (this.hasAttribute("ResponseLimit")) {
            return new BigInteger(this.getAttribute("ResponseLimit"));
        }
        return null;
    }

    public void addResponseMechanism(String responseMech) throws DOMException {
        Element rw = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "ResponseMechanism");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)rw);
        rw.appendChild(this.getOwnerDocument().createTextNode(responseMech));
        this.insertChild(rw, new String[]{"Signature", "MessageExtension", "OpaqueClientData", "ResponseMechanism"}, new String[]{"http://www.w3.org/2000/09/xmldsig#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#"});
        this.clearSignature();
    }

    public List getResponseMechanisms() {
        ArrayList<String> v = new ArrayList<String>();
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "ResponseMechanism");
        int x = nList.getLength();
        for (int i = 0; i < x; ++i) {
            Element r = (Element)nList.item(i);
            Text rText = (Text)r.getFirstChild();
            if (rText == null) continue;
            v.add(rText.getData());
        }
        return v;
    }

    public void addRespondWith(String responseID) throws DOMException {
        Element rw = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "RespondWith");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)rw);
        rw.appendChild(this.getOwnerDocument().createTextNode(responseID));
        this.insertChild(rw, new String[]{"Signature", "MessageExtension", "OpaqueClientData", "ResponseMechanism", "RespondWith"}, new String[]{"http://www.w3.org/2000/09/xmldsig#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#"});
        this.clearSignature();
    }

    public List getRespondWiths() {
        ArrayList<String> v = new ArrayList<String>();
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "RespondWith");
        int x = nList.getLength();
        for (int i = 0; i < x; ++i) {
            Element r = (Element)nList.item(i);
            Text rText = (Text)r.getFirstChild();
            if (rText == null) continue;
            v.add(rText.getData());
        }
        return v;
    }

    public void setPendingNotification(String mechanism, String identifier) throws DOMException {
        this.removeChildren("PendingNotification", "http://www.w3.org/2002/03/xkms#");
        Element pn = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "PendingNotification");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)pn);
        pn.setAttribute("Mechanism", mechanism);
        pn.setAttribute("Identifier", identifier);
        this.insertChild(pn, new String[]{"Signature", "MessageExtension", "OpaqueClientData", "ResponseMechanism", "RespondWith"}, new String[]{"http://www.w3.org/2000/09/xmldsig#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#"});
        this.clearSignature();
    }

    public String getPendingNotificationMechanism() {
        Element pn;
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "PendingNotification");
        if (nList.getLength() != 0 && (pn = (Element)nList.item(0)).hasAttribute("Mechanism")) {
            return pn.getAttribute("Mechanism");
        }
        return null;
    }

    public String getPendingNotificationIdentifier() {
        Element pn;
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "PendingNotification");
        if (nList.getLength() != 0 && (pn = (Element)nList.item(0)).hasAttribute("Identifier")) {
            return pn.getAttribute("Identifier");
        }
        return null;
    }
}

