/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.xkms;

import java.util.Date;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.xkms.AbstractKeyBinding;
import oracle.security.xmlsec.xkms.util.XKMSUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PrototypeKeyBinding
extends AbstractKeyBinding {
    public PrototypeKeyBinding(Element element) throws DOMException {
        super(element);
    }

    public PrototypeKeyBinding(Document owner) throws DOMException {
        super(owner, "PrototypeKeyBinding");
    }

    public PrototypeKeyBinding(Document owner, String systemId) throws DOMException {
        super(owner, "PrototypeKeyBinding", systemId);
    }

    public void setValidityInterval(Date notBefore, Date notOnOrAfter) throws DOMException {
        XKMSUtils.removeChildren((Element)this.getNode(), "http://www.w3.org/2002/03/xkms#", "ValidityInterval");
        Element pn = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "ValidityInterval");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)pn);
        if (notBefore != null) {
            pn.setAttribute("NotBefore", XMLUtils.formatDateTime((Date)notBefore));
        }
        if (notOnOrAfter != null) {
            pn.setAttribute("NotOnOrAfter", XMLUtils.formatDateTime((Date)notOnOrAfter));
        }
        XKMSUtils.insertChild((Element)this.getNode(), pn, new String[]{"KeyInfo", "KeyUsage", "UseKeyWith"}, new String[]{"http://www.w3.org/2000/09/xmldsig#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#"});
    }

    public Date getValidityNotBefore() {
        Element v;
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "ValidityInterval");
        if (nList.getLength() != 0 && (v = (Element)nList.item(0)).hasAttribute("NotBefore")) {
            return XMLUtils.parseDateTime((String)v.getAttribute("NotBefore"));
        }
        return null;
    }

    public Date getValidityNotOnOrAfter() {
        Element v;
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "ValidityInterval");
        if (nList.getLength() != 0 && (v = (Element)nList.item(0)).hasAttribute("NotOnOrAfter")) {
            return XMLUtils.parseDateTime((String)v.getAttribute("NotOnOrAfter"));
        }
        return null;
    }

    public void setRevocationCodeIdentifier(byte[] data) throws DOMException {
        XKMSUtils.removeChildren((Element)this.getNode(), "http://www.w3.org/2002/03/xkms#", "RevocationCodeIdentifier");
        Element pn = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "RevocationCodeIdentifier");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)pn);
        pn.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64((byte[])data, (boolean)false)));
        XKMSUtils.insertChild((Element)this.getNode(), pn, new String[]{"KeyInfo", "KeyUsage", "UseKeyWith", "ValidityInterval"}, new String[]{"http://www.w3.org/2000/09/xmldsig#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#"});
    }

    public byte[] getRevocationCodeIdentifier() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "RevocationCodeIdentifier");
        if (nList.getLength() != 0) {
            Element s = (Element)nList.item(0);
            s.normalize();
            Text sText = (Text)s.getFirstChild();
            if (sText != null) {
                return Base64.fromBase64((String)sText.getData());
            }
        }
        return null;
    }
}

