/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.share;

import java.awt.Window;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFilter;
import oracle.ide.util.IdeUtil;
import oracle.ide.vcs.VCSManager;
import oracle.ide.wizard.Wizard;
import oracle.ideimpl.vcscore.VersioningRegistrations;
import oracle.javatools.dialogs.ExceptionDialog;

public class ShareWizard
extends Wizard {
    private static final Collection<Wizard> _wizards = new ArrayList<Wizard>();
    private final int _cmdId;
    private final String _name;
    private final Icon _icon;

    public ShareWizard(String name, Icon icon, int cmdId) {
        this._cmdId = cmdId;
        this._name = name;
        this._icon = icon;
    }

    public boolean isAvailable(Context context) {
        URLFilter filter = this.getURLFilter();
        for (Locatable locatable : VCSManager.getVCSManager().getContextLocatables(context)) {
            URL url = locatable.getURL();
            if (url == null || !filter.accept(url)) continue;
            return true;
        }
        return false;
    }

    protected URLFilter getURLFilter() {
        return new URLFilter(){

            public final boolean accept(URL url) {
                return url.getProtocol().equals("file");
            }
        };
    }

    public boolean invoke(Context context) {
        try {
            IdeAction.find((int)this._cmdId).performAction(context);
            return true;
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)IdeUtil.getMainWindow(), (Exception)e);
            return false;
        }
    }

    public String getShortLabel() {
        return this._name;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public static final void registerShareWizard(Wizard wizard) {
        _wizards.add(wizard);
    }

    static final Collection<Wizard> getAvailableWizards(Context context) {
        VersioningRegistrations.getInstance();
        ArrayList<Wizard> wizards = new ArrayList<Wizard>();
        for (Wizard wizard : _wizards) {
            if (!wizard.isAvailable(context)) continue;
            wizards.add(wizard);
        }
        return wizards;
    }
}

