/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.vcscore;

import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import oracle.ide.javaxide.Util;
import oracle.ide.vcs.VCS;
import oracle.ide.vcscore.FileContentProvider;
import oracle.ideimpl.vcscore.FileContentProviderRegistry;
import oracle.ideimpl.vcscore.VersioningRegistration;
import oracle.ideimpl.vcscore.VersioningRegistrations;
import oracle.ideimpl.vcscore.nav.ConnectionProvider;
import oracle.ideimpl.vcscore.nav.ConnectionProviderRegistry;

public final class VersioningRegisterProxy
implements Observer {
    private final ExecutorService _executor = new ThreadPoolExecutor(0, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
        private final ThreadFactory _delegate = Executors.defaultThreadFactory();

        @Override
        public final Thread newThread(Runnable r) {
            Thread t = this._delegate.newThread(r);
            t.setName("VersioningRegisterProxy");
            return t;
        }
    });

    @Override
    public void update(Observable o, final Object arg) {
        this._executor.submit(new Runnable(){

            @Override
            public final void run() {
                String id = ((VCS)arg).getId();
                for (VersioningRegistration registration : VersioningRegistrations.getInstance().getRegistrations()) {
                    if (id.equals(registration.getExtensionID()) && ConnectionProviderRegistry.getInstance().lookupProvider(id) == null) {
                        ConnectionProviderRegistry.getInstance().registerProvider(id, (ConnectionProvider)Util.createInstance(registration.getConnectionProviderClass(), ConnectionProvider.class));
                    }
                    if (!id.equals(registration.getExtensionID()) || FileContentProviderRegistry.getInstance().lookupProvider(id) != null) continue;
                    FileContentProviderRegistry.getInstance().registerProvider(id, (FileContentProvider)Util.createInstance(registration.getFileContentProviderClass(), FileContentProvider.class));
                }
            }
        });
    }
}

