/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.vcscore;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.SelectFilesConfiguration;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.model.Displayable;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.MnemonicSolver;
import oracle.ideimpl.extension.OldStyleMenuUtil;
import oracle.ideimpl.vcs.VCSModelUtil;
import oracle.ideimpl.vcscore.res.Bundle;
import oracle.javatools.dialogs.MessageDialog;

public final class VersioningCoreUtil {
    private static final String SKIP_SAVE_FILES_PERSISTENCE_KEY = "VCS.SaveFilesConfirm";

    private VersioningCoreUtil() {
    }

    @Deprecated
    public static final JMenu getViewTeamSubmenu() {
        return VersioningCoreUtil.getWindowTeamSubmenu();
    }

    public static final JMenu getWindowTeamSubmenu() {
        if (OldStyleMenuUtil.getInstance().isOldStyleMenu()) {
            return null;
        }
        Menubar menubar = Ide.getMenubar();
        JMenu teammenu = Menubar.getJMenu((String)"VIEW_TEAM_SUB_MENU");
        if (teammenu != null) {
            return teammenu;
        }
        String menuname = Bundle.get("VIEW_TEAM_SUB_MENU_NAME");
        int mnemonic = StringUtils.getMnemonicKeyCode((String)menuname);
        String realText = StringUtils.stripMnemonic((String)menuname);
        JMenu teamSubmenu = menubar.createSubMenu(realText, Integer.valueOf(mnemonic));
        Menubar.putJMenu((String)"VIEW_TEAM_SUB_MENU", (JMenu)teamSubmenu);
        return teamSubmenu;
    }

    public static final boolean saveDirtyNodes(Locatable[] locatables) throws Exception {
        return VersioningCoreUtil.saveDirtyNodes(locatables, MessageDialog.getPersistence().isHidden(SKIP_SAVE_FILES_PERSISTENCE_KEY), null);
    }

    public static final boolean saveDirtyNodesSilently(Locatable[] locatables) throws Exception {
        return VersioningCoreUtil.saveDirtyNodes(locatables, true, null);
    }

    @Deprecated
    public static final boolean saveDirtyNodes(final Locatable[] locatables, final boolean silent, final String helpTopicId) throws Exception {
        if (!EventQueue.isDispatchThread()) {
            final boolean[] result = new boolean[1];
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public final void run() {
                        try {
                            result[0] = VersioningCoreUtil.saveDirtyNodes(locatables, silent, helpTopicId);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                if (ite.getTargetException() instanceof Exception) {
                    throw (Exception)ite.getTargetException();
                }
                ite.printStackTrace();
            }
            return result[0];
        }
        ArrayList<URL> directoryUrls = new ArrayList<URL>();
        Node[] nodes = VersioningCoreUtil.getDirtyNodes(locatables, directoryUrls);
        return VersioningCoreUtil.saveDirtyNodesImpl(nodes, directoryUrls.toArray(new URL[0]), silent, helpTopicId);
    }

    private static final Node[] getDirtyNodes(Locatable[] locatables, Collection<URL> directoryUrls) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < locatables.length; ++i) {
            URL url = locatables[i].getURL();
            if (url == null) continue;
            if (locatables[i] instanceof Node) {
                nodes.add((Node)locatables[i]);
                continue;
            }
            if (!URLFileSystem.isDirectoryPath((URL)url)) continue;
            directoryUrls.add(url);
        }
        return VersioningCoreUtil.getDirtyNodes(nodes.toArray(new Node[0]));
    }

    public static final Node[] getDirtyNodes(Node[] nodes) {
        ArrayList<Node> dirtyables = new ArrayList<Node>();
        for (int i = 0; i < nodes.length; ++i) {
            if (!nodes[i].isDirty()) continue;
            dirtyables.add(nodes[i]);
        }
        return dirtyables.toArray(new Node[0]);
    }

    private static final boolean saveDirtyNodesImpl(Node[] nodes, URL[] directoryUrls, boolean silent, String helpTopicId) throws Exception {
        if (nodes.length <= 0) {
            return true;
        }
        if (!silent) {
            SelectFilesConfiguration selectFilesConfiguration = new SelectFilesConfiguration((Component)VersioningCoreUtil.getCurrentWindow(), Bundle.get("PROMPT_SAVE_FILES"), Bundle.format("PROMPT_SAVE_SINGLE_MODIFIED_FILE", URLFileSystem.getPlatformPathName((URL)nodes[0].getURL())), Bundle.get("PROMPT_SAVE_MODIFIED_FILES"), VersioningCoreUtil.createCheckBoxListModel(nodes, false), false, 1, helpTopicId);
            selectFilesConfiguration.setOptionalId(SKIP_SAVE_FILES_PERSISTENCE_KEY);
            int ans = SelectFilesPanel.showDialog((SelectFilesConfiguration)selectFilesConfiguration);
            if (ans == 2) {
                return false;
            }
            if (ans == 1) {
                return true;
            }
        }
        for (int i = 0; i < nodes.length; ++i) {
            URL url = nodes[i].getURL();
            if (URLFileSystem.exists((URL)url) && !URLFileSystem.setReadOnly((URL)url, (boolean)false)) continue;
            nodes[i].save();
        }
        return true;
    }

    public static final Window getCurrentWindow() {
        Window window = IdeUtil.findActiveModalWindow();
        return window != null ? window : IdeUtil.getMainWindow();
    }

    public static final CheckBoxListModel createCheckBoxListModel(Object[] userObjects, boolean checkedList) {
        CheckBoxListModel model = new CheckBoxListModel();
        for (int i = 0; i < userObjects.length; ++i) {
            String longLabel;
            Icon icon;
            if (userObjects[i] instanceof Displayable) {
                Displayable d = (Displayable)userObjects[i];
                icon = d.getIcon();
                longLabel = d.getLongLabel();
            } else {
                icon = null;
                longLabel = userObjects[i].toString();
            }
            model.addElement(userObjects[i], icon, checkedList, true, longLabel);
        }
        return model;
    }

    public static final JEWTDialog createOperationDialog(Component parent, String title, String hint, Component center, Component south, String helpTopicId) {
        return VersioningCoreUtil.createOperationDialog(parent, title, hint, center, south, helpTopicId, null);
    }

    public static final JEWTDialog createOperationDialog(Component parent, String title, String hint, Component center, Component south, String helpTopicId, Component initialFocus) {
        int buttons = VersioningCoreUtil.createOperationButtonMask(helpTopicId);
        JPanel content = VersioningCoreUtil.createOperationContentPanel(center, south);
        if (initialFocus == null) {
            initialFocus = content;
        }
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)parent, (Component)content, (Component)initialFocus, (String)(title != null ? title : IdeUtil.getProgramName()), (int)buttons);
        dialog.setResizable(true);
        dialog.setButtonMask(buttons);
        if (helpTopicId != null) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)content, helpTopicId);
        }
        return dialog;
    }

    public static final int createOperationButtonMask(String helpTopicId) {
        int buttons = 3;
        if (helpTopicId != null) {
            buttons |= 4;
        }
        return buttons;
    }

    public static final JPanel createOperationContentPanel(Component center, Component south) {
        JPanel content = new JPanel(new BorderLayout());
        content.add(center, "Center");
        if (south != null && south.isVisible()) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add(Box.createVerticalStrut(10), "North");
            panel.add(south, "Center");
            content.add((Component)panel, "South");
        }
        return content;
    }

    public static final boolean runDialog(final JDialog dialog) {
        if (EventQueue.isDispatchThread()) {
            return VersioningCoreUtil.runDialogImpl(dialog);
        }
        final boolean[] result = new boolean[1];
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public final void run() {
                    result[0] = VersioningCoreUtil.runDialogImpl(dialog);
                }
            });
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        return result[0];
    }

    private static final boolean runDialogImpl(JDialog dialog) {
        return WizardLauncher.runDialog((JDialog)dialog);
    }

    public static final URL[] removeRefAndQueryParts(URL[] urls) {
        URL[] urls2 = new URL[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            urls2[i] = urls[i];
            urls2[i] = URLFactory.replaceRefPart((URL)urls2[i], null);
            urls2[i] = URLFactory.replaceQueryPart((URL)urls2[i], null);
        }
        return urls2;
    }

    public static final boolean isBaseURLFor(URL url1, URL url2) {
        if (URLFileSystem.isDirectoryPath((URL)url1)) {
            return URLFileSystem.isBaseURLFor((URL)url1, (URL)url2);
        }
        return url1.toString().equals(url2.toString());
    }

    public static final KeyStrokeContext createKeyStrokeContext(IdeAction[] actions, String name) {
        return new DefaultKeyStrokeContext(actions, name);
    }

    public static final Node[] findCachedNodes(URLFilter filter) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Iterator itr = NodeFactory.getCachedNodes();
        while (itr.hasNext()) {
            Node node = (Node)itr.next();
            URL url = node.getURL();
            if (filter != null && (url == null || !filter.accept(url))) continue;
            nodes.add(node);
        }
        return nodes.toArray(new Node[0]);
    }

    public static final Locatable[] findOrCreateNodes(URL[] urls) {
        return VCSModelUtil.findOrCreateNodes((URL[])urls);
    }

    public static final void solveMnemonics(JMenu menu) {
        ArrayList<JMenuItem> fixedItems = new ArrayList<JMenuItem>();
        for (int i = 0; i < menu.getItemCount(); ++i) {
            Boolean fixedMnemonic;
            JMenuItem item = menu.getItem(i);
            if (item == null || (fixedMnemonic = (Boolean)item.getClientProperty("fixedMnemonic")) == null || !fixedMnemonic.booleanValue()) continue;
            fixedItems.add(item);
        }
        VersioningCoreUtil.solveMnemonics(menu, fixedItems.toArray(new JMenuItem[fixedItems.size()]), null);
    }

    private static final void solveMnemonics(JMenu menu, JMenuItem[] fixedItems, JMenuItem[] solveItems) {
        if (solveItems == null) {
            for (int i = 0; i < menu.getItemCount(); ++i) {
                JMenuItem item = menu.getItem(i);
                if (item == null || fixedItems != null && Arrays.asList(fixedItems).contains(item)) continue;
                item.setMnemonic(0);
            }
        } else {
            for (JMenuItem menuItem : solveItems) {
                menuItem.setMnemonic(0);
            }
        }
        MnemonicSolver mnemonicSolver = new MnemonicSolver();
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem item = menu.getItem(i);
            if (item == null) continue;
            if (item.getMnemonic() != 0) {
                mnemonicSolver.addMenuLabel(item, item.getText(), true);
                continue;
            }
            if (solveItems != null && !Arrays.asList(solveItems).contains(item)) continue;
            mnemonicSolver.addMenuLabel(item, item.getText(), false);
        }
        mnemonicSolver.solve();
    }

    private static class DefaultKeyStrokeContext
    extends oracle.ide.keyboard.DefaultKeyStrokeContext {
        private final IdeAction[] _actions;
        private final String _name;

        public DefaultKeyStrokeContext(IdeAction[] actions, String name) {
            this._actions = actions;
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public Set getAllActions(boolean bGlobal) {
            return bGlobal ? new HashSet<IdeAction>(Arrays.asList(this._actions)) : null;
        }

        protected void addGlobalKeyStrokes(KeyStrokeMap map) {
        }
    }
}

