/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.xml;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.listener.model.ListenerConnectionSettings;
import oracle.dbtools.listener.model.ListenerEnvironmentSettings;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.model.ListenerProcedureSettings;
import oracle.dbtools.listener.model.ListenerReportSettings;
import oracle.dbtools.listener.model.ListenerSecuritySettings;
import oracle.dbtools.listener.model.ListenerURLMappings;
import oracle.dbtools.listener.xml.ListenerXMLConstants;
import oracle.ide.ProductInformation;
import oracle.ide.Version;

public class ListenerXMLUtils {
    private static ListenerXMLUtils _xmlUtil;
    private ListenerModel _model;
    private ListenerModel _parentModel;
    private StringBuilder _xmlFormat;
    private Map<String, String> _settingsMap;

    public static ListenerXMLUtils getInstance() {
        if (_xmlUtil == null) {
            _xmlUtil = new ListenerXMLUtils();
        }
        return _xmlUtil;
    }

    public String formatSettingsToXML(ListenerModel listenerModel, ListenerModel listenerModel2, Properties properties) {
        boolean bl = listenerModel != null && listenerModel2 == null;
        this.init(listenerModel, listenerModel2);
        this.xmlDeclaration();
        if (bl) {
            this.formatConnections("");
            this.formatJDBC();
            this.formatSecurity();
            this.formatProcessingProcedures();
            this.formatEnvironment();
            this.formatExcel();
            this.formatSQLDev();
            this.preserveUnsupportedSettingsProperties(properties);
        } else {
            this.formatConnections("GATEWAY_USER");
            this.formatJDBC();
            this.preserveUnsupportedRESTProperties(properties);
        }
        this.formatEntries(this._settingsMap, false);
        this.endTag("properties");
        return this.getFormattedXMLSettings();
    }

    public String formatRESTUserToXML(ListenerModel listenerModel, ListenerModel listenerModel2, String string, Properties properties) {
        this.init(listenerModel, listenerModel2);
        this.formatUserToXML(listenerModel2, string, properties);
        return this.getFormattedXMLSettings();
    }

    public String formatURLMappingsToXML(ListenerModel listenerModel) {
        this.init(listenerModel, null);
        this.formatURLMappings(listenerModel);
        return this.getFormattedXMLSettings();
    }

    private void init(ListenerModel listenerModel, ListenerModel listenerModel2) {
        if (listenerModel2 == null) {
            this._model = listenerModel;
            this._parentModel = null;
        } else {
            this._model = listenerModel2;
            this._parentModel = listenerModel;
        }
        this._xmlFormat = new StringBuilder();
        this._settingsMap = new TreeMap<String, String>();
    }

    private void formatConnections(String string) {
        ListenerConnectionSettings listenerConnectionSettings = this._model.getConnectionSettings();
        ListenerConnectionSettings listenerConnectionSettings2 = this._parentModel == null ? null : this._parentModel.getConnectionSettings();
        String string2 = listenerConnectionSettings.getConnectionType().getType();
        if (this.isGlobal(this._parentModel)) {
            this._settingsMap.put("db.connectionType", string2);
            switch (string2) {
                case "basic": {
                    this._settingsMap.put("db.hostname", listenerConnectionSettings.getHost());
                    this._settingsMap.put("db.port", listenerConnectionSettings.getPort());
                    if (!this.isEmpty(listenerConnectionSettings.getServiceName())) {
                        this._settingsMap.put("db.servicename", listenerConnectionSettings.getServiceName());
                        break;
                    }
                    if (this.isEmpty(listenerConnectionSettings.getSid())) break;
                    this._settingsMap.put("db.sid", listenerConnectionSettings.getSid());
                    break;
                }
                case "tns": {
                    this._settingsMap.put("db.tnsAliasName", listenerConnectionSettings.getTNSAliasName());
                    this._settingsMap.put("db.tnsDirectory", listenerConnectionSettings.getTNSDirectory());
                    break;
                }
                case "customurl": {
                    this._settingsMap.put("db.customURL", listenerConnectionSettings.getCustomJDBCURL());
                }
            }
        } else {
            if (this.acceptValue(listenerConnectionSettings2.getConnectionType().getType(), string2)) {
                this._settingsMap.put("db.connectionType", string2);
            }
            switch (string2) {
                case "basic": {
                    if (this.acceptValue(listenerConnectionSettings2.getHost(), listenerConnectionSettings.getHost())) {
                        this._settingsMap.put("db.hostname", listenerConnectionSettings.getHost());
                    }
                    if (this.acceptValue(listenerConnectionSettings2.getPort(), listenerConnectionSettings.getPort())) {
                        this._settingsMap.put("db.port", listenerConnectionSettings.getPort());
                    }
                    if (!this.isEmpty(listenerConnectionSettings.getServiceName())) {
                        if (!this.acceptValue(listenerConnectionSettings2.getServiceName(), listenerConnectionSettings.getServiceName())) break;
                        this._settingsMap.put("db.servicename", listenerConnectionSettings.getServiceName());
                        break;
                    }
                    if (this.isEmpty(listenerConnectionSettings.getSid()) || !this.acceptValue(listenerConnectionSettings2.getSid(), listenerConnectionSettings.getSid())) break;
                    this._settingsMap.put("db.sid", listenerConnectionSettings.getSid());
                    break;
                }
                case "tns": {
                    if (this.acceptValue(listenerConnectionSettings2.getTNSAliasName(), listenerConnectionSettings.getTNSAliasName())) {
                        this._settingsMap.put("db.tnsAliasName", listenerConnectionSettings.getTNSAliasName());
                    }
                    if (!this.acceptValue(listenerConnectionSettings2.getTNSDirectory(), listenerConnectionSettings.getTNSDirectory())) break;
                    this._settingsMap.put("db.tnsDirectory", listenerConnectionSettings.getTNSDirectory());
                    break;
                }
                case "customurl": {
                    if (!this.acceptValue(listenerConnectionSettings2.getCustomJDBCURL(), listenerConnectionSettings.getCustomJDBCURL())) break;
                    this._settingsMap.put("db.customURL", listenerConnectionSettings.getCustomJDBCURL());
                }
            }
            String string3 = null;
            String string4 = null;
            switch (string.toUpperCase()) {
                case "ORDS_PUBLIC_USER": {
                    string3 = listenerConnectionSettings.getPublicUsername();
                    string4 = listenerConnectionSettings.getPublicPassword();
                    break;
                }
                case "APEX_REST_PUBLIC_USER": {
                    string3 = listenerConnectionSettings.getRestUserName();
                    string4 = listenerConnectionSettings.getRestPassword();
                    break;
                }
                case "APEX_LISTENER": {
                    string3 = listenerConnectionSettings.getListenerUsername();
                    string4 = listenerConnectionSettings.getListenerPassword();
                    break;
                }
                case "GATEWAY_USER": {
                    string3 = listenerConnectionSettings.getUserName();
                    string4 = listenerConnectionSettings.getPassword();
                    break;
                }
            }
            if (!this.isEmpty(string3)) {
                this._settingsMap.put("db.username", string3);
            }
            if (!this.isEmpty(string4)) {
                this._settingsMap.put("db.password", this.convertValue(string4));
            }
        }
    }

    private void formatJDBC() {
        ListenerConnectionSettings listenerConnectionSettings = this._model.getConnectionSettings();
        ListenerConnectionSettings listenerConnectionSettings2 = this._parentModel == null ? null : this._parentModel.getConnectionSettings();
        String string = listenerConnectionSettings.getJDBCDriver().getType();
        String string2 = Integer.toString(listenerConnectionSettings.getInitialPoolSize());
        String string3 = Integer.toString(listenerConnectionSettings.getMinimumConnections());
        String string4 = Integer.toString(listenerConnectionSettings.getMaximumConnections());
        String string5 = Integer.toString(listenerConnectionSettings.getMaximumStatements());
        String string6 = Integer.toString(listenerConnectionSettings.getInactivityTimeout());
        String string7 = Integer.toString(listenerConnectionSettings.getAbandonedConnectionTimeout());
        if (this.isGlobal(this._parentModel)) {
            if (!string.equals(this.getDefaultValue("jdbc.DriverType"))) {
                this._settingsMap.put("jdbc.DriverType", string);
            }
            if (!string2.equals(this.getDefaultValue("jdbc.InitialLimit"))) {
                this._settingsMap.put("jdbc.InitialLimit", string2);
            }
            if (!string3.equals(this.getDefaultValue("jdbc.MinLimit"))) {
                this._settingsMap.put("jdbc.MinLimit", string3);
            }
            if (!string4.equals(this.getDefaultValue("jdbc.MaxLimit"))) {
                this._settingsMap.put("jdbc.MaxLimit", string4);
            }
            if (!string5.equals(this.getDefaultValue("jdbc.MaxStatementsLimit"))) {
                this._settingsMap.put("jdbc.MaxStatementsLimit", string5);
            }
            if (!string6.equals(this.getDefaultValue("jdbc.InactivityTimeout"))) {
                this._settingsMap.put("jdbc.InactivityTimeout", string6);
            }
            if (!string7.equals(this.getDefaultValue("jdbc.statementTimeout"))) {
                this._settingsMap.put("jdbc.statementTimeout", string7);
            }
        } else {
            if (this.acceptValue(listenerConnectionSettings2.getJDBCDriver().getType(), listenerConnectionSettings.getJDBCDriver().getType())) {
                this._settingsMap.put("jdbc.DriverType", string);
            }
            if (this.acceptValue(listenerConnectionSettings2.getInitialPoolSize(), listenerConnectionSettings.getInitialPoolSize())) {
                this._settingsMap.put("jdbc.InitialLimit", string2);
            }
            if (this.acceptValue(listenerConnectionSettings2.getMinimumConnections(), listenerConnectionSettings.getMinimumConnections())) {
                this._settingsMap.put("jdbc.MinLimit", string3);
            }
            if (this.acceptValue(listenerConnectionSettings2.getMaximumConnections(), listenerConnectionSettings.getMaximumConnections())) {
                this._settingsMap.put("jdbc.MaxLimit", string4);
            }
            if (this.acceptValue(listenerConnectionSettings2.getMaximumStatements(), listenerConnectionSettings.getMaximumStatements())) {
                this._settingsMap.put("jdbc.MaxStatementsLimit", string5);
            }
            if (this.acceptValue(listenerConnectionSettings2.getInactivityTimeout(), listenerConnectionSettings.getInactivityTimeout())) {
                this._settingsMap.put("jdbc.InactivityTimeout", string6);
            }
            if (this.acceptValue(listenerConnectionSettings2.getAbandonedConnectionTimeout(), listenerConnectionSettings.getAbandonedConnectionTimeout())) {
                this._settingsMap.put("jdbc.statementTimeout", string7);
            }
        }
    }

    private void formatSecurity() {
        ListenerSecuritySettings listenerSecuritySettings;
        ListenerSecuritySettings listenerSecuritySettings2 = this._model.getSecuritySettings();
        ListenerSecuritySettings listenerSecuritySettings3 = listenerSecuritySettings = this._parentModel == null ? null : this._parentModel.getSecuritySettings();
        if (this.isGlobal(this._parentModel)) {
            String string;
            String string2 = ListenerXMLUtils.getCommaDelimited(listenerSecuritySettings2.getAllowedProcedures());
            if (!this.isEmpty(string2)) {
                this._settingsMap.put("security.inclusionList", string2);
            }
            if (!this.isEmpty(string = ListenerXMLUtils.getCommaDelimited(listenerSecuritySettings2.getBlockedProcedures()))) {
                this._settingsMap.put("security.exclusionList", string);
            }
            String string3 = this.getDefaultValue("security.disableDefaultExclusionList");
            String string4 = Boolean.toString(listenerSecuritySettings2.isDisableExclusionList());
            if (!string4.equals(string3)) {
                this._settingsMap.put("security.disableDefaultExclusionList", string4);
            }
            string3 = this.getDefaultValue("security.maxEntries");
            String string5 = Integer.toString(listenerSecuritySettings2.getMaximumCacheEntries());
            if (!string5.equals(string3)) {
                this._settingsMap.put("security.maxEntries", string5);
            }
            string3 = this.getDefaultValue("security.verifySSL");
            String string6 = Boolean.toString(listenerSecuritySettings2.isVerifySSLRequests());
            if (!string6.equals(string3)) {
                this._settingsMap.put("security.verifySSL", string6);
            }
            if (!this.isEmpty(listenerSecuritySettings2.getValidationFunction())) {
                this._settingsMap.put("security.validationFunctionType", listenerSecuritySettings2.getValidationFunctionType().getValue());
                this._settingsMap.put("security.requestValidationFunction", this.convertXMLReservedCharacters(listenerSecuritySettings2.getValidationFunction()));
            }
            if (!this.isEmpty(listenerSecuritySettings2.getICAPPort()) && !this.isEmpty(listenerSecuritySettings2.getICAPServer())) {
                this._settingsMap.put("icap.port", listenerSecuritySettings2.getICAPPort());
                this._settingsMap.put("icap.server", listenerSecuritySettings2.getICAPServer());
            }
        } else if (this.acceptValue(listenerSecuritySettings.getValidationFunction(), listenerSecuritySettings2.getValidationFunction())) {
            this._settingsMap.put("security.validationFunctionType", listenerSecuritySettings2.getValidationFunctionType().getValue());
            this._settingsMap.put("security.requestValidationFunction", this.convertXMLReservedCharacters(listenerSecuritySettings2.getValidationFunction()));
        }
    }

    private void formatEnvironment() {
        ListenerEnvironmentSettings listenerEnvironmentSettings = this._model.getEnvironmentSettings();
        ListenerEnvironmentSettings listenerEnvironmentSettings2 = this._parentModel == null ? null : this._parentModel.getEnvironmentSettings();
        String string = listenerEnvironmentSettings.getDefaultWebPage();
        String string2 = listenerEnvironmentSettings.getDocTable();
        if (this.isGlobal(this._parentModel)) {
            String string3;
            String string4;
            String string5;
            String string6;
            Object object;
            String string7;
            String string8;
            Properties properties = listenerEnvironmentSettings.getFeatures();
            if (properties != null) {
                string8 = properties.getProperty("feature.sdw");
                string7 = properties.getProperty("restEnabledSql.active");
                object = properties.getProperty("database.api.enabled");
                if ("true".equals(string8) && "true".equals(string7) && "true".equals(object)) {
                    this._settingsMap.put("feature.sdw", string8);
                    this._settingsMap.put("restEnabledSql.active", string7);
                    this._settingsMap.put("database.api.enabled", (String)object);
                } else if ("true".equals(string7) && "true".equals(object)) {
                    this._settingsMap.put("restEnabledSql.active", string7);
                    this._settingsMap.put("database.api.enabled", (String)object);
                } else if ("true".equals(string7)) {
                    this._settingsMap.put("restEnabledSql.active", string7);
                } else if ("true".equals(object)) {
                    this._settingsMap.put("database.api.enabled", (String)object);
                }
            }
            if (!this.isEmpty(string) && !string.equals(this.getDefaultValue("misc.defaultPage"))) {
                this._settingsMap.put("misc.defaultPage", listenerEnvironmentSettings.getDefaultWebPage());
            }
            if (!this.isEmpty(string2) && !string2.equals(this.getDefaultValue("owa.docTable"))) {
                this._settingsMap.put("owa.docTable", string2);
                this._settingsMap.put("apex.docTable", string2);
            }
            if (!this.isEmpty(string8 = listenerEnvironmentSettings.getExtensionClasses())) {
                this._settingsMap.put("apex.extensions", listenerEnvironmentSettings.getExtensionClasses());
            }
            if (!(string7 = Boolean.toString(listenerEnvironmentSettings.isRecordProcedure())).equals(this.getDefaultValue("log.procedure"))) {
                this._settingsMap.put("log.procedure", Boolean.toString(listenerEnvironmentSettings.isRecordProcedure()));
            }
            if (!(string6 = Boolean.toString(((ListenerReportSettings)(object = this._model.getReportSettings())).isDisplayErrorMessages())).equals(this.getDefaultValue("debug.printDebugToScreen"))) {
                this._settingsMap.put("debug.printDebugToScreen", string6);
            }
            if (!(string5 = Boolean.toString(((ListenerReportSettings)object).isKeepErrorMessages())).equals(this.getDefaultValue("error.keepErrorMessages"))) {
                this._settingsMap.put("error.keepErrorMessages", string5);
            }
            if (!(string4 = Boolean.toString(((ListenerReportSettings)object).isLogging())).equals(this.getDefaultValue("log.logging"))) {
                this._settingsMap.put("log.logging", string4);
            }
            if (!(string3 = Boolean.toString(((ListenerReportSettings)object).isReporting())).equals(this.getDefaultValue("status.statistics"))) {
                this._settingsMap.put("status.statistics", string3);
            }
        } else {
            if (this.acceptValue(listenerEnvironmentSettings2.getDefaultWebPage(), string)) {
                this._settingsMap.put("misc.defaultPage", string);
            }
            if (this.acceptValue(listenerEnvironmentSettings2.getDocTable(), listenerEnvironmentSettings.getDocTable())) {
                this._settingsMap.put("owa.docTable", string2);
                this._settingsMap.put("apex.docTable", string2);
            }
        }
    }

    private void formatProcessingProcedures() {
        ListenerProcedureSettings listenerProcedureSettings = this._model.getProcedureSettings();
        ListenerProcedureSettings listenerProcedureSettings2 = this._parentModel == null ? null : this._parentModel.getProcedureSettings();
        String string = ListenerXMLUtils.getCommaDelimited(listenerProcedureSettings.getPreProcessProcedures());
        String string2 = ListenerXMLUtils.getCommaDelimited(listenerProcedureSettings.getPostProcessProcedures());
        if (this.isGlobal(this._parentModel)) {
            if (!this.isEmpty(string)) {
                this._settingsMap.put("procedure.preProcess", string);
            }
            if (!this.isEmpty(string2)) {
                this._settingsMap.put("procedure.postProcess", string2);
            }
        } else {
            if (this.acceptValue(ListenerXMLUtils.getCommaDelimited(listenerProcedureSettings2.getPreProcessProcedures()), string)) {
                this._settingsMap.put("procedure.preProcess", string);
            }
            if (this.acceptValue(ListenerXMLUtils.getCommaDelimited(listenerProcedureSettings2.getPostProcessProcedures()), string2)) {
                this._settingsMap.put("procedure.postProcess", string2);
            }
        }
    }

    private void formatExcel() {
        ListenerReportSettings listenerReportSettings = this._model.getReportSettings();
        if (this.isGlobal(this._parentModel) && listenerReportSettings.isCreateCollectionFromExcelFile()) {
            this._settingsMap.put("apex.excel2collection", Boolean.toString(listenerReportSettings.isCreateCollectionFromExcelFile()));
            if (listenerReportSettings.isPutWorkSheetsInOneCollection()) {
                this._settingsMap.put("apex.excel2collection.onecollection", Boolean.toString(listenerReportSettings.isPutWorkSheetsInOneCollection()));
                this._settingsMap.put("apex.excel2collection.name", listenerReportSettings.getCollectionName());
            } else if (listenerReportSettings.isUseWorkSheetNameAsCollectionName()) {
                this._settingsMap.put("apex.excel2collection.useSheetName", Boolean.toString(listenerReportSettings.isUseWorkSheetNameAsCollectionName()));
            }
        }
    }

    private void formatSQLDev() {
        boolean bl = this._parentModel == null;
        this._settingsMap.put("sqldev.name", this._model.getName());
        this._settingsMap.put("sqldev.description", this.convertXMLReservedCharacters(this._model.getDescription()));
        if (bl) {
            this._settingsMap.put("sqldev.version", this._model.getSqlDevVersion());
        }
    }

    private void formatUserToXML(ListenerModel listenerModel, String string, Properties properties) {
        this.xmlDeclaration();
        this.formatConnections(string);
        this.formatJDBC();
        this.preserveUnsupportedRESTProperties(properties);
        this.formatEntries(this._settingsMap, false);
        this.endTag("properties");
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty() || string.trim().length() == 0;
    }

    private void formatURLMappings(ListenerModel listenerModel) {
        for (ListenerModel listenerModel2 : listenerModel.getChildren()) {
            String string = listenerModel2.getName();
            List<ListenerURLMappings.URLPattern> list = listenerModel2.getUrlMappings().getURLPatterns();
            if (list == null) continue;
            for (ListenerURLMappings.URLPattern uRLPattern : list) {
                this._xmlFormat.append("   ").append("<pool name=\"").append(string).append("\"\n");
                this._xmlFormat.append("      ").append(uRLPattern.getRuleType().getType()).append("=\"").append(uRLPattern.getURLPattern()).append("\"");
                if (!this.isEmpty(uRLPattern.getSchema())) {
                    this._xmlFormat.append(" schema-name=\"").append(uRLPattern.getSchema()).append("\"");
                }
                if (!this.isEmpty(uRLPattern.getWorkspace())) {
                    this._xmlFormat.append(" workspace-id=\"").append(uRLPattern.getWorkspace()).append("\"");
                }
                if (!this.isEmpty(uRLPattern.getUpdated())) {
                    this._xmlFormat.append(" updated=\"").append(uRLPattern.getUpdated()).append("\"");
                }
                this._xmlFormat.append("/>\n");
            }
        }
        if (this._xmlFormat != null && this._xmlFormat.length() > 0) {
            this._xmlFormat.insert(0, "<pool-config xmlns=\"http://xmlns.oracle.com/apex/pool-config\">\n");
            this._xmlFormat.append("</pool-config>");
            this.formatEntries(this._settingsMap, true);
        }
    }

    private void xmlDeclaration() {
        this._xmlFormat.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this._xmlFormat.append("<!DOCTYPE properties SYSTEM \"http://java.sun.com/dtd/properties.dtd\">\n");
        this._xmlFormat.append("<properties>\n");
        this._xmlFormat.append("<comment>Saved on ").append(new Date()).append(" - ").append(this.getProductNameVersion());
        this._xmlFormat.append("</comment>").append("\n");
    }

    private void endTag(String string) {
        this._xmlFormat.append("</").append(string).append(">");
    }

    private boolean acceptValue(String string, String string2) {
        String string3;
        String string4 = string == null ? "" : string.trim();
        String string5 = string3 = string2 == null ? "" : string2.trim();
        return !string4.equals(string3);
    }

    private boolean acceptValue(int n, int n2) {
        return n2 != n;
    }

    private void formatEntries(Map<String, String> map, boolean bl) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (String string : map.keySet()) {
            String string2 = map.get(string);
            this._xmlFormat.append(this.formatEntry(string, string2));
        }
        if (bl) {
            this._xmlFormat.append("\n");
        }
    }

    private String formatEntry(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<entry key=\"").append(string).append("\"");
        if (string2 != null && !string2.isEmpty()) {
            stringBuilder.append(">").append(string2).append("</entry>");
        } else {
            stringBuilder.append("/>");
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    private String getFormattedXMLSettings() {
        return this._xmlFormat.toString();
    }

    public static String getCommaDelimited(List<String> list) {
        if (list != null && !list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = list.size();
            for (int i = 0; i < list.size(); ++i) {
                stringBuilder.append(list.get(i));
                if (i == n - 1) continue;
                stringBuilder.append(",");
            }
            return stringBuilder.toString();
        }
        return "";
    }

    private String getProductNameVersion() {
        return ProductInformation.getProductInformation().getName() + " " + Version.VER_FULL;
    }

    private String convertXMLReservedCharacters(String string) {
        if (string != null && string.length() != 0) {
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n);
            block6: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '&': {
                        stringBuilder.append("&amp;");
                        continue block6;
                    }
                    case '<': {
                        stringBuilder.append("&lt;");
                        continue block6;
                    }
                    case '>': {
                        stringBuilder.append("&gt;");
                        continue block6;
                    }
                    case '\"': {
                        stringBuilder.append("&quot;");
                        continue block6;
                    }
                    default: {
                        stringBuilder.append(c);
                    }
                }
            }
            return stringBuilder.toString();
        }
        return string;
    }

    private String convertValue(String string) {
        if (this.isEmpty(string)) {
            return string;
        }
        if (string.startsWith("@")) {
            return string;
        }
        return "@" + Passwords.goingOut((String)string);
    }

    private void preserveUnsupportedSettingsProperties(Properties properties) {
        if (properties != null && !properties.isEmpty()) {
            for (Object object : properties.keySet()) {
                String string = (String)object;
                if (ListenerXMLConstants.SUPPORTED_PROPERTIES.containsKey(string)) continue;
                String string2 = (String)properties.get(string);
                this._settingsMap.put(string, string2);
            }
        }
    }

    private void preserveUnsupportedRESTProperties(Properties properties) {
        if (properties != null && !properties.isEmpty()) {
            for (Object object : properties.keySet()) {
                String string = (String)object;
                if (ListenerXMLConstants.CONN_JDBC_KEY_SET.contains(string)) continue;
                String string2 = (String)properties.get(string);
                this._settingsMap.put(string, string2);
            }
        }
    }

    private boolean isGlobal(ListenerModel listenerModel) {
        return listenerModel == null;
    }

    private String getDefaultValue(String string) {
        String string2 = ListenerXMLConstants.SUPPORTED_PROPERTIES.get(string);
        return string2 != null ? string2 : "";
    }
}

