/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import oracle.dbtools.common.util.SortedProperties;

public class ListenerZipFileWriter {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final int MAX_BUFFER_SIZE = 4096;
    private ZipOutputStream _zipOut;
    private String _encoding;
    private ArrayList<String> _entries;

    public void openFile(File file) throws IOException {
        this.openFile(file.getAbsolutePath(), null);
    }

    public void openFile(String string, String string2) throws IOException {
        this._zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
        this.init(string2);
    }

    public void addEntry(String string) throws IOException {
        if (this._zipOut != null) {
            ZipEntry zipEntry = new ZipEntry(string);
            this._zipOut.putNextEntry(zipEntry);
            this._entries.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(String string, File file) throws IOException {
        this.addEntry(string);
        try (FileInputStream fileInputStream = null;){
            int n;
            fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[4096];
            while ((n = fileInputStream.read(byArray)) > 0) {
                this._zipOut.write(byArray, 0, n);
            }
        }
    }

    public void writeText(String string) throws IOException {
        if (this._zipOut != null) {
            this._zipOut.write(string.getBytes(this._encoding));
        }
    }

    public void write(Properties properties, String string) throws IOException {
        if (this._zipOut != null) {
            SortedProperties sortedProperties = new SortedProperties();
            for (String string2 : properties.stringPropertyNames()) {
                sortedProperties.put((Object)string2, (Object)properties.getProperty(string2));
            }
            sortedProperties.store((OutputStream)this._zipOut, string);
        }
    }

    public void writeFile(String string, ZipInputStream zipInputStream) throws IOException {
        this.init(null);
        this._zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
        ZipEntry zipEntry = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            int n;
            this.addEntry(zipEntry.getName());
            byte[] byArray = new byte[4096];
            while ((n = zipInputStream.read(byArray)) != -1) {
                this._zipOut.write(byArray, 0, n);
            }
        }
    }

    public void closeFile() throws IOException {
        if (this._zipOut != null) {
            this._zipOut.flush();
            this._zipOut.close();
        }
    }

    public void setEncoding(String string) {
        this._encoding = string;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public ArrayList<String> getEntries() {
        return this._entries;
    }

    private void init(String string) {
        this._entries = new ArrayList();
        this._encoding = string == null ? DEFAULT_CHARSET : string;
    }
}

