/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ListenerZipFileReader {
    private static final String CONF_DIR = "conf/";
    private ZipFile _zipFile;
    private ZipEntry _globalSettingsZipEntry;
    private ZipEntry _urlMappingsZipEntry;
    private ZipEntry _reportsZipEntry;
    private HashMap<String, ZipEntry> _dbSettingsZipEntryList = new HashMap();
    private HashMap<String, ZipEntry> _restUsersZipEntryList = new HashMap();
    private LinkedHashSet<String> _dbSettingNames = new LinkedHashSet();
    private ArrayList<String> _entries = new ArrayList();
    private int _totalZipEntries = 0;

    public void setEntriesFromZip(String string) throws IOException {
        this._zipFile = new ZipFile(string);
        this._totalZipEntries = 0;
        Enumeration<? extends ZipEntry> enumeration = this._zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry == null) continue;
            this.assignEntry(zipEntry);
        }
    }

    private void assignEntry(ZipEntry zipEntry) {
        String string = zipEntry.getName();
        if (string.equals("defaults.xml")) {
            this.setGlobalSettingsZipEntry(zipEntry);
            this._entries.add(string);
            ++this._totalZipEntries;
        } else if (string.equals("url-mapping.xml")) {
            this.setURLMappingsZipEntry(zipEntry);
            this._entries.add(string);
            ++this._totalZipEntries;
        } else if (string.endsWith("listener_report.xml")) {
            this.setReportsZipEntry(zipEntry);
            this._entries.add(string);
            ++this._totalZipEntries;
        } else if (this.isExistConfFolder(string)) {
            if (this.isRestUser(string)) {
                this.addRESTUserZipEntry(zipEntry);
                this._entries.add(string);
                ++this._totalZipEntries;
            } else {
                this.addDBSettingsZipEntry(zipEntry);
                this._entries.add(string);
                ++this._totalZipEntries;
            }
            this.addDBSettingName(string);
        }
    }

    private void addDBSettingName(String string) {
        String string2 = string;
        if (string2 != null) {
            String string3;
            string2 = string2.replace("\\", "/");
            int n = -1;
            if (string2.contains(CONF_DIR)) {
                n = string2.indexOf("/");
                string2 = string2.substring(n + 1);
            }
            int n2 = 0;
            n2 = this.isRestUserFile(string2) ? string2.lastIndexOf("_") : string2.indexOf(".");
            if (n2 != -1 && !this._dbSettingNames.contains(string3 = string2.substring(0, n2))) {
                this._dbSettingNames.add(string3);
            }
        }
    }

    private boolean isExistConfFolder(String string) {
        return string.startsWith(CONF_DIR);
    }

    private boolean isRestUser(String string) {
        return this.isExistConfFolder(string) && this.isRestUserFile(string);
    }

    private boolean isRestUserFile(String string) {
        return string.endsWith("_pu.xml") || string.endsWith("_rt.xml") || string.endsWith("_al.xml");
    }

    private void setGlobalSettingsZipEntry(ZipEntry zipEntry) {
        this._globalSettingsZipEntry = zipEntry;
    }

    public ZipEntry getGlobalSettingsZipEntry() {
        return this._globalSettingsZipEntry;
    }

    private void addDBSettingsZipEntry(ZipEntry zipEntry) {
        this._dbSettingsZipEntryList.put(zipEntry.getName(), zipEntry);
    }

    public HashMap<String, ZipEntry> getDBSettingsZipEntryList() {
        return this._dbSettingsZipEntryList;
    }

    private void setURLMappingsZipEntry(ZipEntry zipEntry) {
        this._urlMappingsZipEntry = zipEntry;
    }

    public ZipEntry getURLMappingsZipEntry() {
        return this._urlMappingsZipEntry;
    }

    private void setReportsZipEntry(ZipEntry zipEntry) {
        this._reportsZipEntry = zipEntry;
    }

    public ZipEntry getReportsZipEntry() {
        return this._reportsZipEntry;
    }

    private void addRESTUserZipEntry(ZipEntry zipEntry) {
        if (this._restUsersZipEntryList == null) {
            this._restUsersZipEntryList = new HashMap();
        }
        this._restUsersZipEntryList.put(zipEntry.getName(), zipEntry);
    }

    public HashMap<String, ZipEntry> getRESTUserZipEntryList() {
        return this._restUsersZipEntryList;
    }

    public ZipEntry getRESTUserZipEntry(String string) {
        ZipEntry zipEntry = null;
        for (String string2 : this._restUsersZipEntryList.keySet()) {
            if (!string2.endsWith(string)) continue;
            zipEntry = this._restUsersZipEntryList.get(string2);
            return zipEntry;
        }
        return null;
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        if (this._zipFile != null) {
            return this._zipFile.getInputStream(zipEntry);
        }
        return null;
    }

    public void closeFile() throws IOException {
        if (this._zipFile != null) {
            try {
                this._zipFile.close();
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            this._globalSettingsZipEntry = null;
            this._urlMappingsZipEntry = null;
            this._reportsZipEntry = null;
            this._dbSettingsZipEntryList = null;
            this._restUsersZipEntryList = null;
        }
    }

    public String getName() throws IOException {
        String string = "";
        if (this._zipFile != null) {
            string = this._zipFile.getName();
        }
        return string;
    }

    public int getTotalZipEntries() {
        return this._totalZipEntries;
    }

    public LinkedHashSet<String> getDBSettingNames() {
        return this._dbSettingNames;
    }
}

