/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import oracle.dbtools.common.util.Timestamps;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.model.ListenerReportData;
import oracle.dbtools.listener.model.ListenerReportMessage;
import oracle.dbtools.listener.ui.ListenerSettings;
import oracle.dbtools.listener.ui.ListenerUIUtils;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.ide.util.ResourceUtils;

public class ListenerReportsPanel
extends ListenerSettings {
    private static final DecimalFormat FORMATER = new DecimalFormat("####.##");
    private static final double KILO = Math.pow(2.0, 10.0);
    private static final double MEGA = Math.pow(2.0, 20.0);
    private static final double GIGA = Math.pow(2.0, 30.0);
    private static final double TERA = Math.pow(2.0, 40.0);
    private static final double PETA = Math.pow(2.0, 50.0);
    private String _reportType;
    private JCheckBox _enableReporting;
    private JLabel _reportTime;
    private JLabel _serverUpTime;
    private JLabel _serverRptStatus;
    private JLabel _totalAccess;
    private JLabel _totalTraffic;
    private JLabel _totalErrors;
    private JLabel _totalDownloads;
    private JLabel _processingTime;
    private JLabel _processingTime_min;
    private JLabel _processingTime_avg;
    private JLabel _processingTime_med;
    private JLabel _processingTime_max;
    private JLabel _dbTime;
    private JLabel _dbTime_min;
    private JLabel _dbTime_avg;
    private JLabel _dbTime_med;
    private JLabel _dbTime_max;
    private JLabel _activeRequests;
    private JLabel _securityTotalEntries;
    private JLabel _securityMaxEntries;
    private JLabel _filesScanned;
    private JLabel _filesDetected;
    private JTextArea _reportTextArea;
    private boolean _serverReporting;

    public ListenerReportsPanel(String string, boolean bl) {
        this._reportType = string;
        this._serverReporting = bl;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        if (this._reportType.equals("ReportSummaryStatistics") || this._reportType.equals("ReportSettingsStatistics")) {
            this.statistics();
        } else if (this._reportType.equals("ErrorTracking") || this._reportType.equals("ReportLogging")) {
            this.reportTracking();
        } else if (this._reportType.equals("Reports")) {
            this.reporting();
        }
    }

    private void reporting() {
        this._reportTime = new JLabel();
        this._serverUpTime = new JLabel();
        this._serverRptStatus = new JLabel();
        this._enableReporting = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._enableReporting, (String)ListenerArb.getString("ENABLE_REPORTING"));
        JTextPane jTextPane = new JTextPane();
        jTextPane.setPreferredSize(new Dimension(100, 35));
        jTextPane.setText(ListenerArb.getString("REPORTS_INFO2"));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this._reportTime, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 8, 0, 20), 0, 0));
        jPanel.add((Component)this._serverUpTime, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 8, 0, 20), 0, 0));
        jPanel.add((Component)this._serverRptStatus, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 8, 8, 20), 0, 0));
        jPanel.add((Component)this._enableReporting, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 8, 8, 20), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel, (String)ListenerArb.getString("REPORTING_TITLE"));
        n = 0;
        this.add((Component)jTextPane, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 23, 1, new Insets(3, 8, 8, 8), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, ++n, 1, 1, 0.1, 0.1, 21, 0, new Insets(0, 8, 0, 8), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void statistics() {
        this._reportTime = new JLabel();
        this._serverRptStatus = new JLabel();
        this._totalAccess = new JLabel();
        this._totalTraffic = new JLabel();
        this._totalErrors = new JLabel();
        this._totalDownloads = new JLabel();
        this._processingTime = new JLabel();
        this._processingTime_min = new JLabel();
        this._processingTime_avg = new JLabel();
        this._processingTime_med = new JLabel();
        this._processingTime_max = new JLabel();
        this._dbTime = new JLabel();
        this._dbTime_min = new JLabel();
        this._dbTime_avg = new JLabel();
        this._dbTime_med = new JLabel();
        this._dbTime_max = new JLabel();
        this._activeRequests = new JLabel();
        this._securityTotalEntries = new JLabel();
        this._securityMaxEntries = new JLabel();
        this._filesScanned = new JLabel();
        this._filesDetected = new JLabel();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        JLabel jLabel8 = new JLabel();
        JLabel jLabel9 = new JLabel();
        JLabel jLabel10 = new JLabel();
        JLabel jLabel11 = new JLabel();
        JLabel jLabel12 = new JLabel();
        JLabel jLabel13 = new JLabel();
        JLabel jLabel14 = new JLabel();
        JLabel jLabel15 = new JLabel();
        JLabel jLabel16 = new JLabel();
        JLabel jLabel17 = new JLabel();
        JLabel jLabel18 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._totalAccess, (String)ListenerArb.getString("RPT_TOTAL_ACCESSES"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._totalTraffic, (String)ListenerArb.getString("RPT_TOTAL_TRAFFIC"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._totalDownloads, (String)ListenerArb.getString("RPT_FILES_DOWNLOADED"));
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this._processingTime, (String)ListenerArb.getString("RPT_TOTAL_PROCESSING_TIME"));
        ResourceUtils.resLabel((JLabel)jLabel5, (Component)this._processingTime_min, (String)ListenerArb.getString("RPT_MINIMUM"));
        ResourceUtils.resLabel((JLabel)jLabel6, (Component)this._processingTime_avg, (String)ListenerArb.getString("RPT_AVERAGE"));
        ResourceUtils.resLabel((JLabel)jLabel7, (Component)this._processingTime_med, (String)ListenerArb.getString("RPT_MEDIAN"));
        ResourceUtils.resLabel((JLabel)jLabel8, (Component)this._processingTime_max, (String)ListenerArb.getString("RPT_MAXIMUM"));
        ResourceUtils.resLabel((JLabel)jLabel9, (Component)this._dbTime, (String)ListenerArb.getString("RPT_TOTAL_DATABASE_TIME"));
        ResourceUtils.resLabel((JLabel)jLabel10, (Component)jLabel10, (String)ListenerArb.getString("RPT_MINIMUM"));
        ResourceUtils.resLabel((JLabel)jLabel11, (Component)jLabel11, (String)ListenerArb.getString("RPT_AVERAGE"));
        ResourceUtils.resLabel((JLabel)jLabel12, (Component)jLabel12, (String)ListenerArb.getString("RPT_MEDIAN"));
        ResourceUtils.resLabel((JLabel)jLabel13, (Component)jLabel13, (String)ListenerArb.getString("RPT_MAXIMUM"));
        ResourceUtils.resLabel((JLabel)jLabel14, (Component)this._activeRequests, (String)ListenerArb.getString("RPT_ACTIVE_REQUESTS"));
        ResourceUtils.resLabel((JLabel)jLabel15, (Component)this._securityTotalEntries, (String)ListenerArb.getString("RPT_STAT_TOTAL_ENTRIES"));
        ResourceUtils.resLabel((JLabel)jLabel16, (Component)this._securityMaxEntries, (String)ListenerArb.getString("RPT_MAXIMUM_ENTRIES_ALLOWED"));
        ResourceUtils.resLabel((JLabel)jLabel17, (Component)this._filesScanned, (String)ListenerArb.getString("RPT_FILES_SCANNED"));
        ResourceUtils.resLabel((JLabel)jLabel18, (Component)this._filesDetected, (String)ListenerArb.getString("RPT_FILES_DETECTED"));
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this._reportTime, new GridBagConstraints(0, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(0, 8, 0, 8), 0, 0));
        jPanel.add((Component)this._serverRptStatus, new GridBagConstraints(0, ++n, 1, 1, 0.5, 0.0, 23, 2, new Insets(8, 8, 0, 8), 0, 0));
        n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(3, 8, 0, 6), 0, 0));
        jPanel2.add((Component)this._totalAccess, new GridBagConstraints(1, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(3, 0, 0, 8), 0, 0));
        jPanel2.add((Component)jLabel3, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(3, 8, 0, 6), 0, 0));
        jPanel2.add((Component)this._totalDownloads, new GridBagConstraints(3, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(3, 0, 0, 8), 0, 0));
        jPanel2.add(Box.createGlue(), new GridBagConstraints(4, n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(3, 8, 6, 6), 0, 0));
        jPanel2.add((Component)this._totalTraffic, new GridBagConstraints(1, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(3, 0, 6, 8), 0, 0));
        jPanel2.add((Component)jLabel14, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(3, 8, 6, 6), 0, 0));
        jPanel2.add((Component)this._activeRequests, new GridBagConstraints(3, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(3, 0, 6, 8), 0, 0));
        jPanel2.add(Box.createGlue(), new GridBagConstraints(4, n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel2, (String)ListenerArb.getString("RPT_GENERAL_STATISTICS"));
        n = 0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)jLabel5, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(3, 8, 0, 6), 0, 0));
        jPanel3.add((Component)this._processingTime_min, new GridBagConstraints(1, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(3, 0, 0, 8), 0, 0));
        jPanel3.add((Component)jLabel6, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(3, 8, 0, 6), 0, 0));
        jPanel3.add((Component)this._processingTime_avg, new GridBagConstraints(3, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(3, 0, 0, 8), 0, 0));
        jPanel3.add(Box.createGlue(), new GridBagConstraints(4, n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)jLabel8, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(3, 8, 6, 6), 0, 0));
        jPanel3.add((Component)this._processingTime_max, new GridBagConstraints(1, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(3, 0, 6, 8), 0, 0));
        jPanel3.add((Component)jLabel7, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(3, 8, 6, 6), 0, 0));
        jPanel3.add((Component)this._processingTime_med, new GridBagConstraints(3, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(3, 0, 6, 8), 0, 0));
        jPanel3.add(Box.createGlue(), new GridBagConstraints(4, n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add((Component)jLabel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(3, 8, 6, 6), 0, 0));
        jPanel4.add((Component)this._processingTime, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 23, 2, new Insets(3, 0, 6, 8), 0, 0));
        jPanel3.add((Component)jPanel4, new GridBagConstraints(0, ++n, 4, 1, 0.5, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel3, (String)ListenerArb.getString("RPT_PROCESSING_TIME"));
        n = 0;
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.add((Component)jLabel10, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(3, 8, 0, 6), 0, 0));
        jPanel5.add((Component)this._dbTime_min, new GridBagConstraints(1, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(3, 0, 0, 8), 0, 0));
        jPanel5.add((Component)jLabel11, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(3, 8, 0, 6), 0, 0));
        jPanel5.add((Component)this._dbTime_avg, new GridBagConstraints(3, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(3, 0, 0, 8), 0, 0));
        jPanel5.add(Box.createGlue(), new GridBagConstraints(4, n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel5.add((Component)jLabel13, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(3, 8, 6, 6), 0, 0));
        jPanel5.add((Component)this._dbTime_max, new GridBagConstraints(1, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(3, 0, 6, 8), 0, 0));
        jPanel5.add((Component)jLabel12, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(3, 8, 6, 6), 0, 0));
        jPanel5.add((Component)this._dbTime_med, new GridBagConstraints(3, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(3, 0, 6, 8), 0, 0));
        jPanel5.add(Box.createGlue(), new GridBagConstraints(4, n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        jPanel6.add((Component)jLabel9, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(3, 8, 6, 6), 0, 0));
        jPanel6.add((Component)this._dbTime, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 23, 2, new Insets(3, 0, 6, 8), 0, 0));
        jPanel5.add((Component)jPanel6, new GridBagConstraints(0, ++n, 4, 1, 0.5, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel5, (String)ListenerArb.getString("RPT_DATABASE_TIME"));
        n = 0;
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        jPanel7.add((Component)jPanel, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 21, 2, new Insets(8, 8, 0, 8), 0, 0));
        jPanel7.add((Component)jPanel2, new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 21, 2, new Insets(8, 8, 0, 8), 0, 0));
        jPanel7.add((Component)jPanel3, new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 21, 2, new Insets(8, 8, 0, 8), 0, 0));
        jPanel7.add((Component)jPanel5, new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 21, 2, new Insets(8, 8, 0, 8), 0, 0));
        int n2 = n;
        if (this._reportType.equals("ReportSettingsStatistics")) {
            n = 0;
            JPanel jPanel8 = new JPanel(new GridBagLayout());
            jPanel8.add((Component)jLabel15, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(3, 8, 6, 6), 0, 0));
            jPanel8.add((Component)this._securityTotalEntries, new GridBagConstraints(1, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(3, 0, 6, 8), 0, 0));
            jPanel8.add((Component)jLabel16, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(3, 8, 6, 6), 0, 0));
            jPanel8.add((Component)this._securityMaxEntries, new GridBagConstraints(3, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(3, 0, 6, 8), 0, 0));
            jPanel8.add(Box.createGlue(), new GridBagConstraints(4, n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            UIUtils.makeTitledBorder((JComponent)jPanel8, (String)ListenerArb.getString("RPT_STAT_SECURITY"));
            jPanel7.add((Component)jPanel8, new GridBagConstraints(0, ++n2, 1, 1, 1.0, 1.0, 21, 2, new Insets(8, 8, 0, 8), 0, 0));
        }
        this.addSettingsPanel(jPanel7);
    }

    private void reportTracking() {
        this.setPreferredSize(new Dimension(200, 200));
        this._reportTextArea = new JTextArea();
        String string = this._reportType.equals("ErrorTracking") ? ListenerArb.getString("RPT_ERROR_TRACKING") : ListenerArb.getString("RPT_LOGGING");
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._reportTextArea, (String)string);
        this._reportTextArea.setRows(5);
        this._reportTextArea.setLineWrap(true);
        this._reportTextArea.setWrapStyleWord(true);
        Dimension dimension = new Dimension(200, 300);
        this._reportTextArea.setSize(dimension);
        this._reportTextArea.setPreferredSize(dimension);
        this._reportTextArea.setMinimumSize(dimension);
        JScrollPane jScrollPane = new JScrollPane(this._reportTextArea, 22, 31);
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 0;
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 0, 8), 0, 0));
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, ++n, 1, 2, 1.0, 1.0, 23, 1, new Insets(8, 8, 0, 8), 0, 0));
        jPanel.add(Box.createGlue(), new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addSettingsPanel(jPanel);
    }

    private void assignReporting(ListenerModel listenerModel) {
        String string = ListenerArb.format("AS_OF", this.getDateTimeFromTimestamp((String)listenerModel.getReportData().getValue("report_time")));
        this._reportTime.setText(string);
        string = ListenerArb.format("RPT_SERVER_UPTIME", this.formatTime(ListenerUIUtils.getLongValue(listenerModel.getReportData().getValue("uptime"))));
        this._serverUpTime.setText(string);
        String string2 = this._serverReporting ? ListenerArb.format("STATUS", ListenerArb.getString("REPORTS_SERVER_ENABLED")) : ListenerArb.format("STATUS", ListenerArb.getString("REPORTS_SERVER_DISABLED"));
        this._serverRptStatus.setText(string2);
        this._enableReporting.setSelected(listenerModel.getReportSettings().isReporting());
    }

    private void assignStatistics(ListenerReportData listenerReportData) {
        Object object;
        String string = ListenerArb.format("AS_OF", this.getDateTimeFromTimestamp((String)listenerReportData.getValue("report_time")));
        this._reportTime.setText(string);
        String string2 = this._serverReporting ? ListenerArb.format("STATUS", ListenerArb.getString("REPORTS_SERVER_ENABLED")) : ListenerArb.format("STATUS", ListenerArb.getString("REPORTS_SERVER_DISABLED"));
        this._serverRptStatus.setText(string2);
        this._totalAccess.setText(this.formatValue(ListenerUIUtils.getLongValue(listenerReportData.getValue("pages_served"))));
        this._totalTraffic.setText(this.formatBytes(ListenerUIUtils.getLongValue(listenerReportData.getValue("bytes_sent"))));
        this._totalErrors.setText(this.formatValue(ListenerUIUtils.getLongValue(listenerReportData.getValue("total_errors"))));
        this._totalDownloads.setText(this.formatValue(ListenerUIUtils.getLongValue(listenerReportData.getValue("total_files"))));
        this._activeRequests.setText(this.formatValue(ListenerUIUtils.getLongValue(listenerReportData.getValue("active_requests"))));
        this._securityTotalEntries.setText(this.formatValue(ListenerUIUtils.getLongValue(listenerReportData.getValue("security_cache_size"))));
        this._securityMaxEntries.setText(this.formatValue(ListenerUIUtils.getLongValue(listenerReportData.getValue("security_cache_max_entries"))));
        this._filesScanned.setText(this.formatValue(ListenerUIUtils.getLongValue(listenerReportData.getValue("files_scanned"))));
        this._filesDetected.setText(this.formatValue(ListenerUIUtils.getLongValue(listenerReportData.getValue("files_detected"))));
        HashMap<String, Object> hashMap = listenerReportData.getTimings("total_times");
        if (hashMap != null && !hashMap.isEmpty()) {
            this._processingTime.setText(this.formatTime(ListenerUIUtils.getLongValue(hashMap.get("total"))));
            this._processingTime_min.setText(this.formatTime(ListenerUIUtils.getLongValue(hashMap.get("minimum"))));
            this._processingTime_max.setText(this.formatTime(ListenerUIUtils.getLongValue(hashMap.get("maximum"))));
            this._processingTime_med.setText(this.formatTime(ListenerUIUtils.getLongValue(hashMap.get("median"))));
            this._processingTime_avg.setText(this.formatTime(ListenerUIUtils.getLongValue(hashMap.get("average"))));
        } else {
            object = this.formatTime(0L);
            this._processingTime.setText((String)object);
            this._processingTime_min.setText((String)object);
            this._processingTime_max.setText((String)object);
            this._processingTime_med.setText((String)object);
            this._processingTime_avg.setText((String)object);
        }
        object = listenerReportData.getTimings("db_times");
        if (object != null && !((HashMap)object).isEmpty()) {
            this._dbTime.setText(this.formatTime(ListenerUIUtils.getLongValue(((HashMap)object).get("total"))));
            this._dbTime_min.setText(this.formatTime(ListenerUIUtils.getLongValue(((HashMap)object).get("minimum"))));
            this._dbTime_max.setText(this.formatTime(ListenerUIUtils.getLongValue(((HashMap)object).get("maximum"))));
            this._dbTime_med.setText(this.formatTime(ListenerUIUtils.getLongValue(((HashMap)object).get("median"))));
            this._dbTime_avg.setText(this.formatTime(ListenerUIUtils.getLongValue(((HashMap)object).get("average"))));
        } else {
            String string3 = this.formatTime(0L);
            this._dbTime.setText(string3);
            this._dbTime_min.setText(string3);
            this._dbTime_max.setText(string3);
            this._dbTime_med.setText(string3);
            this._dbTime_avg.setText(string3);
        }
    }

    private void assignReportTracking(ListenerReportData listenerReportData) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this._model.getName();
        if (!this._reportTextArea.isEditable()) {
            this._reportTextArea.setEditable(true);
        }
        if (this._reportType.equals("ErrorTracking")) {
            String string2 = ListenerArb.format("RPT_ERROR_TRACKING_CURRENT_TIME", this.getDateTimeFromTimestamp(ListenerUIUtils.getStringValue(listenerReportData.getValue("report_time"))));
            stringBuffer.append(string2).append("\n\n");
            if (this._serverReporting) {
                if (listenerReportData.getErrors() != null && !listenerReportData.getErrors().isEmpty()) {
                    stringBuffer.append(ListenerArb.format("RPT_TOTAL_ERR_MESSAGES", listenerReportData.getErrors().size())).append("\n\n");
                    for (ListenerReportMessage listenerReportMessage : listenerReportData.getErrors()) {
                        if (listenerReportMessage.getTimeStamp() == null || listenerReportMessage.getTimeStamp().isEmpty()) {
                            stringBuffer.append(listenerReportMessage.getMessage()).append("\n");
                            continue;
                        }
                        stringBuffer.append(listenerReportMessage.getTimeStamp()).append(" ").append(listenerReportMessage.getMessage()).append("\n");
                    }
                } else {
                    stringBuffer.append(ListenerArb.format("RPT_NO_ERRORS2", string));
                }
            } else {
                stringBuffer.append(ListenerArb.getString("REPORTS_DISABLED"));
            }
        } else if (this._reportType.equals("ReportLogging")) {
            String string3 = ListenerArb.format("RPT_LOGGING_CURRENT_TIME", this.getDateTimeFromTimestamp(ListenerUIUtils.getStringValue(listenerReportData.getValue("report_time"))));
            stringBuffer.append(string3).append("\n\n");
            if (this._serverReporting) {
                if (listenerReportData.getLogs() != null && !listenerReportData.getLogs().isEmpty()) {
                    stringBuffer.append(ListenerArb.format("RPT_TOTAL_LOG_MESSAGES", listenerReportData.getLogs().size())).append("\n\n");
                    for (ListenerReportMessage listenerReportMessage : listenerReportData.getLogs()) {
                        stringBuffer.append(listenerReportMessage.getMessage()).append("\n");
                    }
                } else {
                    stringBuffer.append(ListenerArb.format("RPT_NO_LOGS2", string));
                }
            } else {
                stringBuffer.append(ListenerArb.getString("REPORTS_DISABLED"));
            }
        }
        this._reportTextArea.setText(stringBuffer.toString());
        this._reportTextArea.setEditable(false);
        this._reportTextArea.setCaretPosition(0);
    }

    private String formatValue(Long l) {
        return String.format("%d", l);
    }

    private String formatTime(long l) {
        String string;
        if (l == 0L) {
            return String.format("%d", l);
        }
        long l2 = l / 1000L;
        long l3 = l % 1000L;
        long l4 = (long)Math.floor(l2 / 3600L / 24L);
        long l5 = (long)Math.floor(l2 / 3600L) - 24L * l4;
        long l6 = (long)Math.floor(l2 % 3600L / 60L);
        long l7 = (long)Math.floor(l2 % 60L);
        if (l4 == 0L) {
            String string2 = "%02d:%02d:%02d.%d";
            string = String.format(string2, l5, l6, l7, l3);
        } else {
            String string3 = "%d " + (l4 == 1L ? ListenerArb.getString("TIME_DAY") : ListenerArb.getString("TIME_DAYS")) + " %02d:%02d:%02d.%d";
            string = String.format(string3, l4, l5, l6, l7, l3);
        }
        return string;
    }

    private String formatBytes(double d) {
        String string = null;
        if (d > PETA) {
            double d2 = d / PETA;
            string = FORMATER.format(d2) + " " + ListenerArb.getString("PETABYTE");
        } else if (d > TERA) {
            double d3 = d / TERA;
            string = FORMATER.format(d3) + " " + ListenerArb.getString("TERABYTE");
        } else if (d > GIGA) {
            double d4 = d / GIGA;
            string = FORMATER.format(d4) + " " + ListenerArb.getString("GIGABYTE");
        } else if (d > MEGA) {
            double d5 = d / MEGA;
            string = FORMATER.format(d5) + " " + ListenerArb.getString("MEGABYTE");
        } else if (d > KILO) {
            double d6 = d / KILO;
            string = FORMATER.format(d6) + " " + ListenerArb.getString("KILOBYTE");
        } else {
            string = FORMATER.format(d) + " " + ListenerArb.getString("BYTES");
        }
        return string;
    }

    private String getDateTimeFromTimestamp(String string) {
        if (string != null && !string.isEmpty()) {
            long l = Timestamps.valueOf((String)string);
            return DateFormat.getDateTimeInstance().format(l);
        }
        return "";
    }

    @Override
    public void assignSettings(ListenerModel listenerModel, ListenerModel listenerModel2) {
        this.initSettings(listenerModel, listenerModel2, this._reportType);
        this.assignSettings(this._model);
    }

    @Override
    public void assignSettings(ListenerModel listenerModel) {
        if (listenerModel != null && listenerModel.getReportData() != null) {
            if (this._reportType.equals("ReportSummaryStatistics") || this._reportType.equals("ReportSettingsStatistics")) {
                this.assignStatistics(listenerModel.getReportData());
            } else if (this._reportType.equals("ErrorTracking") || this._reportType.equals("ReportLogging")) {
                this.assignReportTracking(listenerModel.getReportData());
            } else if (this._reportType.equals("Reports")) {
                this.assignReporting(listenerModel);
            }
        }
    }

    @Override
    public ListenerModel getSettings() {
        if (this._reportType.equals("Reports") && this._model != null && this._model.getReportSettings() != null) {
            this._model.getReportSettings().setReporting(this._enableReporting.isSelected());
        }
        return this._model;
    }

    public void setServerReporting(boolean bl) {
        this._serverReporting = bl;
    }
}

