/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerEnvironmentSettings;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.ui.ListenerSettings;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.util.ResourceUtils;

public class ListenerFeaturesPanel
extends ListenerSettings {
    private JRadioButton sdwBtn;
    private JRadioButton restSqlBtn;
    private JRadioButton dbApiBtn;
    private JRadioButton restSqlDbApiBtn;
    private JRadioButton noneBtn;

    public ListenerFeaturesPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.sdwBtn = new JRadioButton();
        this.restSqlBtn = new JRadioButton();
        this.dbApiBtn = new JRadioButton();
        this.restSqlDbApiBtn = new JRadioButton();
        this.noneBtn = new JRadioButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.sdwBtn);
        buttonGroup.add(this.restSqlBtn);
        buttonGroup.add(this.dbApiBtn);
        buttonGroup.add(this.restSqlDbApiBtn);
        buttonGroup.add(this.noneBtn);
        this.sdwBtn.setSelected(true);
        ResourceUtils.resButton((AbstractButton)this.sdwBtn, (String)ListenerArb.getString("FEATURE_SDW"));
        ResourceUtils.resButton((AbstractButton)this.restSqlBtn, (String)ListenerArb.getString("FEATURE_RESTSQL"));
        ResourceUtils.resButton((AbstractButton)this.dbApiBtn, (String)ListenerArb.getString("FEATURE_DBAPI"));
        ResourceUtils.resButton((AbstractButton)this.restSqlDbApiBtn, (String)ListenerArb.getString("FEATURE_RESTSQL_DBAPI"));
        ResourceUtils.resButton((AbstractButton)this.noneBtn, (String)ListenerArb.getString("FEATURE_NONE"));
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(ListenerArb.getString("FEATURE_SELECT"));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        int n = 0;
        int n2 = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)jTextPane, LayoutControl.GBC.gbc((int)n2, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)this.sdwBtn, LayoutControl.GBC.gbc((int)n2, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.restSqlBtn, LayoutControl.GBC.gbc((int)n2, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.dbApiBtn, LayoutControl.GBC.gbc((int)n2, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.restSqlDbApiBtn, LayoutControl.GBC.gbc((int)n2, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.noneBtn, LayoutControl.GBC.gbc((int)n2, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        JPanel jPanel2 = LayoutControl.GBC.createTitledSubPanel((String)ListenerArb.getString("FEATURE_TITLE"), (Component)jPanel);
        n = 0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)jPanel2, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)jPanel3, (int)(++n));
        this.addSettingsPanel(jPanel3);
    }

    @Override
    public void assignSettings(ListenerModel listenerModel, ListenerModel listenerModel2) {
        this.initSettings(listenerModel, listenerModel2, "Features");
        this.assignSettings(this._model);
    }

    @Override
    public void assignSettings(ListenerModel listenerModel) {
        Properties properties;
        ListenerEnvironmentSettings listenerEnvironmentSettings;
        if (listenerModel != null && listenerModel.getEnvironmentSettings() != null && (listenerEnvironmentSettings = listenerModel.getEnvironmentSettings()) != null && (properties = listenerEnvironmentSettings.getFeatures()) != null) {
            String string = properties.getProperty("feature.sdw");
            String string2 = properties.getProperty("restEnabledSql.active");
            String string3 = properties.getProperty("database.api.enabled");
            if ("true".equals(string) && "true".equals(string2) && "true".equals(string3) || "true".equals(string) && "true".equals(string2) && (string3 == null || string3.isEmpty())) {
                this.sdwBtn.setSelected(true);
            } else if ("true".equals(string2) && "true".equals(string3)) {
                this.restSqlDbApiBtn.setSelected(true);
            } else if ("true".equals(string2)) {
                this.restSqlBtn.setSelected(true);
            } else if ("true".equals(string3)) {
                this.dbApiBtn.setSelected(true);
            } else if ("false".equals(string2) || "false".equals(string3)) {
                this.noneBtn.setSelected(true);
            }
        }
    }

    @Override
    public ListenerModel getSettings() {
        if (this._model != null && this._model.getEnvironmentSettings() != null) {
            ListenerEnvironmentSettings listenerEnvironmentSettings = this._model.getEnvironmentSettings();
            Properties properties = listenerEnvironmentSettings.getFeatures();
            if (properties == null) {
                properties = new Properties();
            } else {
                properties.clear();
            }
            if (this.sdwBtn.isSelected()) {
                properties.put("feature.sdw", "true");
                properties.put("restEnabledSql.active", "true");
                properties.put("database.api.enabled", "true");
            } else if (this.restSqlBtn.isSelected()) {
                properties.put("restEnabledSql.active", "true");
            } else if (this.dbApiBtn.isSelected()) {
                properties.put("database.api.enabled", "true");
            } else if (this.restSqlDbApiBtn.isSelected()) {
                properties.put("restEnabledSql.active", "true");
                properties.put("database.api.enabled", "true");
            } else if (this.noneBtn.isSelected()) {
                // empty if block
            }
            listenerEnvironmentSettings.setFeatures(properties);
        }
        return this._model;
    }
}

