/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.listener.ListenerWindow;
import oracle.ide.Addin;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;

public class ListenerAddin
implements Addin {
    static final String VIEW_TYPE = "LISTENER_VIEW_TYPE";
    private static ListenerWindow _listenerWindow;
    private final List<ChangeListener> _changeListeners = new ArrayList<ChangeListener>();
    public static final String encoding = "UTF-8";

    public void initialize() {
        try {
            EditorManager.getEditorManager().addEditorListener((EditorListener)new EditorL());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ListenerWindow getListenerWindow() {
        if (_listenerWindow == null) {
            _listenerWindow = new ListenerWindow();
        }
        return _listenerWindow;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._changeListeners.remove(changeListener);
    }

    public void fireChangeEvent() {
        ChangeListener[] changeListenerArray = this._changeListeners.toArray(new ChangeListener[this._changeListeners.size()]);
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = 0; i < changeListenerArray.length; ++i) {
            ChangeListener changeListener = changeListenerArray[i];
            try {
                changeListener.stateChanged(changeEvent);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private class EditorL
    implements EditorListener {
        private EditorL() {
        }

        public void editorOpened(Editor editor) {
        }

        public void editorActivated(Editor editor) {
        }

        public void editorDeactivated(Editor editor) {
        }

        public void editorClosed(Editor editor) {
        }
    }
}

