/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.filenav;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Timer;
import oracle.dbtools.raptor.BaseRaptorFilter;
import oracle.dbtools.raptor.filenav.DirectoryFolder;
import oracle.dbtools.raptor.filenav.DirectoryRoot;
import oracle.dbtools.raptor.filenav.FileElementFactory;
import oracle.dbtools.raptor.filenav.FileNavigatorController;
import oracle.dbtools.raptor.filenav.FilesRootFolder;
import oracle.dbtools.raptor.filenav.PseudoRoot;
import oracle.dbtools.raptor.utils.URLChooserShortcuts;
import oracle.ide.Ide;
import oracle.ide.dialogs.URLChooserShortcut;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemEvent;
import oracle.ide.net.URLFileSystemListener;

public class FilesRootFilter
extends BaseRaptorFilter {
    private List<Element> m_children;
    private L m_listener = new L();

    protected Object getKey(Object object) {
        if (object instanceof Locatable) {
            return ((Locatable)object).getURL();
        }
        return null;
    }

    public void closeChildren() {
        this.m_listener.untrackAllRoots();
        this.m_children = null;
    }

    public Iterator getChildren() {
        if (this.m_children == null) {
            this.m_children = this.loadChildren();
        }
        return this.m_children.iterator();
    }

    private List<Element> loadChildren() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        TNode tNode = this.getOwner();
        Element element = tNode.getData();
        if (element instanceof FilesRootFolder) {
            URL uRL;
            Iterator iterator;
            Object object;
            Object object2;
            ArrayList<DirectoryRoot> arrayList2 = new ArrayList<DirectoryRoot>();
            FilesRootFolder filesRootFolder = (FilesRootFolder)element;
            ContentSet contentSet = filesRootFolder.getContentSet();
            if (contentSet != null) {
                object2 = FileElementFactory.getInstance();
                object = contentSet.getURLPath();
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    uRL = (URL)iterator.next();
                    DirectoryRoot directoryRoot = ((FileElementFactory)object2).findOrCreateRoot(uRL, URLFileSystem.getSystemDisplayName((URL)uRL));
                    this.m_listener.trackRoot(uRL);
                    arrayList2.add(directoryRoot);
                }
            }
            object2 = URLChooserShortcuts.getInstance().getStandardDocumentLocationShortcuts();
            object = object2.iterator();
            while (object.hasNext()) {
                iterator = (URLChooserShortcut)object.next();
                uRL = iterator.url();
                FilesRootFilter.addRoot(uRL, arrayList2, arrayList);
            }
            object = URLFactory.newDirURL((String)Ide.getWorkDirectory());
            if (URLFileSystem.exists((URL)object)) {
                FilesRootFilter.addRoot((URL)object, arrayList2, arrayList);
            }
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    private static void addRoot(URL uRL, List<DirectoryRoot> list, List<Element> list2) {
        URL uRL2 = FilesRootFilter.findRoot(uRL, list);
        if (uRL2 != null) {
            list2.add((Element)FileElementFactory.getInstance().findOrCreateFolder(uRL, uRL2, PseudoRoot.class));
        }
    }

    public Comparator getComparator() {
        return null;
    }

    private static URL findRoot(URL uRL, List<DirectoryRoot> list) {
        for (DirectoryRoot directoryRoot : list) {
            URL uRL2 = directoryRoot.getRootURL();
            if (!URLFileSystem.isBaseURLFor((URL)uRL2, (URL)uRL)) continue;
            return uRL2;
        }
        return null;
    }

    static boolean isRoot(URL uRL) {
        Collection collection = URLChooserShortcuts.getInstance().getStandardDocumentLocationShortcuts();
        for (URLChooserShortcut uRLChooserShortcut : collection) {
            if (!URLFileSystem.equals((URL)uRLChooserShortcut.url(), (URL)uRL)) continue;
            return true;
        }
        return false;
    }

    public void setOwner(TNode tNode) {
        super.setOwner(tNode);
        TreeExplorer treeExplorer = tNode != null ? tNode.getOwner() : null;
        this.m_listener.setTree(treeExplorer);
    }

    private static class L
    implements URLFileSystemListener {
        private static final URL SYS_DIR = URLFactory.newDirURL((String)Ide.getSystemDirectory());
        private TreeExplorer m_exp;
        private Set<URL> m_roots = new HashSet<URL>();
        private static Map<TreeExplorer, Set<URL>> s_refreshURLs = new HashMap<TreeExplorer, Set<URL>>();
        private static Timer s_timer;

        private L() {
        }

        private void setTree(TreeExplorer treeExplorer) {
            this.m_exp = treeExplorer;
        }

        private void trackRoot(URL uRL) {
            URLFileSystem.addURLFileSystemListener((URL)uRL, (URLFileSystemListener)this);
            this.m_roots.add(uRL);
        }

        private void untrackAllRoots() {
            Iterator<URL> iterator = this.m_roots.iterator();
            while (iterator.hasNext()) {
                URL uRL = iterator.next();
                URLFileSystem.removeURLFileSystemListener((URL)uRL, (URLFileSystemListener)this);
                iterator.remove();
            }
        }

        public void notifyEvent(URLFileSystemEvent uRLFileSystemEvent) {
            if (this.m_exp == null) {
                return;
            }
            URL uRL = uRLFileSystemEvent.getURL();
            if (URLFileSystem.isBaseURLFor((URL)SYS_DIR, (URL)uRL)) {
                return;
            }
            System.out.println(uRLFileSystemEvent);
            URL uRL2 = URLFileSystem.getParent((URL)uRL);
            DirectoryFolder directoryFolder = FileElementFactory.getInstance().findFolder(uRL2);
            if (directoryFolder != null && directoryFolder.getState() == DirectoryFolder.NodeState.OPEN) {
                switch (uRLFileSystemEvent.getEventType()) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 10: 
                    case 11: 
                    case 12: {
                        L.scheduleRefresh(uRL2, this.m_exp);
                        break;
                    }
                }
            }
        }

        private static synchronized void scheduleRefresh(URL uRL, TreeExplorer treeExplorer) {
            Set<URL> set;
            if (s_timer == null) {
                s_timer = new Timer(500, new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Map<TreeExplorer, Set<URL>> map = null;
                        Class<L> clazz = L.class;
                        synchronized (L.class) {
                            if (!s_refreshURLs.isEmpty()) {
                                map = s_refreshURLs;
                                s_refreshURLs = new HashMap<TreeExplorer, Set<URL>>();
                            }
                            // ** MonitorExit[clazz] (shouldn't be in output)
                            if (map != null) {
                                for (Map.Entry entry : map.entrySet()) {
                                    FileNavigatorController.refreshNodes((Set)entry.getValue(), (TreeExplorer)entry.getKey());
                                }
                            }
                            return;
                        }
                    }
                });
                s_timer.start();
            }
            if ((set = s_refreshURLs.get(treeExplorer)) == null) {
                set = new HashSet<URL>();
                s_refreshURLs.put(treeExplorer, set);
            }
            set.add(uRL);
        }
    }
}

