/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.filenav;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import oracle.dbtools.raptor.filenav.FileElementFactory;
import oracle.dbtools.raptor.filenav.FileNavigatorAddin;
import oracle.ide.model.ApplicationContent;
import oracle.ide.model.ContentSet;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Locatable;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

class DirectoryFolder
extends DefaultElement
implements Locatable,
Subject,
Folder {
    private URL m_url;
    private URL m_root;
    private String m_label;
    private String m_relPath;
    private Subject m_subject;
    private final List<Element> m_children = new CopyOnWriteArrayList<Element>();
    private NodeState m_state = NodeState.CLOSED;

    protected DirectoryFolder(URL uRL) {
        this.setURL(uRL);
        this.m_root = uRL;
        this.m_relPath = "";
    }

    public DirectoryFolder(URL uRL, URL uRL2) {
        this.setURL(uRL);
        this.m_root = uRL2 != null ? uRL2 : URLFileSystem.getParent((URL)uRL);
        this.m_relPath = URLFileSystem.toRelativeSpec((URL)this.m_url, (URL)this.m_root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeState getState() {
        DirectoryFolder directoryFolder = this;
        synchronized (directoryFolder) {
            return this.m_state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean open(Workspace workspace) {
        Object object;
        Object object2 = this;
        synchronized (object2) {
            if (this.m_state == NodeState.LOADING || this.m_state == NodeState.OPEN) {
                return false;
            }
            this.m_state = NodeState.LOADING;
            this.m_children.clear();
        }
        try {
            workspace.open();
        }
        catch (IOException iOException) {
            FileNavigatorAddin.LOGGER.severe(iOException.getLocalizedMessage());
        }
        object2 = new ArrayList();
        ApplicationContent applicationContent = ApplicationContent.getInstance((PropertyStorage)workspace);
        ContentSet contentSet = applicationContent.getContentSet("RaptorFiles");
        if (contentSet != null) {
            object = this.getRelativePath();
            final URL uRL = this.getRootURL();
            FileElementFactory fileElementFactory = FileElementFactory.getInstance();
            for (Object e : contentSet.getFilesAndDirectories(object, null, new URLFilter(){

                public boolean accept(URL uRL2) {
                    return URLFileSystem.isBaseURLFor((URL)uRL, (URL)uRL2);
                }
            })) {
                URL uRL2 = (URL)e;
                Element element = fileElementFactory.createElement(uRL2, uRL);
                if (element == null) continue;
                object2.add(element);
            }
        }
        object = this;
        synchronized (object) {
            if (this.m_state == NodeState.LOADING) {
                this.m_children.addAll((Collection<Element>)object2);
                this.m_state = NodeState.OPEN;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        DirectoryFolder directoryFolder = this;
        synchronized (directoryFolder) {
            if (this.m_state == NodeState.CLOSED) {
                return;
            }
            this.m_children.clear();
            this.m_state = NodeState.CLOSED;
        }
    }

    protected String getSystemDisplayName() {
        return URLFileSystem.getSystemDisplayName((URL)this.m_url);
    }

    public String getLongLabel() {
        return this.getSystemDisplayName();
    }

    public String getShortLabel() {
        return this.m_label;
    }

    String getRelativePath() {
        return this.m_relPath;
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public URL getRootURL() {
        return this.m_root;
    }

    public URL getURL() {
        return this.m_url;
    }

    public void setURL(URL uRL) {
        this.m_url = uRL;
        this.setLabel(URLFileSystem.getFileName((URL)uRL));
    }

    protected void setLabel(String string) {
        this.m_label = string;
    }

    public void attach(Observer observer) {
        if (this.m_subject == null) {
            this.m_subject = new IdeSubject();
        }
        this.m_subject.attach(observer);
    }

    public void detach(Observer observer) {
        if (this.m_subject != null) {
            this.m_subject.detach(observer);
        }
    }

    public void notifyObservers(Object object, UpdateMessage updateMessage) {
        if (this.m_subject != null) {
            this.m_subject.notifyObservers(object, updateMessage);
        }
    }

    public Iterator getChildren() {
        return this.m_children.iterator();
    }

    public boolean mayHaveChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Element element) {
        if (this.canAdd(element)) {
            DirectoryFolder directoryFolder = this;
            synchronized (directoryFolder) {
                if (this.m_state == NodeState.OPEN) {
                    this.m_children.add(element);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean canAdd(Element element) {
        if (element instanceof Locatable) {
            URL uRL = ((Locatable)element).getURL();
            return ModelUtil.areEqual((Object)this.m_url, (Object)URLFileSystem.getParent((URL)uRL));
        }
        return false;
    }

    public boolean canRemove(Element element) {
        return this.containsChild(element);
    }

    public boolean containsChild(Element element) {
        return this.m_children.contains(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Element element) {
        if (this.canRemove(element)) {
            DirectoryFolder directoryFolder = this;
            synchronized (directoryFolder) {
                if (this.m_state == NodeState.OPEN) {
                    return this.m_children.remove(element);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        DirectoryFolder directoryFolder = this;
        synchronized (directoryFolder) {
            if (this.m_state == NodeState.OPEN) {
                this.m_children.clear();
            }
        }
    }

    public int size() {
        return this.m_children.size();
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"folder.png");
    }

    static enum NodeState {
        CLOSED,
        LOADING,
        OPEN;

    }
}

