/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.toolBar;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarActionListener;
import oracle.ewt.toolBar.ToolBarBaseItem;
import oracle.ewt.toolBar.ToolBarEvent;
import oracle.ewt.util.ImmInsets;
import oracle.ewt.util.InputEventUtils;

public abstract class ToolBarPainterItem
extends ToolBarBaseItem {
    private transient boolean _armed;
    private transient boolean _mouseOver;
    private transient boolean _mouseDown;
    private String _helpText;
    private ListenerManager _actionListeners;

    public boolean isArmed() {
        return this._armed;
    }

    protected Painter getPainter() {
        ToolBar toolBar = this.getParent();
        if (toolBar != null) {
            return toolBar.getToolBarUI().getButtonContentPainter(toolBar, this);
        }
        return null;
    }

    protected BorderPainter getBorderPainter() {
        ToolBar toolBar = this.getParent();
        if (toolBar != null) {
            return toolBar.getButtonBorderPainter();
        }
        return null;
    }

    public void addToolBarActionListener(ToolBarActionListener toolBarActionListener) {
        if (this._actionListeners == null) {
            this._actionListeners = new ListenerManager();
        }
        this._actionListeners.addListener(toolBarActionListener);
    }

    public void removeToolBarActionListener(ToolBarActionListener toolBarActionListener) {
        this._actionListeners.removeListener(toolBarActionListener);
    }

    public boolean mousePressed(MouseEvent mouseEvent, int n, int n2) {
        if (this.isEnabled() && InputEventUtils.isLeftMouseButton(mouseEvent)) {
            this._mouseDown = true;
            this._setArmed(true);
            this.paintItem();
        }
        return true;
    }

    public boolean mouseReleased(MouseEvent mouseEvent, int n, int n2) {
        boolean bl = this.isArmed();
        this._mouseDown = false;
        this._setArmed(false);
        if (bl && this.isEnabled() && this.inside(n, n2)) {
            this.activate();
        }
        if (bl) {
            this.paintItem();
        }
        return true;
    }

    public boolean mouseDragged(MouseEvent mouseEvent, int n, int n2) {
        if (this.isEnabled() && this._mouseDown) {
            boolean bl = this.inside(n, n2);
            if (this.isArmed() != bl) {
                this._mouseOver = bl;
                this._setArmed(bl);
                this.paintItem();
            }
        }
        return true;
    }

    public boolean mouseEntered(MouseEvent mouseEvent, int n, int n2) {
        this._mouseOver = true;
        this.paintItem();
        return false;
    }

    public boolean mouseExited(MouseEvent mouseEvent, int n, int n2) {
        this._mouseOver = false;
        this.paintItem();
        return false;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (dimension.width > 0 && dimension.height > 0) {
            Point point = this.getLocation();
            int n = point.x;
            int n2 = point.y;
            int n3 = dimension.width;
            int n4 = dimension.height;
            BorderPainter borderPainter = this.getBorderPainter();
            borderPainter.paint(this, graphics, n, n2, n3, n4);
            ImmInsets immInsets = borderPainter.getInsets(this);
            this.getPainter().paint(this, graphics, n += immInsets.left, n2 += immInsets.top, n3 -= immInsets.left + immInsets.right, n4 -= immInsets.top + immInsets.bottom);
        }
    }

    public Dimension getMinimumSize() {
        Painter painter = this.getPainter();
        if (painter != null) {
            return this._getOuterSize(painter.getMinimumSize(this));
        }
        return new Dimension();
    }

    public Dimension getPreferredSize() {
        Painter painter = this.getPainter();
        if (painter != null) {
            return this._getOuterSize(painter.getPreferredSize(this));
        }
        return new Dimension();
    }

    public String getHelpText() {
        return this._helpText;
    }

    public void setHelpText(String string) {
        this._helpText = string;
    }

    public int getPaintState() {
        int n = super.getPaintState();
        if (this.isArmed()) {
            n |= 2;
        }
        if (!this._mouseOver) {
            n &= 0xFFFFFFEF;
        }
        if (this.isPressed()) {
            n |= 8;
        }
        return n;
    }

    protected void activate() {
        Enumeration enumeration;
        ToolBar toolBar = this.getParent();
        ToolBarEvent toolBarEvent = new ToolBarEvent(toolBar, 2000, this);
        ListenerManager listenerManager = this._actionListeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                ToolBarActionListener toolBarActionListener = (ToolBarActionListener)enumeration.nextElement();
                toolBarActionListener.toolBarItemActionPerformed(toolBarEvent);
            }
        }
        if (toolBar != null) {
            toolBar.dispatchEvent(toolBarEvent);
        }
    }

    protected boolean isPressed() {
        return this.isArmed();
    }

    private void _setArmed(boolean bl) {
        this._armed = bl;
    }

    private Dimension _getOuterSize(Dimension dimension) {
        BorderPainter borderPainter = this.getBorderPainter();
        if (borderPainter != null) {
            ImmInsets immInsets = this.getBorderPainter().getInsets(this);
            dimension.width += immInsets.left + immInsets.right;
            dimension.height += immInsets.top + immInsets.bottom;
        }
        return dimension;
    }
}

