/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.toolBar;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarItem;

public abstract class ToolBarBaseItem
extends ToolBarItem {
    private ToolBar _parent;
    private int _x;
    private int _y;
    private int _width;
    private int _height;
    private boolean _enabled = true;
    private boolean _visible = true;

    protected void setParent(ToolBar toolBar) {
        this._parent = toolBar;
    }

    public ToolBar getParent() {
        return this._parent;
    }

    public void setLocation(int n, int n2) {
        this._x = n;
        this._y = n2;
    }

    public Point getLocation() {
        return new Point(this._x, this._y);
    }

    public Dimension getSize() {
        return new Dimension(this._width, this._height);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return this.getSize();
    }

    public final void setSize(int n, int n2) {
        if (this._width != n || this._height != n2) {
            this.storeSize(n, n2);
            this.invalidateParent();
        }
    }

    public void storeSize(int n, int n2) {
        this._width = n;
        this._height = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inside(int n, int n2) {
        if (!this.isVisible()) {
            return false;
        }
        ToolBarBaseItem toolBarBaseItem = this;
        synchronized (toolBarBaseItem) {
            Point point = this.getLocation();
            Dimension dimension = this.getSize();
            return n >= point.x && n < point.x + dimension.width && n2 >= point.y && n2 < point.y + dimension.height;
        }
    }

    public boolean isVisible() {
        return this._visible;
    }

    public synchronized void setVisible(boolean bl) {
        if (this._visible != bl) {
            this._visible = bl;
            this.invalidateParent();
        }
    }

    public boolean isEnabled() {
        ToolBar toolBar = this.getParent();
        boolean bl = this.isItemEnabled();
        if (toolBar == null) {
            return bl;
        }
        return bl && toolBar.isEnabled();
    }

    public synchronized void setEnabled(boolean bl) {
        if (this.isItemEnabled() != bl) {
            this.storeEnabled(bl);
            ToolBar toolBar = this.getParent();
            if (toolBar != null && toolBar.isEnabled()) {
                this.paintItem();
            }
        }
    }

    public void paint(Graphics graphics) {
    }

    public Component getComponent() {
        return null;
    }

    protected void repaintItem() {
        ToolBar toolBar = this.getParent();
        if (toolBar != null && toolBar.isShowing() && this.isVisible()) {
            toolBar.repaintCanvas(this._x, this._y, this._width, this._height);
        }
    }

    protected void paintItem() {
        ToolBar toolBar = this.getParent();
        if (toolBar != null && toolBar.isShowing() && this.isVisible()) {
            toolBar.paintImmediateCanvas(this._x, this._y, this._width, this._height);
        }
    }

    protected void invalidateParent() {
        ToolBar toolBar = this.getParent();
        if (toolBar != null) {
            toolBar.invalidateCanvas();
            Container container = toolBar.getParent();
        }
    }

    protected void storeEnabled(boolean bl) {
        this._enabled = bl;
    }

    protected boolean isItemEnabled() {
        return this._enabled;
    }
}

