/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.spinBox;

import javax.accessibility.AccessibleContext;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.iterator.Range;
import oracle.ewt.lwAWT.lwText.NumberTextField;
import oracle.ewt.spinBox.SpinBuddy;

class NumericSpinBuddy
extends NumberTextField
implements SpinBuddy {
    Range _range;

    public NumericSpinBuddy() {
        this.setDecimal(false);
        this.setBorderPainter(null);
        this.setFill(null);
    }

    public void setValue(Object object) {
        if (!object.equals(this.getNumber())) {
            this.__setValue(object, true);
        }
    }

    public void setRange(Range range) {
        this.setSigned(range.getLowerLimit() < 0);
        int n = this._digits(range.getLowerLimit());
        int n2 = this._digits(range.getUpperLimit());
        this.setColumns(Math.max(n, n2));
        this.setMaximumChars(Math.max(n, n2));
        this._range = range;
    }

    protected boolean validateNumber(Number number) {
        Range range = this._range;
        if (range == null) {
            return true;
        }
        int n = number.intValue();
        return (n >= 0 || n >= range.getLowerLimit()) && (n <= 0 || n <= range.getUpperLimit());
    }

    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    private int _digits(int n) {
        int n2;
        if (n < 0) {
            n = -n;
            n2 = 1;
        } else {
            n2 = 0;
        }
        do {
            ++n2;
        } while ((n /= 10) > 0);
        return n2;
    }

    void __setValue(Object object, boolean bl) {
        this.setNumber((Number)object);
        if (bl) {
            this.selectAll();
        }
    }

    private class Access
    extends NumberTextField.NumberAccess {
        private Access() {
        }

        public String getAccessibleName() {
            String string = super.getAccessibleName();
            return string == null ? this.getAccessibleParent().getAccessibleContext().getAccessibleName() : string;
        }

        public String getAccessibleDescription() {
            String string = super.getAccessibleDescription();
            return string == null ? this.getAccessibleParent().getAccessibleContext().getAccessibleDescription() : string;
        }

        public Number getMinimumAccessibleValue() {
            return IntegerUtils.getInteger((int)NumericSpinBuddy.this._range.getLowerLimit());
        }

        public Number getMaximumAccessibleValue() {
            return IntegerUtils.getInteger((int)NumericSpinBuddy.this._range.getUpperLimit());
        }
    }
}

