/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.ruler;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.EwtComponent;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.RulerUI;
import oracle.ewt.ruler.RulerStyle;

public class Ruler
extends EwtComponent {
    public static final int MARKER_NOT_VISIBLE = -1;
    private static final int _DEFAULT_SIZE = 20;
    private static final String _TEST_STRING = "111";
    private static final int _EXTRA_SIZE = 7;
    private Painter _painter;
    private boolean _horizontal;
    private boolean _showNumbers;
    private RulerStyle _rulerStyle;
    private PropertyChangeSupport _support;
    private int _markerPosition;
    private int _scrollPosition;

    public Ruler() {
        this(true);
    }

    public Ruler(boolean bl) {
        this._horizontal = bl;
        this._markerPosition = -1;
        this._scrollPosition = 0;
        this._showNumbers = true;
        this.updateUI(Ruler.class);
    }

    public int getMarkerPosition() {
        return this._markerPosition;
    }

    public int getScrollPosition() {
        return this._scrollPosition;
    }

    public RulerStyle getRulerStyle() {
        if (this._rulerStyle == null) {
            this._rulerStyle = RulerStyle.getInches();
        }
        return this._rulerStyle;
    }

    public boolean isHorizontal() {
        return this._horizontal;
    }

    public boolean getShowNumbers() {
        return this._showNumbers;
    }

    public void setRulerStyle(RulerStyle rulerStyle) {
        if (rulerStyle != this.getRulerStyle()) {
            this._rulerStyle = rulerStyle;
            this.repaintCanvas();
        }
    }

    public void setHorizontal(boolean bl) {
        if (bl != this.isHorizontal()) {
            Boolean bl2 = new Boolean(this._horizontal);
            this._horizontal = bl;
            this._firePropertyChanged("horizontal", bl2, new Boolean(this._horizontal));
            this.repaintCanvas();
        }
    }

    public void setMarkerPosition(int n) {
        if (this._markerPosition != n) {
            Integer n2 = IntegerUtils.getInteger((int)this._markerPosition);
            this.freezeRepaints();
            if (this.isHorizontal()) {
                this.repaintCanvas(this._markerPosition - 1, 0, 2, this.getInnerSize().height);
            } else {
                this.repaintCanvas(0, this._markerPosition, this.getInnerSize().width, 2);
            }
            this._markerPosition = n;
            this._firePropertyChanged("markerPosition", n2, IntegerUtils.getInteger((int)this._markerPosition));
            if (this.isHorizontal()) {
                this.repaintCanvas(this._markerPosition - 1, 0, 2, this.getInnerSize().height);
            } else {
                this.repaintCanvas(0, this._markerPosition, this.getInnerSize().width, 2);
            }
            this.unfreezeRepaints();
        }
    }

    public void setShowNumbers(boolean bl) {
        if (bl != this.getShowNumbers()) {
            Boolean bl2 = new Boolean(this._showNumbers);
            this._showNumbers = bl;
            this._firePropertyChanged("showNumbers", bl2, new Boolean(this._showNumbers));
            this.repaintCanvas();
        }
    }

    public void setScrollPosition(int n) {
        if (n != this.getScrollPosition()) {
            Integer n2 = IntegerUtils.getInteger((int)this._scrollPosition);
            this._scrollPosition = n;
            this._firePropertyChanged("scrollPosition", n2, IntegerUtils.getInteger((int)this._scrollPosition));
            if (this.isHorizontal()) {
                this.setCanvasOrigin(-this._scrollPosition, 0);
            } else {
                this.setCanvasOrigin(0, -this._scrollPosition);
            }
        }
    }

    public RulerUI getRulerUI() {
        return (RulerUI)this.getUI();
    }

    public boolean isHScrollable() {
        return this.isHorizontal();
    }

    public boolean isVScrollable() {
        return !this.isHorizontal();
    }

    public Dimension getPreferredSize() {
        int n;
        int n2 = 0;
        int n3 = 0;
        Font font = this.getFont();
        int n4 = n = font == null ? 20 : this.getFontMetrics(font).stringWidth(_TEST_STRING) + 7;
        if (this.isHorizontal()) {
            n2 = Integer.MAX_VALUE;
            n3 = n;
        } else {
            n3 = Integer.MAX_VALUE;
            n2 = n;
        }
        return this.convertInnerToOuterSize(n2, n3);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.getPreferredSize();
        if (this.isHorizontal()) {
            dimension.width = dimension.height;
        } else {
            dimension.height = dimension.width;
        }
        return dimension;
    }

    public Object getUIClassID() {
        return "RulerUI";
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._support == null) {
            this._support = new PropertyChangeSupport(this);
        }
        this._support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._support != null) {
            this._support.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected void paintCanvasInterior(Graphics graphics) {
        Dimension dimension = this.getInnerSize();
        this.getPainter().paint(this.getPaintContext(), graphics, 0, 0, dimension.width, dimension.height);
    }

    public Painter getPainter() {
        if (this._painter == null) {
            this._painter = this.getRulerUI().getPainter(this);
        }
        return this._painter;
    }

    protected Dimension layoutCanvas() {
        Dimension dimension = this.getInnerSize();
        if (this.isHorizontal()) {
            dimension.width = Integer.MAX_VALUE;
        } else {
            dimension.height = Integer.MAX_VALUE;
        }
        return dimension;
    }

    protected void updateUI(Class clazz) {
        if (clazz == Ruler.class) {
            this.updateUI();
        }
    }

    private void _firePropertyChanged(String string, Object object, Object object2) {
        if (this._support != null) {
            this._support.firePropertyChange(string, object, object2);
        }
    }
}

