/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import oracle.ewt.UIDefaults;
import oracle.ewt.painter.AbstractBorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.util.ImmInsets;

public class SeparatorBorderPainter
extends AbstractBorderPainter {
    public static final int ORIENTATION_TOP = 0;
    public static final int ORIENTATION_BOTTOM = 1;
    public static final int ORIENTATION_LEFT = 2;
    public static final int ORIENTATION_RIGHT = 3;
    private int _thickness;
    private int _orientation;
    private boolean _inset;

    public SeparatorBorderPainter(int n, boolean bl, int n2) {
        this(null, n, bl, n2);
    }

    public SeparatorBorderPainter(Painter painter, int n, boolean bl, int n2) {
        super(painter);
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException();
        }
        this._thickness = n;
        this._orientation = n2;
        this._inset = bl;
    }

    protected ImmInsets getOwnInsets(PaintContext paintContext) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this._thickness;
        switch (this._orientation) {
            case 0: {
                n = n5;
                break;
            }
            case 1: {
                n3 = n5;
                break;
            }
            case 3: {
                n4 = n5;
                break;
            }
            case 2: {
                n2 = n5;
            }
        }
        return new ImmInsets(n, n2, n3, n4);
    }

    protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Painter painter = this._getPainter(paintContext);
        Dimension dimension = painter.getPreferredSize(paintContext);
        switch (this._orientation) {
            case 0: {
                painter.paint(paintContext, graphics, n, n2, n3, dimension.height);
                break;
            }
            case 1: {
                painter.paint(paintContext, graphics, n, n2 + n4 - dimension.height, n3, dimension.height);
                break;
            }
            case 2: {
                painter.paint(paintContext, graphics, n, n2, dimension.width, n4);
                break;
            }
            case 3: {
                painter.paint(paintContext, graphics, n + n3 - dimension.width, n2, dimension.width, n4);
            }
        }
    }

    protected boolean isBorderTransparent(PaintContext paintContext) {
        return true;
    }

    private Painter _getPainter(PaintContext paintContext) {
        boolean bl;
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        boolean bl2 = bl = this._orientation == 0 || this._orientation == 1;
        String string = this._inset ? (bl ? "HorizInsetSeparator" : "VertInsetSeparator") : (bl ? "HorizOutsetSeparator" : "VertOutsetSeparator");
        return uIDefaults.getPainter(string);
    }
}

