/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import oracle.ewt.painter.AbstractBorderPainter;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.util.ImmInsets;

public class InnerEdgeBorderPainterJoiner
extends AbstractBorderPainter {
    public static final int LOCATION_RIGHT = 0;
    public static final int LOCATION_TOP = 1;
    public static final int LOCATION_BOTTOM = 2;
    public static final int LOCATION_LEFT = 3;
    public static final int LOCATION_DEFAULT = 4;
    public static final int LOCATION_ANTIDEFAULT = 5;
    private BorderPainter _outerBorder;
    private Painter _edgePainter;
    private int _edgeLocation;

    public InnerEdgeBorderPainterJoiner(BorderPainter borderPainter, Painter painter, int n) {
        this(null, borderPainter, painter, n);
    }

    public InnerEdgeBorderPainterJoiner(Painter painter, BorderPainter borderPainter, Painter painter2, int n) {
        super(painter);
        if (borderPainter == null) {
            borderPainter = NullPainter.getPainter();
        }
        if (painter2 == null) {
            painter2 = NullPainter.getPainter();
        }
        this._outerBorder = borderPainter;
        this._edgePainter = painter2;
        this._edgeLocation = n;
    }

    public int getRepaintFlags(PaintContext paintContext) {
        return this._outerBorder.getRepaintFlags(paintContext) | this._edgePainter.getRepaintFlags(paintContext);
    }

    public int getInvalidateFlags(PaintContext paintContext) {
        return this._outerBorder.getInvalidateFlags(paintContext) | this._edgePainter.getInvalidateFlags(paintContext);
    }

    protected ImmInsets getOwnInsets(PaintContext paintContext) {
        ImmInsets immInsets = this._outerBorder.getInsets(paintContext);
        Dimension dimension = this._edgePainter.getPreferredSize(paintContext);
        int n = immInsets.top;
        int n2 = immInsets.left;
        int n3 = immInsets.bottom;
        int n4 = immInsets.right;
        switch (this._getActualLocation(paintContext)) {
            case 3: {
                n2 += dimension.width;
                break;
            }
            case 0: {
                n4 += dimension.width;
                break;
            }
            case 1: {
                n += dimension.height;
                break;
            }
            case 2: {
                n3 += dimension.height;
            }
        }
        return new ImmInsets(n, n2, n3, n4);
    }

    protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this._outerBorder.paint(paintContext, graphics, n, n2, n3, n4);
        ImmInsets immInsets = this._outerBorder.getInsets(paintContext);
        Dimension dimension = this._edgePainter.getPreferredSize(paintContext);
        int n5 = immInsets.top;
        int n6 = immInsets.left;
        int n7 = immInsets.bottom;
        int n8 = immInsets.right;
        int n9 = n3 - n6 - n8;
        int n10 = n4 - n5 - n7;
        switch (this._getActualLocation(paintContext)) {
            case 3: {
                n9 = dimension.width;
                break;
            }
            case 0: {
                n6 += n9 - dimension.width;
                n9 = dimension.width;
                break;
            }
            case 1: {
                n10 = dimension.height;
                break;
            }
            case 2: {
                n5 += n10 - dimension.height;
                n10 = dimension.height;
            }
        }
        this._edgePainter.paint(paintContext, graphics, n + n6, n2 + n5, n9, n10);
    }

    protected Painter getBorderPainterAt(PaintContext paintContext, int n, int n2, int n3, int n4, Painter painter) {
        ImmInsets immInsets = this._outerBorder.getInsets(paintContext);
        Dimension dimension = this._edgePainter.getPreferredSize(paintContext);
        int n5 = immInsets.top;
        int n6 = immInsets.left;
        int n7 = immInsets.bottom;
        int n8 = immInsets.right;
        switch (this._getActualLocation(paintContext)) {
            case 3: {
                n6 += dimension.width;
                break;
            }
            case 0: {
                n8 += dimension.width;
                break;
            }
            case 1: {
                n5 += dimension.height;
                break;
            }
            case 2: {
                n7 += dimension.height;
            }
        }
        Painter painter2 = this._edgePainter.getPainterAt(paintContext, n - n6 - n8, n2 - n7 - n5, n3 + n6, n4 + n5, painter);
        if (painter2 == null) {
            painter2 = this._outerBorder.getPainterAt(paintContext, n, n2, n3, n4, painter);
        }
        if (painter == this && painter2 != null) {
            painter2 = this;
        }
        return painter2;
    }

    protected boolean isBorderTransparent(PaintContext paintContext) {
        return this._outerBorder.isTransparent(paintContext) || this._edgePainter.isTransparent(paintContext);
    }

    private int _getActualLocation(PaintContext paintContext) {
        int n = this._edgeLocation;
        if (n == 4 || n == 5) {
            int n2 = paintContext.getReadingDirection();
            boolean bl = n2 == 2 ^ n == 4;
            n = bl ? 3 : 0;
        }
        return n;
    }
}

