/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.multiLineLabel;

import java.awt.FontMetrics;
import java.util.Locale;
import oracle.ewt.multiLineLabel.LineInfo;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.PreferredWrapInfo;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.ewt.util.StringUtils;

class LabelGeometry
implements PreferredWrapInfo {
    private MultiLineLabel _label;
    private TextWrapper _wrapper;
    private String _text;
    private FontMetrics _metrics;
    private int _wrapWidth;
    private LineInfo[] _lineInfos;
    private int _topLineInfoIndex;
    private int _maxPixelWidth;
    private boolean _isValid;
    private boolean _preferred;

    LabelGeometry(MultiLineLabel multiLineLabel, TextWrapper textWrapper, String string) {
        this(multiLineLabel, textWrapper, string, null, 0, false);
    }

    LabelGeometry(MultiLineLabel multiLineLabel, TextWrapper textWrapper, String string, FontMetrics fontMetrics, int n, boolean bl) {
        if (multiLineLabel == null) {
            throw new IllegalArgumentException("Null MultiLineLabel");
        }
        if (textWrapper == null) {
            throw new IllegalArgumentException("Null TextWrapper");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Null Paragraph wrapper");
        }
        this._label = multiLineLabel;
        this._text = string;
        this._wrapper = textWrapper;
        this._metrics = fontMetrics;
        this._wrapWidth = n;
        this._preferred = bl;
        this._isValid = true;
        this._invalidate();
    }

    public boolean addLine(String string, int n, int n2) {
        Object object;
        LineInfo lineInfo = this._getNextLineInfo();
        if (string == null) {
            lineInfo.text = null;
            lineInfo.pixelWidth = 0;
            lineInfo.isNotWrapped = true;
        } else {
            object = string.substring(n, n2);
            lineInfo.text = object = StringUtils.getDisplayString((String)object, this.getLocale(), this._label.getActualReadingDirection());
            lineInfo.pixelWidth = this.getFontMetrics().stringWidth((String)object);
            if (this._maxPixelWidth < lineInfo.pixelWidth) {
                this._maxPixelWidth = lineInfo.pixelWidth;
            }
            lineInfo.isNotWrapped = n2 == string.length();
        }
        object = this._getPreviousLineInfo();
        lineInfo.isNewParagraph = object == null || ((LineInfo)object).isNotWrapped;
        return true;
    }

    public int getWrapWidth() {
        return this._wrapWidth;
    }

    public FontMetrics getFontMetrics() {
        return this._metrics;
    }

    public Locale getLocale() {
        return this._label.getLocale();
    }

    public int getMaxPixelWidth() {
        this._validate();
        return this._maxPixelWidth;
    }

    public int getLineCount() {
        this._validate();
        return this._topLineInfoIndex;
    }

    public LineInfo getLineInfo(int n, LineInfo lineInfo) {
        if (!this._isValid) {
            return null;
        }
        this._lineInfos[n].copy(lineInfo);
        return lineInfo;
    }

    public boolean isCalculatingPreferred() {
        return this._preferred;
    }

    protected boolean isValid() {
        return this._isValid;
    }

    void _setText(String string) {
        if (this._text != string) {
            this._text = string;
            this._invalidate();
        }
    }

    String _getText() {
        return this._text;
    }

    void _setTextWrapper(TextWrapper textWrapper) {
        if (this._wrapper != textWrapper) {
            this._wrapper = textWrapper;
            this._invalidate();
        }
    }

    TextWrapper _getTextWrapper() {
        return this._wrapper;
    }

    void _setWrapWidth(int n) {
        if (this._wrapWidth != n) {
            this._wrapWidth = n;
            this._invalidate();
        }
    }

    void _setFontMetrics(FontMetrics fontMetrics) {
        if (fontMetrics != this._metrics) {
            this._metrics = fontMetrics;
            this._invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _invalidate() {
        if (this._isValid) {
            boolean bl = false;
            LabelGeometry labelGeometry = this;
            synchronized (labelGeometry) {
                if (this._isValid) {
                    this._isValid = false;
                    this._topLineInfoIndex = 0;
                    this._maxPixelWidth = 0;
                    bl = true;
                }
            }
            if (bl) {
                this._label.invalidateMultiLineLabelCanvas();
            }
        }
    }

    synchronized void _validate() {
        if (!this._isValid && this._metrics != null) {
            this._wrapText();
            this._isValid = true;
        }
    }

    private LineInfo _getPreviousLineInfo() {
        if (this._topLineInfoIndex > 1) {
            return this._lineInfos[this._topLineInfoIndex - 2];
        }
        return null;
    }

    private LineInfo _getNextLineInfo() {
        if (this._lineInfos == null || this._topLineInfoIndex == this._lineInfos.length) {
            this._lineInfos = LineInfo._reallocExact(this._lineInfos, this._topLineInfoIndex + 1);
            this._lineInfos[this._topLineInfoIndex] = new LineInfo();
        }
        LineInfo lineInfo = this._lineInfos[this._topLineInfoIndex];
        ++this._topLineInfoIndex;
        return lineInfo;
    }

    private void _wrapText() {
        String string = this._text;
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        do {
            if ((n2 = string.indexOf(10, n3)) == -1) {
                n2 = n;
            }
            if (n2 == n3) {
                this.addLine(null, 0, 0);
                continue;
            }
            this._wrapper.wrapParagraph(this, string.substring(n3, n2));
        } while ((n3 = n2 + 1) < n);
        this._lineInfos = LineInfo._reallocExact(this._lineInfos, this._topLineInfoIndex);
    }
}

