/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwText.im;

import java.awt.Graphics;
import java.awt.im.InputMethodRequests;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.lwAWT.lwText.LWCommonText;

public final class InputMethodManager {
    private static boolean _JDK12orHigher = false;
    private static boolean _isInlineIME;
    private static Method _sEndCompositionMethod;
    private Object _IMEUtilObj;
    private Class _IMEUtilCls;
    private Method _paintDisplayTextMethod;
    private Method _makeRowStringMethod;
    private Method _getInputMethodRequestsMethod;

    private InputMethodManager() {
    }

    public InputMethodManager(LWCommonText lWCommonText) {
        if (InputMethodManager.isInlineIMEEnabled()) {
            try {
                this._IMEUtilCls = Class.forName("oracle.ewt.lwAWT.lwText.im.InputMethodUtil");
                Constructor constructor = this._IMEUtilCls.getConstructor(LWCommonText.class);
                this._IMEUtilObj = constructor.newInstance(lWCommonText);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final boolean isInlineIMEEnabled() {
        return _JDK12orHigher && _isInlineIME;
    }

    public static void setInlineIMEEnabled(boolean bl) {
        _isInlineIME = bl;
    }

    public boolean paintText(Graphics graphics, int n, int n2) {
        boolean bl = false;
        if (this._IMEUtilObj != null && InputMethodManager.isInlineIMEEnabled()) {
            try {
                if (this._paintDisplayTextMethod == null) {
                    this._paintDisplayTextMethod = this._IMEUtilCls.getMethod("paintDisplayText", Object.class, Graphics.class, Integer.TYPE, Integer.TYPE);
                }
                Boolean bl2 = (Boolean)this._paintDisplayTextMethod.invoke((Object)this._IMEUtilCls, this._IMEUtilObj, graphics, IntegerUtils.getInteger((int)n), IntegerUtils.getInteger((int)n2));
                bl = bl2;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return bl;
    }

    public void makeRowString(int n, int n2) {
        if (this._IMEUtilObj != null && InputMethodManager.isInlineIMEEnabled()) {
            try {
                if (this._makeRowStringMethod == null) {
                    this._makeRowStringMethod = this._IMEUtilCls.getMethod("makeRowString", Integer.TYPE, Integer.TYPE);
                }
                this._makeRowStringMethod.invoke(this._IMEUtilObj, IntegerUtils.getInteger((int)n), IntegerUtils.getInteger((int)n2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public InputMethodRequests getInputMethodRequests() {
        InputMethodRequests inputMethodRequests = null;
        if (InputMethodManager.isInlineIMEEnabled()) {
            try {
                if (this._getInputMethodRequestsMethod == null) {
                    this._getInputMethodRequestsMethod = this._IMEUtilCls.getMethod("getInputMethodRequests", null);
                }
                inputMethodRequests = (InputMethodRequests)this._getInputMethodRequestsMethod.invoke(this._IMEUtilObj, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return inputMethodRequests;
    }

    public void endComposition() {
        if (InputMethodManager.isInlineIMEEnabled()) {
            try {
                if (_sEndCompositionMethod == null) {
                    _sEndCompositionMethod = this._IMEUtilCls.getMethod("endComposition", null);
                }
                _sEndCompositionMethod.invoke(this._IMEUtilObj, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("java.awt.event.InputMethodEvent");
            _JDK12orHigher = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        _isInlineIME = true;
        _sEndCompositionMethod = null;
    }
}

