/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwText;

import java.awt.Font;
import java.awt.FontMetrics;
import oracle.ewt.graphics.FontUtils;
import oracle.ewt.util.StringUtils;

class TabbedFontMetrics
extends FontMetrics {
    private int _tabStop;
    private FontMetrics _metrics;

    protected TabbedFontMetrics(FontMetrics fontMetrics, int n) {
        super(fontMetrics.getFont());
        this._metrics = fontMetrics;
        this._calculateTabStop(n);
    }

    public Font getFont() {
        return this._metrics.getFont();
    }

    public int getLeading() {
        return this._metrics.getLeading();
    }

    public int getAscent() {
        return this._metrics.getAscent();
    }

    public int getDescent() {
        return this._metrics.getDescent();
    }

    public int getHeight() {
        return this._metrics.getHeight();
    }

    public int getMaxAscent() {
        return this._metrics.getMaxAscent();
    }

    public int getMaxDescent() {
        return this._metrics.getMaxDescent();
    }

    public int getMaxAdvance() {
        return this._metrics.getMaxAdvance();
    }

    public int charWidth(char c) {
        if (c == '\t') {
            return this._getTabStop();
        }
        return this._metrics.charWidth(c);
    }

    public int stringWidth(String string) {
        boolean bl = StringUtils.containsRightToLeft(string);
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            int n4 = string.indexOf(9, n2);
            if (n4 < 0) {
                n4 = n3;
            }
            n += this._metrics.stringWidth(string.substring(n2, n4));
            if (n4 < n3) {
                n = this.getNextTab(n, bl);
            }
            n2 = n4 + 1;
        }
        return n;
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        return this.stringWidth(new String(cArray, n, n2));
    }

    public int bytesWidth(byte[] byArray, int n, int n2) {
        return this.stringWidth(new String(byArray, n, n2));
    }

    public int[] getWidths() {
        int[] nArray = this._metrics.getWidths();
        nArray[9] = this._getTabStop();
        return nArray;
    }

    public int getNextTab(int n, boolean bl) {
        int n2 = this._getTabStop();
        if (bl) {
            return n + n2;
        }
        return (n / n2 + 1) * n2;
    }

    private int _getTabStop() {
        return this._tabStop;
    }

    private void _calculateTabStop(int n) {
        this._tabStop = n * FontUtils.getAverageWidth(this._metrics);
    }
}

