/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwText;

import java.awt.Point;
import java.awt.Rectangle;
import java.text.BreakIterator;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.lwAWT.lwText.LWTextComponent;

abstract class AccessibleLWTextComponent
extends AccessibleLWComponent
implements AccessibleText {
    public AccessibleLWTextComponent(LWTextComponent lWTextComponent) {
        super(lWTextComponent);
    }

    public AccessibleStateSet getAccessibleStateSet() {
        AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
        if (this._getLWTextComponent().isEditable()) {
            accessibleStateSet.add(AccessibleState.EDITABLE);
        }
        return accessibleStateSet;
    }

    public AccessibleRole getAccessibleRole() {
        return AccessibleRole.TEXT;
    }

    public AccessibleText getAccessibleText() {
        return this;
    }

    public abstract int getIndexAtPoint(Point var1);

    public abstract Rectangle getCharacterBounds(int var1);

    public int getCharCount() {
        return this._getTextLength();
    }

    public int getCaretPosition() {
        return this.getSelectionStart();
    }

    public String getAtIndex(int n, int n2) {
        String string = this.getActualText();
        if (n2 < 0 || n2 >= string.length()) {
            return null;
        }
        switch (n) {
            case 1: {
                return string.substring(n2, n2 + 1);
            }
            case 2: {
                BreakIterator breakIterator = this._getIterator(n);
                breakIterator.setText(string);
                int n3 = breakIterator.following(n2);
                return string.substring(breakIterator.previous(), n3);
            }
            case 3: {
                return string;
            }
        }
        return null;
    }

    public String getAfterIndex(int n, int n2) {
        if (n == 1) {
            return this.getAtIndex(n, n2 + 1);
        }
        if (n != 2 && n != 3) {
            return null;
        }
        String string = this.getActualText();
        if (n2 < 0 || n2 >= string.length()) {
            return null;
        }
        BreakIterator breakIterator = this._getIterator(n);
        breakIterator.setText(string);
        int n3 = breakIterator.following(n2);
        if (n3 == -1 || n3 >= string.length()) {
            return null;
        }
        int n4 = breakIterator.following(n3);
        if (n4 == -1 || n4 >= string.length()) {
            return null;
        }
        return string.substring(n3, n4);
    }

    public String getBeforeIndex(int n, int n2) {
        if (n == 1) {
            return this.getAtIndex(n, n2 - 1);
        }
        if (n != 2 && n != 3) {
            return null;
        }
        String string = this.getActualText();
        if (n2 < 0 || n2 >= string.length()) {
            return null;
        }
        BreakIterator breakIterator = this._getIterator(n);
        breakIterator.setText(string);
        breakIterator.following(n2);
        int n3 = breakIterator.previous();
        int n4 = breakIterator.previous();
        if (n4 == -1) {
            return null;
        }
        return string.substring(n4, n3);
    }

    public AttributeSet getCharacterAttribute(int n) {
        return SimpleAttributeSet.EMPTY;
    }

    public int getSelectionStart() {
        return this._getLWTextComponent().getSelectionStart();
    }

    public int getSelectionEnd() {
        return this._getLWTextComponent().getSelectionEnd();
    }

    public String getSelectedText() {
        return this._getLWTextComponent().getSelectedText();
    }

    protected String getActualText() {
        return this._getLWTextComponent().getText();
    }

    private BreakIterator _getIterator(int n) {
        if (n == 2) {
            return BreakIterator.getWordInstance(this.getLocale());
        }
        return BreakIterator.getSentenceInstance(this.getLocale());
    }

    private int _getTextLength() {
        String string = this.getActualText();
        return string == null ? 0 : string.length();
    }

    private LWTextComponent _getLWTextComponent() {
        return (LWTextComponent)this.getComponent();
    }
}

