/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.lwAWT.AbstractPainterComponent;
import oracle.ewt.util.InputEventUtils;
import oracle.ewt.util.LocaleUtils;

public abstract class AbstractButton
extends AbstractPainterComponent {
    static final String _RESOURCE_BUNDLE = "oracle.ewt.access.resource.AccessibilityBundle";
    private boolean _interacting;
    private boolean _keyDown;
    private boolean _mousePressed;
    private boolean _focusable = true;
    private static int _sInstanceCounter = 0;
    private static final int _SIMULATE_PUSH_PAUSE = 100;

    public AbstractButton() {
        this.enableEvents(60L);
    }

    public void simulatePush() {
        this.setInteracting(true);
        this.setArmed(true);
        this.paintImmediate();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setArmed(false);
        this.setInteracting(false);
        this.paintImmediate();
        this.activate(0);
    }

    public void setFocusable(boolean bl) {
        if (bl != this._focusable) {
            this._focusable = bl;
            if (!bl && this.hasFocus()) {
                this.transferFocus();
            }
        }
    }

    public boolean isFocusable() {
        return this._focusable;
    }

    public boolean isFocusTraversable() {
        return this.isFocusable();
    }

    public void disable() {
        if (this.isEnabled()) {
            super.disable();
            this.terminateInteraction();
        }
    }

    public void requestFocus() {
        if (this.isFocusable()) {
            super.requestFocus();
        }
    }

    public void postProcessKey(KeyEvent keyEvent) {
        this._processKeyPress(keyEvent, true);
        if (!keyEvent.isConsumed()) {
            super.postProcessKey(keyEvent);
        }
    }

    protected int getPaintState() {
        int n = super.getPaintState();
        if (this.isArmed()) {
            n |= 2;
        }
        return n;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (!this.hasFocus() && !this._mousePressed) {
            this.terminateInteraction();
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        this._processKeyPress(keyEvent, false);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (!mouseEvent.isConsumed() && !this._keyDown) {
            boolean bl = false;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            switch (mouseEvent.getID()) {
                case 505: {
                    bl = this.processMouseExited(mouseEvent, n, n2);
                    break;
                }
                case 501: {
                    bl = this.processMousePressed(mouseEvent, n, n2);
                    break;
                }
                case 502: {
                    bl = this.processMouseReleased(mouseEvent, n, n2);
                }
            }
            if (bl) {
                mouseEvent.consume();
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (!mouseEvent.isConsumed() && !this._keyDown) {
            boolean bl = false;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            switch (mouseEvent.getID()) {
                case 503: {
                    bl = this.processMouseMoved(mouseEvent, n, n2);
                    break;
                }
                case 506: {
                    bl = this.processMouseDragged(mouseEvent, n, n2);
                }
            }
            if (bl) {
                mouseEvent.consume();
            }
        }
    }

    protected boolean processMousePressed(MouseEvent mouseEvent, int n, int n2) {
        if (this.isEnabled() && InputEventUtils.isLeftMouseButton(mouseEvent)) {
            this._mousePressed = true;
            if (this.isFocusable()) {
                this.requestFocus();
            }
            this.setInteracting(true);
            this.setArmed(true);
            return true;
        }
        return false;
    }

    protected boolean processMouseReleased(MouseEvent mouseEvent, int n, int n2) {
        if (this.isEnabled() && this.isInteracting()) {
            this._mousePressed = false;
            boolean bl = this.isArmed();
            this.setArmed(false);
            this.setInteracting(false);
            if (bl) {
                this.activate(mouseEvent.getModifiers());
            }
            return true;
        }
        return false;
    }

    protected boolean processMouseDragged(MouseEvent mouseEvent, int n, int n2) {
        if (this.isEnabled() && this.isInteracting()) {
            boolean bl = this.contains(n, n2);
            this.setArmed(bl);
            return true;
        }
        return false;
    }

    protected boolean processMouseMoved(MouseEvent mouseEvent, int n, int n2) {
        return false;
    }

    protected boolean processMouseExited(MouseEvent mouseEvent, int n, int n2) {
        return false;
    }

    protected void activate(int n) {
    }

    protected boolean isArmed() {
        return false;
    }

    protected void setArmed(boolean bl) {
    }

    protected void setInteracting(boolean bl) {
        this._interacting = bl;
    }

    protected boolean isInteracting() {
        return this._interacting;
    }

    protected void terminateInteraction() {
        this.setArmed(false);
        this.setInteracting(false);
        this._keyDown = false;
    }

    protected boolean doesKeyCausePress(KeyEvent keyEvent, boolean bl) {
        if (!bl && keyEvent.getKeyCode() == 32) {
            return true;
        }
        if (bl && !AbstractButton.hasMnemonicModifier(keyEvent)) {
            return false;
        }
        return this.eventMatchesMnemonic(keyEvent);
    }

    protected String getDefaultName() {
        return this.getBaseClassName() + _sInstanceCounter++;
    }

    boolean __clipToBorder() {
        return false;
    }

    private void _processKeyPress(KeyEvent keyEvent, boolean bl) {
        if (!keyEvent.isConsumed() && this.isEnabled()) {
            int n = keyEvent.getID();
            if (n == 401 && !this.isInteracting()) {
                if (this.doesKeyCausePress(keyEvent, bl)) {
                    keyEvent.consume();
                    this.requestFocus();
                    this.setInteracting(true);
                    this.setArmed(true);
                    this._keyDown = true;
                    this.paintImmediate();
                }
            } else if (n == 402 && this._keyDown) {
                keyEvent.consume();
                this.setInteracting(false);
                this.setArmed(false);
                this._keyDown = false;
                this.paintImmediate();
                this.activate(keyEvent.getModifiers());
            }
        }
    }

    public abstract class AccessibleAbstractButton
    extends AccessibleLWComponent
    implements AccessibleAction {
        public AccessibleAbstractButton() {
            super(AbstractButton.this);
        }

        public String getAccessibleName() {
            Object object;
            String string = super.getAccessibleName();
            if (string == null && (object = AbstractButton.this.getToolTipValue()) instanceof String) {
                string = (String)object;
            }
            return string;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (AbstractButton.this.isInteracting()) {
                accessibleStateSet.add(AccessibleState.PRESSED);
            }
            return accessibleStateSet;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 1;
        }

        public String getAccessibleActionDescription(int n) {
            if (n == 0) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(AbstractButton._RESOURCE_BUNDLE, LocaleUtils.getTranslationLocale(this.getLocale()));
                return resourceBundle.getString("CLICK");
            }
            return null;
        }

        public boolean doAccessibleAction(int n) {
            if (this.isEnabled() && n == 0) {
                AbstractButton.this.simulatePush();
                return true;
            }
            return false;
        }
    }
}

