/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.generic;

import java.awt.Color;
import java.awt.SystemColor;
import java.awt.image.ImageFilter;
import java.util.Locale;
import oracle.ewt.ColorScheme;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.laf.basic.ColorizingFilter;

class SystemColorScheme
extends ColorScheme {
    private static final int[] _LUM_VALUES = new int[]{255, 254, 223, 193, 192, 128, 127, 0};
    private static final Color[] _LUM_COLORS = new Color[]{SystemColor.window, SystemColor.controlLtHighlight, SystemColor.controlHighlight, SystemColor.scrollbar, SystemColor.control, SystemColor.controlShadow, SystemColor.textHighlight, SystemColor.controlDkShadow};
    private int[] _mappingTable;

    public String getName() {
        return "GenericSystemColor";
    }

    public String getDisplayName(Locale locale) {
        return this.getName();
    }

    public String getDescription(Locale locale) {
        return "System Color Scheme for Generic Look and Feel";
    }

    public final Color getDefiningColor() {
        return SystemColor.control;
    }

    public final ImageFilter createColorizingFilter() {
        return new ColorizingFilter(this._getColorMappingTable());
    }

    public final void initializeColors(UIDefaults uIDefaults) {
        Color color = new Color(0xFFFFE0);
        Color color2 = new Color(16773835);
        Color color3 = new Color(16439688);
        int n = 14678255;
        int n2 = 11726551;
        SystemColor systemColor = SystemColor.control;
        int n3 = systemColor.getRed();
        int n4 = systemColor.getGreen();
        int n5 = systemColor.getBlue();
        if (n3 != n4 || n4 != n5) {
            n = (n4 << 15) + 0x800000 | (n5 << 7) + 32768 | (n3 >> 1) + 128;
            n2 = (n5 << 15) + 0x800000 | (n3 << 7) + 32768 | (n4 >> 1) + 128;
        }
        Color color4 = new Color(SystemColor.textHighlight.getRGB() ^ 0xFFFFFF);
        Color color5 = new Color(0x848284);
        Object[] objectArray = new Object[]{LookAndFeel.DESKTOP, color5, LookAndFeel.ACTIVE_CAPTION, SystemColor.activeCaption, LookAndFeel.ACTIVE_CAPTION_TEXT, SystemColor.activeCaptionText, LookAndFeel.ACTIVE_CAPTION_BORDER, SystemColor.activeCaptionBorder, LookAndFeel.INACTIVE_CAPTION, SystemColor.inactiveCaption, LookAndFeel.INACTIVE_CAPTION_TEXT, SystemColor.inactiveCaptionText, LookAndFeel.INACTIVE_CAPTION_BORDER, SystemColor.inactiveCaptionBorder, LookAndFeel.DIALOG, systemColor, LookAndFeel.WINDOW, SystemColor.window, LookAndFeel.WINDOW_BORDER, SystemColor.windowBorder, LookAndFeel.WINDOW_TEXT, SystemColor.windowText, LookAndFeel.MENU, SystemColor.menu, LookAndFeel.MENU_TEXT, SystemColor.menuText, LookAndFeel.TEXT_TEXT, SystemColor.textText, LookAndFeel.TEXT_HIGHLIGHT, SystemColor.textHighlight, LookAndFeel.TEXT_HIGHLIGHT_TEXT, SystemColor.textHighlightText, LookAndFeel.TEXT_INACTIVE_TEXT, SystemColor.textInactiveText, LookAndFeel.CONTROL, systemColor, LookAndFeel.CONTROL_TEXT, SystemColor.controlText, LookAndFeel.CONTROL_HIGHLIGHT, SystemColor.controlHighlight, LookAndFeel.CONTROL_LT_HIGHLIGHT, SystemColor.controlLtHighlight, LookAndFeel.CONTROL_SHADOW, SystemColor.controlShadow, LookAndFeel.CONTROL_DK_SHADOW, SystemColor.controlDkShadow, LookAndFeel.SCROLLBAR, SystemColor.scrollbar, LookAndFeel.INFO, SystemColor.info, LookAndFeel.INFO_TEXT, SystemColor.infoText, LookAndFeel.TEXT, SystemColor.text, LookAndFeel.SECONDARY_TEXT_HIGHLIGHT, SystemColor.textHighlight, LookAndFeel.TEXT_INACTIVE_HIGHLIGHT, SystemColor.controlShadow, LookAndFeel.LIGHT_INTENSITY, SystemColor.controlHighlight, LookAndFeel.NORMAL_INTENSITY, systemColor, LookAndFeel.DARK_INTENSITY, SystemColor.controlShadow, LookAndFeel.VERY_DARK_INTENSITY, SystemColor.controlDkShadow, LookAndFeel.LIGHT_LOOK, systemColor, LookAndFeel.DARK_LOOK, systemColor, LookAndFeel.VERY_DARK_LOOK, systemColor, LookAndFeel.CONTROL_INACTIVE_TEXT, SystemColor.textInactiveText, LookAndFeel.CONTROL_INACTIVE, systemColor, LookAndFeel.ARROW, systemColor, LookAndFeel.TOOL_TIP, SystemColor.info, LookAndFeel.SELECTED_FOCUS, color4, LookAndFeel.PINSTRIPE1, color2, LookAndFeel.PINSTRIPE2, color3, LookAndFeel.PINSTRIPE3, new Color(n), LookAndFeel.PINSTRIPE4, new Color(n2)};
        uIDefaults.putDefaults(objectArray);
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            uIDefaults.put(LookAndFeel.TEXT, SystemColor.window);
        }
    }

    private final int[] _getColorMappingTable() {
        if (this._mappingTable == null) {
            int[] nArray = new int[256];
            int n = 0;
            int n2 = _LUM_VALUES[0];
            for (int i = 255; i >= 0; --i) {
                if (i == n2) {
                    int n3;
                    nArray[i] = n3 = _LUM_COLORS[n].getRGB() | 0xFF000000;
                    if (++n < _LUM_VALUES.length) {
                        n2 = _LUM_VALUES[n];
                        continue;
                    }
                    n2 = -1;
                    continue;
                }
                nArray[i] = 0xFF000000 | (i << 16 | i << 8 | i);
            }
            this._mappingTable = nArray;
        }
        return this._mappingTable;
    }
}

