/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.basic;

import java.awt.Color;
import java.awt.Graphics;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.painter.AbstractBorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.util.ImmInsets;

public class DrawerBorderPainter
extends AbstractBorderPainter {
    private static final ImmInsets[] _BORDER_INSETS = new ImmInsets[]{new ImmInsets(1, 0, 1, 1), new ImmInsets(1, 1, 0, 1), new ImmInsets(0, 1, 1, 1), new ImmInsets(1, 1, 1, 0)};
    private static DrawerBorderPainter[] _sInstances = new DrawerBorderPainter[4];
    private int _orientation;

    public static DrawerBorderPainter getDrawerBorderPainter(int n) {
        DrawerBorderPainter drawerBorderPainter = _sInstances[n];
        if (drawerBorderPainter == null) {
            DrawerBorderPainter._sInstances[n] = drawerBorderPainter = new DrawerBorderPainter(n);
        }
        return drawerBorderPainter;
    }

    private DrawerBorderPainter(int n) {
        super(new FixedBorderPainter(1, 1, 1, 1));
        this._orientation = n;
    }

    protected ImmInsets getOwnInsets(PaintContext paintContext) {
        return _BORDER_INSETS[this._orientation];
    }

    protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        int n5 = n2 + n4 - 1;
        int n6 = n + n3 - 1;
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        Color color2 = uIDefaults.getColor(LookAndFeel.CONTROL_DK_SHADOW);
        switch (this._orientation) {
            case 1: {
                graphics.setColor(Color.white);
                graphics.drawLine(n, n2 + 1, n, n5);
                graphics.drawLine(n + 1, n2, n6 - 1, n2);
                graphics.setColor(color2);
                graphics.drawLine(n6, n2 + 1, n6, n5);
                break;
            }
            case 2: {
                graphics.setColor(Color.white);
                graphics.drawLine(n, n2, n, n5 - 1);
                graphics.setColor(color2);
                graphics.drawLine(n + 1, n5, n6 - 1, n5);
                graphics.drawLine(n6, n2, n6, n5 - 1);
                break;
            }
            case 3: {
                graphics.setColor(Color.white);
                graphics.drawLine(n + 1, n2, n6, n2);
                graphics.drawLine(n, n2 + 1, n, n5 - 1);
                graphics.setColor(color2);
                graphics.drawLine(n + 1, n5, n6, n5);
                break;
            }
            case 0: {
                graphics.setColor(Color.white);
                graphics.drawLine(n, n2, n6 - 1, n2);
                graphics.setColor(color2);
                graphics.drawLine(n, n5, n6 - 1, n5);
                graphics.drawLine(n6, n2 + 1, n6, n5 - 1);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        graphics.setColor(color);
    }

    protected boolean isBorderTransparent(PaintContext paintContext) {
        return true;
    }
}

