/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid;

import java.awt.event.KeyEvent;
import oracle.ewt.grid.Cell;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridKeyNavigator;

public class StandardNavigator
implements GridKeyNavigator {
    private boolean _tabAsArrow;
    private static StandardNavigator _sManager;
    private static StandardNavigator _sTabManager;

    public Cell tab(Grid grid, Cell cell, KeyEvent keyEvent, boolean bl) {
        if (keyEvent.isControlDown()) {
            return cell;
        }
        if (!this._tabAsArrow) {
            return cell;
        }
        if (bl) {
            return this.left(grid, cell, keyEvent);
        }
        return this.right(grid, cell, keyEvent);
    }

    public Cell enter(Grid grid, Cell cell, KeyEvent keyEvent, boolean bl) {
        if (bl) {
            return this.up(grid, cell, keyEvent);
        }
        return this.down(grid, cell, keyEvent);
    }

    public Cell left(Grid grid, Cell cell, KeyEvent keyEvent) {
        keyEvent.consume();
        int n = grid.getPreviousVisibleColumn(cell.column);
        if (n == -1) {
            return cell;
        }
        return new Cell(n, cell.row);
    }

    public Cell right(Grid grid, Cell cell, KeyEvent keyEvent) {
        keyEvent.consume();
        int n = cell.row;
        int n2 = grid.getNextVisibleColumn(cell.column);
        if (n2 == -1) {
            return cell;
        }
        return new Cell(n2, cell.row);
    }

    public Cell up(Grid grid, Cell cell, KeyEvent keyEvent) {
        keyEvent.consume();
        int n = grid.getPreviousVisibleRow(cell.row);
        if (n == -1) {
            return cell;
        }
        return new Cell(cell.column, n);
    }

    public Cell down(Grid grid, Cell cell, KeyEvent keyEvent) {
        keyEvent.consume();
        int n = grid.getNextVisibleRow(cell.row);
        if (n == -1) {
            return cell;
        }
        return new Cell(cell.column, n);
    }

    public Cell pageUp(Grid grid, Cell cell, KeyEvent keyEvent) {
        keyEvent.consume();
        if (cell.row == 0) {
            return cell;
        }
        int n = cell.row;
        for (int i = grid.getOnScreenRowCount(); i != 0; --i) {
            int n2 = n;
            if ((n = grid.getPreviousVisibleRow(n2)) != -1) continue;
            n = n2;
            break;
        }
        return new Cell(cell.column, n);
    }

    public Cell pageDown(Grid grid, Cell cell, KeyEvent keyEvent) {
        keyEvent.consume();
        int n = grid.getRowCount();
        if (cell.row == n - 1) {
            return cell;
        }
        int n2 = cell.row;
        for (int i = grid.getOnScreenRowCount(); i != 0; --i) {
            int n3 = n2;
            if ((n2 = grid.getNextVisibleRow(n3)) != -1) continue;
            n2 = n3;
            break;
        }
        return new Cell(cell.column, n2);
    }

    public Cell home(Grid grid, Cell cell, KeyEvent keyEvent) {
        keyEvent.consume();
        int n = grid.getNextVisibleRow(-1);
        if (cell.row == n) {
            return cell;
        }
        return new Cell(cell.column, n);
    }

    public Cell end(Grid grid, Cell cell, KeyEvent keyEvent) {
        keyEvent.consume();
        int n = grid.getRowCount();
        int n2 = grid.getPreviousVisibleRow(n);
        if (cell.row == n2) {
            return cell;
        }
        return new Cell(cell.column, n2);
    }

    public static GridKeyNavigator getGridKeyNavigator() {
        if (_sManager == null) {
            _sManager = new StandardNavigator();
        }
        return _sManager;
    }

    public static GridKeyNavigator getTabKeyNavigator() {
        if (_sTabManager == null) {
            _sTabManager = new StandardNavigator(true);
        }
        return _sTabManager;
    }

    protected StandardNavigator() {
        this(false);
    }

    protected StandardNavigator(boolean bl) {
        this._tabAsArrow = bl;
    }
}

