/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid;

import java.awt.Color;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.grid.AppearanceManager;
import oracle.ewt.grid.Grid;
import oracle.ewt.plaf.GridUI;

public class RowGroupingAppearance
implements AppearanceManager {
    private Grid _grid;
    private int _rows;
    private Color _color;
    private Appearance _a1;
    private Appearance _a2;

    public RowGroupingAppearance() {
        this(new Color(255, 255, 200), 1);
    }

    public RowGroupingAppearance(Color color, int n) {
        this.setColor(color);
        this.setRows(n);
    }

    public void setColor(Color color) {
        if (this.getColor() != color) {
            this._color = color;
            if (this._a1 != null) {
                this._a1.setBackground(color);
            }
            if (this._grid != null) {
                this._grid.repaint();
            }
        }
    }

    public Color getColor() {
        return this._color;
    }

    public void setRows(int n) {
        if (this.getRows() != n) {
            this._rows = n;
            if (this._grid != null) {
                this._grid.repaint();
            }
        }
    }

    public int getRows() {
        return this._rows;
    }

    public void setParent(Grid grid) {
        this._grid = grid;
    }

    public Appearance getCellPaintingAppearance(int n, int n2) {
        int n3 = this._grid.getRowVisibleIndex(n2);
        return this._getAppearance(n3);
    }

    public void rowsAdded(int n, int n2) {
    }

    public void rowsRemoved(int n, int n2) {
    }

    public void columnsAdded(int n, int n2) {
    }

    public void columnsRemoved(int n, int n2) {
    }

    private Appearance _getAppearance(int n) {
        Appearance appearance;
        int n2 = this.getRows();
        int n3 = n % (n2 * 2);
        if (n3 < n2) {
            if (this._a1 == null) {
                this._a1 = this._createAppearance(this.getColor());
            }
            appearance = this._a1;
        } else {
            if (this._a2 == null) {
                this._a2 = this._createAppearance(this._grid.getBackground());
            }
            appearance = this._a2;
        }
        return appearance;
    }

    private Appearance _createAppearance(Color color) {
        GridUI gridUI = (GridUI)this._grid.getUI();
        Appearance appearance = gridUI.getDefaultAppearance(this._grid);
        appearance.setBackground(color);
        return appearance;
    }
}

