/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid;

import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.ArrayTwoDDataSource;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.grid.AppearanceManager;
import oracle.ewt.grid.Grid;
import oracle.ewt.plaf.GridUI;

public class ComplexAppearanceManager
implements AppearanceManager {
    private Grid _grid;
    private int _columnCount;
    private int _rowCount;
    private ArrayOneDDataSource _rows;
    private ArrayOneDDataSource _columns;
    private ArrayTwoDDataSource _cells;
    private Appearance _appearance;

    public void setParent(Grid grid) {
        this._columns = null;
        this._rows = null;
        this._cells = null;
        this._grid = grid;
        this._columnCount = grid == null ? 0 : this._grid.getColumnCount();
        this._rowCount = grid == null ? 0 : this._grid.getRowCount();
    }

    public Appearance getCellPaintingAppearance(int n, int n2) {
        Object object = null;
        if (this._cells != null) {
            object = this._cells.getData(n, n2);
        }
        if (object == null && this._columns != null) {
            object = this._columns.getData(n);
        }
        if (object == null && this._rows != null) {
            object = this._rows.getData(n2);
        }
        if (object != null) {
            return (Appearance)object;
        }
        return this._getAppearance();
    }

    public Appearance getAppearance() {
        return this._getAppearance().copy();
    }

    public void setAppearance(Appearance appearance) {
        this._appearance = appearance.copy();
    }

    public Appearance getColumnAppearance(int n) {
        Object object;
        if (this._columns != null && (object = this._columns.getData(n)) != null) {
            return ((Appearance)object).copy();
        }
        return this.getAppearance();
    }

    public void setColumnAppearance(int n, Appearance appearance) {
        if (this._columns == null) {
            this._columns = new ArrayOneDDataSource(this._columnCount);
        }
        if (appearance != null) {
            appearance = appearance.copy();
        }
        this._columns.setData(n, appearance);
    }

    public Appearance getRowAppearance(int n) {
        Object object;
        if (this._rows != null && (object = this._rows.getData(n)) != null) {
            return ((Appearance)object).copy();
        }
        return this.getAppearance();
    }

    public void setRowAppearance(int n, Appearance appearance) {
        if (this._rows == null) {
            this._rows = new ArrayOneDDataSource(this._rowCount);
        }
        if (appearance != null) {
            appearance = appearance.copy();
        }
        this._rows.setData(n, appearance);
    }

    public Appearance getCellAppearance(int n, int n2) {
        Appearance appearance = this.getCellPaintingAppearance(n, n2);
        if (appearance != null) {
            appearance = appearance.copy();
        }
        return appearance;
    }

    public void setCellAppearance(int n, int n2, Appearance appearance) {
        if (this._cells == null) {
            this._cells = new ArrayTwoDDataSource(this._columnCount, this._rowCount);
        }
        if (appearance != null) {
            appearance = appearance.copy();
        }
        this._cells.setData(n, n2, appearance);
    }

    public void rowsAdded(int n, int n2) {
        if (this._rows != null) {
            this._rows.addItems(n, n2);
        }
        if (this._cells != null) {
            this._cells.addRows(n, n2);
        }
        this._rowCount += n2;
    }

    public void rowsRemoved(int n, int n2) {
        if (this._rows != null) {
            this._rows.removeItems(n, n2);
        }
        if (this._cells != null) {
            this._cells.removeRows(n, n2);
        }
        this._rowCount -= n2;
    }

    public void columnsAdded(int n, int n2) {
        if (this._columns != null) {
            this._columns.addItems(n, n2);
        }
        if (this._cells != null) {
            this._cells.addColumns(n, n2);
        }
        this._columnCount += n2;
    }

    public void columnsRemoved(int n, int n2) {
        if (this._columns != null) {
            this._columns.removeItems(n, n2);
        }
        if (this._cells != null) {
            this._cells.removeColumns(n, n2);
        }
        this._columnCount -= n2;
    }

    private Appearance _getAppearance() {
        if (this._appearance == null) {
            this._appearance = this._createAppearance();
        }
        return this._appearance;
    }

    private Appearance _createAppearance() {
        GridUI gridUI = (GridUI)this._grid.getUI();
        return gridUI.getDefaultAppearance(this._grid);
    }
}

