/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dialog.directory;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.bali.share.nls.StringUtils;
import oracle.ewt.EwtComponent;
import oracle.ewt.button.ButtonBar;
import oracle.ewt.button.PushButton;
import oracle.ewt.dialog.directory.DirectoryDrive;
import oracle.ewt.dialog.directory.DirectoryTree;
import oracle.ewt.dialog.directory.DriveChangeListener;
import oracle.ewt.dialog.directory.FieldSyncListener;
import oracle.ewt.dialog.directory.OKListener;
import oracle.ewt.dialog.directory.RootChangeListener;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.WindowUtils;

public class DirectoryDialog
extends BufferedDialog {
    private File _directory;
    private DirectoryDrive[] _drives;
    private Component _centerOver;
    private String _message;
    private MultiLineLabel _messageLabel;
    private PushButton _okButton;
    private PushButton _cancelButton;
    private DirectoryTree _dirTree;
    private LWTextField _dirField;
    private LWLabel _dirLabel;
    private LWChoice _driveChoice;
    private LWLabel _driveLabel;
    private EwtComponent _drivePane;
    private boolean _defaultTitle;
    private boolean _createAllowed;
    private ResourceBundle _messageBundle;
    private static final String _CANCEL_KEY = "CANCEL";
    private static final String _OK_KEY = "OK";
    private static final String _TITLE_KEY = "TITLE";
    private static final String _MESSAGE_KEY = "MESSAGE";
    private static final String _DRIVES_KEY = "DRIVES";
    private static final String _DIRECTORY_KEY = "DIRECTORY";
    private static final int _MARGIN = 10;

    public DirectoryDialog(Frame frame) {
        this(frame, null);
    }

    public DirectoryDialog(Frame frame, String string) {
        super(frame, string, true);
        if (string == null) {
            this._defaultTitle = true;
        }
        this.addWindowListener(new Closer());
    }

    public boolean isCreateAllowed() {
        return this._createAllowed;
    }

    public Component getCenterOver() {
        return this._centerOver;
    }

    public DirectoryDrive[] getDrives() {
        DirectoryDrive[] directoryDriveArray = null;
        if (this._drives != null) {
            directoryDriveArray = new DirectoryDrive[this._drives.length];
            System.arraycopy(this._drives, 0, directoryDriveArray, 0, this._drives.length);
        }
        return directoryDriveArray;
    }

    public String getMessage() {
        if (this._message == null && this._messageLabel != null) {
            return this._messageLabel.getText();
        }
        return this._message;
    }

    public File runDialog(File file) {
        int n;
        if (this._dirTree == null) {
            this._createComponents();
        }
        if ((n = this._dirTree.setDirectory(file, false)) != 0 && n != 4) {
            String string = System.getProperty("user.dir");
            n = this._dirTree.setDirectory(new File(string), false);
        }
        if (n != 0) {
            this._dirField.setText(file.getPath());
        }
        this.pack();
        WindowUtils.centerWindow(this, this._centerOver);
        this._dirTree.requestFocus();
        this._dirTree.setCanvasOrigin(0, 0);
        this._dirTree.makeVisible(this._dirTree.getFocusedItem());
        int n2 = this._dirField.getCaretPosition();
        this._dirField.setCaretPosition(0);
        this._dirField.setCaretPosition(n2);
        this.setVisible(true);
        this._dirTree.setRoot(null);
        this._messageBundle = null;
        return this._directory;
    }

    public void setCreateAllowed(boolean bl) {
        this._createAllowed = bl;
    }

    public void setCenterOver(Component component) {
        this._centerOver = component;
    }

    public void setMessage(String string) {
        this._message = string;
        if (this._dirTree != null) {
            this._dirTree.setAccessibleName(string);
        }
        if (this._messageLabel != null) {
            this._messageLabel.setText(string);
        }
    }

    public void setDrives(DirectoryDrive[] directoryDriveArray) {
        if (directoryDriveArray == null) {
            this._drives = null;
        } else {
            this._drives = new DirectoryDrive[directoryDriveArray.length];
            System.arraycopy(directoryDriveArray, 0, this._drives, 0, directoryDriveArray.length);
        }
        this._updateDriveChoice();
    }

    public void setTitle(String string) {
        super.setTitle(string);
        this._defaultTitle = false;
    }

    protected boolean isDirectoryBrowsable(File file) {
        return true;
    }

    protected void updateLocale(Locale locale, Locale locale2) {
        this._loadMessages(locale);
        super.updateLocale(locale, locale2);
    }

    void _dismiss(File file) {
        this._directory = file;
        this.setVisible(false);
    }

    String _getCancelMessage() {
        return this._messageBundle.getString(_CANCEL_KEY);
    }

    String _getMessage(String string) {
        return this._messageBundle.getString(string);
    }

    String _getOKMessage() {
        return this._messageBundle.getString(_OK_KEY);
    }

    private void _addComponents(Component component) {
        EwtComponent ewtComponent = new EwtComponent();
        ewtComponent.setLayout(new BorderLayout());
        EwtComponent ewtComponent2 = new EwtComponent();
        ewtComponent2.setLayout(new BorderLayout());
        ewtComponent2.setBorderPainter(new FixedBorderPainter(0, 0, 10, 0));
        EwtComponent ewtComponent3 = new EwtComponent();
        ewtComponent3.setLayout(new BorderLayout());
        ewtComponent3.add((Component)this._dirLabel, "West");
        ewtComponent3.add((Component)this._dirField, "Center");
        ewtComponent2.add(component, "Center");
        ewtComponent.add((Component)ewtComponent2, "Center");
        ewtComponent.add((Component)ewtComponent3, "South");
        ewtComponent.setBorderPainter(new FixedBorderPainter(5, 0, 10, 0));
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.add(this._okButton);
        buttonBar.add(this._cancelButton);
        EwtComponent ewtComponent4 = new EwtComponent();
        ewtComponent4.setLayout(new BorderLayout());
        this._drivePane = new EwtComponent();
        this._drivePane.setLayout(new BorderLayout());
        this._drivePane.add((Component)this._driveLabel, "West");
        this._drivePane.add((Component)this._driveChoice, "Center");
        this._drivePane.setBorderPainter(new FixedBorderPainter(5, 0, 5, 0));
        this._messageLabel.setBorderPainter(new FixedBorderPainter(0, 0, 5, 0));
        ewtComponent4.add((Component)this._messageLabel, "North");
        ewtComponent4.add((Component)this._drivePane, "South");
        EwtComponent ewtComponent5 = new EwtComponent();
        ewtComponent5.setLayout(new BorderLayout());
        ewtComponent5.setBorderPainter(new FixedBorderPainter(10, 10, 10, 10));
        ewtComponent5.add((Component)ewtComponent4, "North");
        ewtComponent5.add((Component)ewtComponent, "Center");
        ewtComponent5.add((Component)buttonBar, "South");
        this.add((Component)ewtComponent5, "Center");
    }

    private void _createComponents() {
        this._messageLabel = new MultiLineLabel();
        this._messageLabel.setTextWrapper(WordWrapper.getTextWrapper());
        this._messageLabel.setPreferredAspectRatio(8.0f);
        this._okButton = new PushButton("");
        this._cancelButton = new CancelButton("");
        this._dirField = new LWTextField();
        this._dirLabel = new LWLabel();
        this._dirLabel.setLabelFor(this._dirField);
        this._dirTree = new DirectoryTree(this);
        this._dirTree.setPreferredItemsOnScreen(13);
        this._dirTree.setPreferredLevelsOnScreen(10);
        ScrollBox scrollBox = new ScrollBox(this._dirTree, 0, 0);
        this._driveChoice = new LWChoice();
        this._driveLabel = new LWLabel();
        this._driveLabel.setLabelFor(this._driveChoice);
        this._okButton.addActionListener(new OKListener(this, this._dirTree, this._dirField));
        this._cancelButton.addActionListener(new Closer());
        FieldSyncListener fieldSyncListener = new FieldSyncListener(this._dirField);
        this._dirTree.addSelectionListener(fieldSyncListener);
        this._dirTree.addPropertyChangeListener(new RootChangeListener(this, this._driveChoice));
        this._driveChoice.addItemListener(new DriveChangeListener(this, this._dirTree));
        this._okButton.setDefault(true);
        this._loadMessages(this.getLocale());
        this._addComponents(scrollBox);
        this._updateDriveChoice();
    }

    private void _loadMessages(Locale locale) {
        String string;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this._messageBundle = ResourceBundle.getBundle("oracle.ewt.dialog.directory.resource.DirectoryDialogBundle", LocaleUtils.getTranslationLocale(locale));
        if (this._okButton != null) {
            this._okButton.setLabel(this._messageBundle.getString(_OK_KEY));
        }
        if (this._cancelButton != null) {
            this._cancelButton.setLabel(this._messageBundle.getString(_CANCEL_KEY));
        }
        if (this._messageLabel != null) {
            if (this._message == null) {
                this._messageLabel.setText(this._messageBundle.getString(_MESSAGE_KEY));
            } else {
                this._messageLabel.setText(this._message);
            }
        }
        if (this._driveLabel != null) {
            string = this._messageBundle.getString(_DRIVES_KEY);
            this._driveLabel.setText(StringUtils.stripMnemonic((String)string));
            this._driveLabel.setMnemonicIndex(StringUtils.getMnemonicIndex((String)string));
        }
        if (this._dirLabel != null) {
            string = this._messageBundle.getString(_DIRECTORY_KEY);
            this._dirLabel.setText(StringUtils.stripMnemonic((String)string));
            this._dirLabel.setMnemonicIndex(StringUtils.getMnemonicIndex((String)string));
        }
        if (this._defaultTitle) {
            super.setTitle(this._messageBundle.getString(_TITLE_KEY));
        }
    }

    private void _updateDriveChoice() {
        if (this._drivePane == null) {
            return;
        }
        if (this._drives == null || this._drives.length == 0) {
            this._drivePane.setVisible(false);
            this._driveChoice.removeAll();
        } else {
            this._driveChoice.removeAll();
            for (int i = 0; i < this._drives.length; ++i) {
                DirectoryDrive directoryDrive = this._drives[i];
                String string = directoryDrive.getPath();
                String string2 = directoryDrive.getLabel();
                String string3 = null;
                string3 = string2 == null || string2.equals("") ? "(" + string + ")" : string2 + " (" + string + ")";
                this._driveChoice.add(string3);
            }
            this._drivePane.setVisible(true);
        }
    }

    private class CancelButton
    extends PushButton {
        public CancelButton(String string) {
            super(string);
        }

        protected boolean doesKeyCausePress(KeyEvent keyEvent, boolean bl) {
            return super.doesKeyCausePress(keyEvent, bl) || keyEvent.getKeyCode() == 27;
        }
    }

    private class Closer
    extends WindowAdapter
    implements ActionListener {
        private Closer() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DirectoryDialog.this._dismiss(null);
        }

        public void windowClosing(WindowEvent windowEvent) {
            DirectoryDialog.this._dismiss(null);
        }
    }
}

