/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dTree;

import java.util.Enumeration;
import oracle.ewt.dTree.OneDSparseArrayBlock;

class OneDSparseArray {
    public static final int INDEX_NONE = -1;
    private OneDSparseArrayBlock[] _blocks;
    private int _nblocks;
    private int _defblocklen;
    private int _maxblocklen;

    public OneDSparseArray() {
        this(100, 1000);
    }

    public OneDSparseArray(int n, int n2) {
        this._defblocklen = n;
        this._maxblocklen = n2;
    }

    public int getDefaultBlockLength() {
        return this._defblocklen;
    }

    public synchronized Object getElement(int n) {
        for (int i = 0; i < this._nblocks; ++i) {
            OneDSparseArrayBlock oneDSparseArrayBlock = this._blocks[i];
            int n2 = oneDSparseArrayBlock.getStartIndex();
            if (n < n2) {
                return null;
            }
            if (n >= n2 + oneDSparseArrayBlock.getLength()) continue;
            return oneDSparseArrayBlock.getElement(n - n2);
        }
        return null;
    }

    public Enumeration getEnumeration() {
        return null;
    }

    public synchronized int getFirstIndex() {
        for (int i = 0; i < this._nblocks; ++i) {
            OneDSparseArrayBlock oneDSparseArrayBlock = this._blocks[i];
            int n = oneDSparseArrayBlock.getLength();
            for (int j = 0; j < n; ++j) {
                Object object = oneDSparseArrayBlock.getElement(j);
                if (object == null) continue;
                return oneDSparseArrayBlock.getStartIndex() + j;
            }
        }
        return -1;
    }

    public synchronized int getLastIndex() {
        for (int i = this._nblocks - 1; i >= 0; --i) {
            OneDSparseArrayBlock oneDSparseArrayBlock = this._blocks[i];
            int n = oneDSparseArrayBlock.getLength();
            for (int j = n - 1; j >= 0; --j) {
                Object object = oneDSparseArrayBlock.getElement(j);
                if (object == null) continue;
                return oneDSparseArrayBlock.getStartIndex() + j;
            }
        }
        return -1;
    }

    public synchronized int getNextIndex(int n) {
        for (int i = 0; i < this._nblocks; ++i) {
            int n2;
            OneDSparseArrayBlock oneDSparseArrayBlock = this._blocks[i];
            int n3 = oneDSparseArrayBlock.getStartIndex();
            if (n >= n3 + (n2 = oneDSparseArrayBlock.getLength())) continue;
            int n4 = 0;
            if (n >= n3) {
                n4 = n - n3 + 1;
            }
            while (n4 < n2) {
                Object object = oneDSparseArrayBlock.getElement(n4);
                if (object != null) {
                    return n3 + n4;
                }
                ++n4;
            }
        }
        return -1;
    }

    public int getMaximumBlockLength() {
        return this._maxblocklen;
    }

    public void insertElement(Object object, int n) {
    }

    public synchronized void insertElements(int n, int n2) {
        OneDSparseArrayBlock oneDSparseArrayBlock;
        int n3;
        for (n3 = 0; n3 < this._nblocks; ++n3) {
            oneDSparseArrayBlock = this._blocks[n3];
            int n4 = oneDSparseArrayBlock.getStartIndex();
            int n5 = oneDSparseArrayBlock.getLength();
            if (n < n4) break;
            if (n >= n4 + n5) continue;
            if (n == n4) break;
            this._splitBlock(n3, n);
            ++n3;
            break;
        }
        while (n3 < this._nblocks) {
            oneDSparseArrayBlock = this._blocks[n3];
            oneDSparseArrayBlock.setStartIndex(oneDSparseArrayBlock.getStartIndex() + n2);
            ++n3;
        }
    }

    public void insertElements(Object[] objectArray, int n, int n2) {
    }

    public boolean isEmpty() {
        return this.getFirstIndex() == -1;
    }

    public synchronized void removeAll() {
        this._blocks = null;
        this._nblocks = 0;
    }

    public synchronized void removeElements(int n, int n2) {
        int n3 = 0;
        while (n3 < this._nblocks) {
            int n4;
            OneDSparseArrayBlock oneDSparseArrayBlock = this._blocks[n3];
            int n5 = oneDSparseArrayBlock.getStartIndex();
            if (n < n5 + (n4 = oneDSparseArrayBlock.getLength())) {
                if (n + n2 < n5) {
                    oneDSparseArrayBlock.setStartIndex(oneDSparseArrayBlock.getStartIndex() - n2);
                } else {
                    if (n <= n5 && n + n2 >= n5 + n4) {
                        this._removeBlock(n3);
                        continue;
                    }
                    this._removeElements(n3, n, n2);
                }
            }
            ++n3;
        }
    }

    public void setDefaultBlockLength(int n) {
        this._defblocklen = n;
    }

    public synchronized void setElement(Object object, int n) {
        OneDSparseArrayBlock oneDSparseArrayBlock;
        int n2;
        int n3;
        for (n3 = 0; n3 < this._nblocks && n >= (n2 = (oneDSparseArrayBlock = this._blocks[n3]).getStartIndex()); ++n3) {
            if (n >= n2 + oneDSparseArrayBlock.getLength()) continue;
            oneDSparseArrayBlock.setElement(n - n2, object);
            return;
        }
        this._setElement(object, n, n3);
    }

    public void setElements(Object[] objectArray, int n, int n2) {
    }

    public void setMaximumBlockLength(int n) {
        this._maxblocklen = n;
    }

    private void _setElement(Object object, int n, int n2) {
        int n3;
        int n4;
        boolean bl = false;
        boolean bl2 = false;
        OneDSparseArrayBlock oneDSparseArrayBlock = null;
        OneDSparseArrayBlock oneDSparseArrayBlock2 = null;
        if (n2 > 0) {
            oneDSparseArrayBlock = this._blocks[n2 - 1];
            n4 = oneDSparseArrayBlock.getLength();
            n3 = oneDSparseArrayBlock.getStartIndex();
            if (n - (n3 + n4) < this.getDefaultBlockLength() && n4 + this.getDefaultBlockLength() < this.getMaximumBlockLength()) {
                bl = true;
            }
        }
        if (n2 < this._nblocks) {
            oneDSparseArrayBlock2 = this._blocks[n2];
            n4 = oneDSparseArrayBlock2.getLength();
            n3 = oneDSparseArrayBlock2.getStartIndex();
            if (n3 - n <= this.getDefaultBlockLength() && n4 + this.getDefaultBlockLength() < this.getMaximumBlockLength()) {
                bl2 = true;
            }
        }
        if (bl && bl2) {
            if (oneDSparseArrayBlock.getLength() < oneDSparseArrayBlock2.getLength()) {
                this._extendPreviousBlock(object, n, n2 - 1);
            } else {
                this._extendNextBlock(object, n, n2);
            }
        } else if (bl) {
            this._extendPreviousBlock(object, n, n2 - 1);
        } else if (bl2) {
            this._extendNextBlock(object, n, n2);
        } else {
            this._createNewBlock(object, n, n2);
        }
    }

    private void _createNewBlock(Object object, int n, int n2) {
        OneDSparseArrayBlock oneDSparseArrayBlock = new OneDSparseArrayBlock(n, this.getDefaultBlockLength());
        oneDSparseArrayBlock.setElement(0, object);
        if (this._blocks == null) {
            this._blocks = new OneDSparseArrayBlock[1];
        }
        if (this._nblocks == this._blocks.length) {
            OneDSparseArrayBlock[] oneDSparseArrayBlockArray = new OneDSparseArrayBlock[this._nblocks * 2];
            System.arraycopy(this._blocks, 0, oneDSparseArrayBlockArray, 0, this._nblocks);
            this._blocks = oneDSparseArrayBlockArray;
        }
        System.arraycopy(this._blocks, n2, this._blocks, n2 + 1, this._nblocks - n2);
        this._blocks[n2] = oneDSparseArrayBlock;
        ++this._nblocks;
    }

    private void _extendNextBlock(Object object, int n, int n2) {
        int n3;
        OneDSparseArrayBlock oneDSparseArrayBlock;
        int n4;
        OneDSparseArrayBlock oneDSparseArrayBlock2 = this._blocks[n2];
        int n5 = oneDSparseArrayBlock2.getStartIndex();
        int n6 = n5 - this.getDefaultBlockLength();
        if (n6 < 0) {
            n6 = 0;
        }
        if (n2 > 0 && n6 < (n4 = (oneDSparseArrayBlock = this._blocks[n2 - 1]).getStartIndex()) + (n3 = oneDSparseArrayBlock.getLength())) {
            n6 = n4 + n3;
        }
        int n7 = oneDSparseArrayBlock2.getLength() + (n5 - n6);
        Object[] objectArray = oneDSparseArrayBlock2.getElements();
        Object[] objectArray2 = new Object[n7];
        System.arraycopy(objectArray, 0, objectArray2, n5 - n6, objectArray.length);
        OneDSparseArrayBlock oneDSparseArrayBlock3 = new OneDSparseArrayBlock(n6, objectArray2, objectArray2.length);
        oneDSparseArrayBlock3.setElement(n - n6, object);
        this._blocks[n2] = oneDSparseArrayBlock3;
    }

    private void _extendPreviousBlock(Object object, int n, int n2) {
        OneDSparseArrayBlock oneDSparseArrayBlock;
        int n3;
        OneDSparseArrayBlock oneDSparseArrayBlock2 = this._blocks[n2];
        int n4 = oneDSparseArrayBlock2.getStartIndex();
        int n5 = oneDSparseArrayBlock2.getLength();
        int n6 = n5 + this.getDefaultBlockLength();
        if (n2 < this._nblocks - 1 && n4 + n6 > (n3 = (oneDSparseArrayBlock = this._blocks[n2 + 1]).getStartIndex())) {
            n6 = n3 - n4;
        }
        oneDSparseArrayBlock2.setLength(n6);
        oneDSparseArrayBlock2.setElement(n - n4, object);
    }

    private void _removeBlock(int n) {
        System.arraycopy(this._blocks, n + 1, this._blocks, n, this._nblocks - (n + 1));
        this._blocks[this._nblocks - 1] = null;
        --this._nblocks;
    }

    private void _removeElements(int n, int n2, int n3) {
        OneDSparseArrayBlock oneDSparseArrayBlock = this._blocks[n];
        int n4 = oneDSparseArrayBlock.getStartIndex();
        int n5 = oneDSparseArrayBlock.getLength();
        int n6 = n4 + n5;
        int n7 = n2 + n3;
        int n8 = n4;
        int n9 = 0;
        if (n2 <= n4) {
            n8 = n2;
            n9 = n6 - n7;
        } else {
            n9 = n7 > n6 ? n2 - n4 : n5 - n3;
        }
        Object[] objectArray = oneDSparseArrayBlock.getElements();
        Object[] objectArray2 = new Object[n9];
        if (n2 > n4) {
            System.arraycopy(objectArray, 0, objectArray2, 0, n2 - n4);
        }
        if (n7 < n6) {
            System.arraycopy(objectArray, n7 - n4, objectArray2, n2 - n8, n6 - n7);
        }
        this._blocks[n] = new OneDSparseArrayBlock(n8, objectArray2, n9);
    }

    private void _splitBlock(int n, int n2) {
        OneDSparseArrayBlock oneDSparseArrayBlock;
        OneDSparseArrayBlock oneDSparseArrayBlock2 = this._blocks[n];
        int n3 = oneDSparseArrayBlock2.getStartIndex();
        int n4 = oneDSparseArrayBlock2.getLength();
        Object[] objectArray = oneDSparseArrayBlock2.getElements();
        int n5 = n2 - n3;
        Object[] objectArray2 = new Object[n5];
        System.arraycopy(objectArray, 0, objectArray2, 0, n5);
        this._blocks[n] = oneDSparseArrayBlock = new OneDSparseArrayBlock(n3, objectArray2, n5);
        n5 = n4 - n5;
        objectArray2 = new Object[n5];
        System.arraycopy(objectArray, n2 - n3, objectArray2, 0, n5);
        oneDSparseArrayBlock = new OneDSparseArrayBlock(n2, objectArray2, n5);
        if (this._nblocks == this._blocks.length) {
            OneDSparseArrayBlock[] oneDSparseArrayBlockArray = new OneDSparseArrayBlock[this._nblocks * 2];
            System.arraycopy(this._blocks, 0, oneDSparseArrayBlockArray, 0, this._nblocks);
            this._blocks = oneDSparseArrayBlockArray;
        }
        System.arraycopy(this._blocks, n, this._blocks, n + 1, this._nblocks - n);
        this._blocks[n + 1] = oneDSparseArrayBlock;
        ++this._nblocks;
    }
}

