/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dTree;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeBaseItem;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.popup.MLLabelToolTip;
import oracle.ewt.popup.ToolTipClient;
import oracle.ewt.popup.ToolTipSite;

public class DTreeToolTipClient
implements ToolTipClient {
    private static final ToolTipClient _sToolTipClient = new DTreeToolTipClient();
    private static final int[] _ALIGNMENTS = new int[]{2, 1, 5, 6, 12, 10, 11, 12};

    public static ToolTipClient getToolTipClient() {
        return _sToolTipClient;
    }

    public ToolTipSite getToolTipSite(Component component, int n, int n2) {
        if (!(component instanceof DTree)) {
            return null;
        }
        DTree dTree = (DTree)component;
        Point point = dTree.convertOuterToCanvas(n, n2);
        DTreeItem dTreeItem = dTree.getItemAt(point.x, point.y);
        if (dTreeItem != null && this.shouldDisplay(dTree, dTreeItem)) {
            Dimension dimension = dTreeItem.getSize();
            Point point2 = dTree.convertCanvasToOuter(dTreeItem.getX(), dTreeItem.getY());
            return new ToolTipSite(this.getToolTipValue(dTreeItem), new Rectangle(point2.x, point2.y, dimension.width, dimension.height), _ALIGNMENTS, MLLabelToolTip.getToolTip());
        }
        return null;
    }

    protected Object getToolTipValue(DTreeItem dTreeItem) {
        if (dTreeItem instanceof DTreeBaseItem) {
            return ((DTreeBaseItem)dTreeItem).getLabel();
        }
        return null;
    }

    protected boolean shouldDisplay(DTree dTree, DTreeItem dTreeItem) {
        Dimension dimension = dTreeItem.getSize();
        Rectangle rectangle = new Rectangle(dTreeItem.getX(), dTreeItem.getY(), dimension.width, dimension.height);
        Rectangle rectangle2 = new Rectangle(rectangle);
        dTree.clipCanvasToParents(rectangle2);
        return !rectangle2.equals(rectangle);
    }

    protected DTreeToolTipClient() {
    }
}

