/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dTree;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeDecoration;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.graphics.ImageUtils;
import oracle.ewt.graphics.SynthesizingImageSet;
import oracle.ewt.painter.FGBGColorChange;
import oracle.ewt.painter.FilledRectPainter;
import oracle.ewt.painter.ImageSetPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.PainterStacker;
import oracle.ewt.plaf.TreeUI;
import oracle.ewt.util.ImmInsets;
import oracle.ewt.util.InputEventUtils;

public class DTreeButtonDecoration
implements DTreeDecoration,
ImageObserver {
    private Image _expandedImage;
    private Image _collapsedImage;
    private Painter _expandedPainter;
    private Painter _collapsedPainter;

    public ImmInsets getDecorationInsets(DTree dTree) {
        return new ImmInsets(0, dTree.getIndentWidth(), 0, 0);
    }

    public final Image getCollapsedImage() {
        return this._collapsedImage;
    }

    public Painter getCollapsedPainter() {
        return this._collapsedPainter;
    }

    public final Image getExpandedImage() {
        return this._expandedImage;
    }

    public Painter getExpandedPainter() {
        return this._expandedPainter;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0xA0) == 0;
    }

    public void processMouseEvent(MouseEvent mouseEvent, DTreeItem dTreeItem) {
        if (mouseEvent.getID() == 501 && InputEventUtils.isLeftMouseButton(mouseEvent) && dTreeItem.isExpandable()) {
            DTree dTree = dTreeItem.getTree();
            int n = dTreeItem.getX();
            int n2 = dTree.getIndentWidth();
            int n3 = mouseEvent.getX();
            boolean bl = false;
            if (dTree.getActualReadingDirection() == 2) {
                Dimension dimension = dTreeItem.getSize();
                if (n3 > n + dimension.width && n3 < n + dimension.width + n2) {
                    bl = true;
                }
            } else if (n3 > n - n2 && n3 < n) {
                bl = true;
            }
            if (bl) {
                dTreeItem.setExpanded(!dTreeItem.isExpanded());
                mouseEvent.consume();
            }
        }
    }

    public void paintDecoration(PaintContext paintContext, Graphics graphics, DTreeItem dTreeItem, int n, int n2) {
        if (this.getHasButton(dTreeItem)) {
            int n3;
            Object object;
            Painter painter;
            DTree dTree = dTreeItem.getTree();
            Painter painter2 = painter = dTreeItem.isExpanded() ? this.getExpandedPainter() : this.getCollapsedPainter();
            if (painter == null) {
                object = (TreeUI)dTree.getUI();
                painter = object.getExpansionButtonPainter(dTree, dTreeItem);
            }
            object = painter.getMinimumSize(paintContext);
            int n4 = dTree.getIndentWidth();
            int n5 = (n2 - ((Dimension)object).height) / 2;
            if (dTree.getActualReadingDirection() == 2) {
                Dimension dimension = dTree.getCanvasSize();
                n3 = dimension.width - n + (n4 - ((Dimension)object).width) / 2;
            } else {
                n3 = n - n4 + (n4 - ((Dimension)object).width) / 2;
            }
            if ((n4 - ((Dimension)object).width) % 2 == 1) {
                ++n3;
            }
            painter.paint(paintContext, graphics, n3, n5, ((Dimension)object).width, ((Dimension)object).height);
        }
    }

    public final void setCollapsedImage(Image image) {
        if (image != null) {
            ImageUtils.loadImage(image);
        }
        this._collapsedImage = image;
        this.setCollapsedPainter(this._createImagePainter(image));
    }

    public void setCollapsedPainter(Painter painter) {
        this._collapsedPainter = painter;
    }

    public final void setExpandedImage(Image image) {
        if (image != null) {
            ImageUtils.loadImage(image);
        }
        this._expandedImage = image;
        this.setExpandedPainter(this._createImagePainter(image));
    }

    public void setExpandedPainter(Painter painter) {
        this._expandedPainter = painter;
    }

    protected boolean getHasButton(DTreeItem dTreeItem) {
        return dTreeItem.isExpandable();
    }

    private Painter _createImagePainter(Image image) {
        return new PainterStacker(new FGBGColorChange(FilledRectPainter.getPainter(), false), new ImageSetPainter(new SynthesizingImageSet(image, 1)));
    }
}

