/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.button;

public class SpinAccelerator {
    private int _series = 0;
    private int _index = 0;
    private int[] _intervals;
    private int[] _counts;
    private int[] _increments;
    private static final int _DEFAULT_INTERVAL = 100;

    public SpinAccelerator() {
        this(100);
    }

    public SpinAccelerator(int n) {
        this._intervals = new int[1];
        this._intervals[0] = n;
    }

    public SpinAccelerator(int n, int n2, int n3, int n4) {
        int[] nArray = new int[]{n, n2};
        this._intervals = nArray;
        this._counts = new int[1];
        this._counts[0] = n3;
        if (n4 == 1) {
            this._increments = null;
        } else {
            int[] nArray2 = new int[]{1, n4};
            this._increments = nArray2;
        }
    }

    public SpinAccelerator(int[] nArray, int[] nArray2, int[] nArray3) {
        if (nArray == null) {
            throw new NullPointerException();
        }
        if (nArray3 != null && nArray3.length != nArray.length) {
            throw new IllegalArgumentException();
        }
        if (nArray2 == null ? nArray3.length != 1 : nArray2.length != nArray.length - 1) {
            throw new IllegalArgumentException();
        }
        this._intervals = nArray;
        this._counts = nArray2;
        this._increments = nArray3;
    }

    public static SpinAccelerator createDefaultAccelerator(int n) {
        if (n < 10) {
            return new SpinAccelerator(200);
        }
        if (n < 60) {
            return new SpinAccelerator(200, 40, 10, 1);
        }
        int[] nArray = new int[]{200, 100, 40};
        int[] nArray2 = new int[]{10, 10};
        int[] nArray3 = new int[]{1, 1, n / 30};
        return new SpinAccelerator(nArray, nArray2, nArray3);
    }

    public void advance() {
        int n;
        if ((n = this._series++) != this._intervals.length - 1) {
            ++this._index;
            if (this._index == this._counts[n]) {
                this._index = 0;
            }
        }
    }

    public void reset() {
        this._series = 0;
        this._index = 0;
    }

    public int getInterval() {
        return this._intervals[this._series];
    }

    public int getIncrement() {
        if (this._increments == null) {
            return 1;
        }
        return this._increments[this._series];
    }
}

