/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.xmlComponent;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import oracle.bali.xml.gui.jdev.xmlComponent.AbstractXmlHeader;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderPanel;
import oracle.javatools.ui.RichHintLabel;

public class XmlHeaderOption {
    private String _headerLabel = "";
    private String _instructionalText = "";
    private boolean _displayBorder = false;
    private boolean _indent = true;
    private boolean _expanded = true;
    private boolean _collapsible = true;
    private Icon _icon = null;
    private int _leftMargin = 0;
    private int _rightMargin = 0;
    private int _topMargin = 0;
    private int _bottomMargin = 0;
    private CC _headerConstraint = new CC();
    private boolean _useMarginInset = false;
    private boolean _alignInstructionalTextWithHeaderLabel = false;

    public String getHeaderLabel() {
        return this._headerLabel;
    }

    public XmlHeaderOption setHeaderLabel(String headerLabel) {
        this._headerLabel = headerLabel;
        return this;
    }

    public String getInstructionalText() {
        return this._instructionalText;
    }

    public XmlHeaderOption setInstructionalText(String instructionalText) {
        this._instructionalText = instructionalText;
        return this;
    }

    public boolean getDisplayBorder() {
        return this._displayBorder;
    }

    public XmlHeaderOption setDisplayBorder(boolean displayBorder) {
        this._displayBorder = displayBorder;
        return this;
    }

    public boolean getIndent() {
        return this._indent;
    }

    public XmlHeaderOption setIndent(boolean indent) {
        this._indent = indent;
        return this;
    }

    public boolean getExpanded() {
        return this._expanded;
    }

    public XmlHeaderOption setExpanded(boolean expanded) {
        this._expanded = expanded;
        return this;
    }

    public boolean getCollapsible() {
        return this._collapsible;
    }

    public XmlHeaderOption setCollapsible(boolean collapsible) {
        this._collapsible = collapsible;
        return this;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public XmlHeaderOption setIcon(Icon icon) {
        this._icon = icon;
        return this;
    }

    public int getLeftMargin() {
        return this._leftMargin;
    }

    public int getRightMargin() {
        return this._rightMargin;
    }

    public int getTopMargin() {
        return this._topMargin;
    }

    public int getBottomMargin() {
        return this._bottomMargin;
    }

    public XmlHeaderOption setLeftMargin(int leftMargin) {
        this._leftMargin = leftMargin;
        return this;
    }

    public XmlHeaderOption setRightMargin(int rightMargin) {
        this._rightMargin = rightMargin;
        return this;
    }

    public XmlHeaderOption setTopMargin(int topMargin) {
        this._topMargin = topMargin;
        return this;
    }

    public XmlHeaderOption setBottomMargin(int bottomMargin) {
        this._bottomMargin = bottomMargin;
        return this;
    }

    public CC getHeaderConstraint() {
        return this._headerConstraint;
    }

    public XmlHeaderOption setHeaderConstraint(Object constraint) {
        this._headerConstraint = (CC)constraint;
        return this;
    }

    public XmlHeaderOption useMarginInset() {
        this._useMarginInset = true;
        return this;
    }

    public XmlHeaderOption useDefaultTabMargin() {
        this.setTopMargin(10);
        this.setLeftMargin(8);
        this.setBottomMargin(8);
        this.setRightMargin(8);
        this.useMarginInset();
        return this;
    }

    public boolean getAlignInstructionalTextWithHeaderLabel() {
        return this._alignInstructionalTextWithHeaderLabel;
    }

    public XmlHeaderOption setAlignInstructionalTextWithHeaderLabel(boolean alignInstructionalTextWithHeaderLabel) {
        this._alignInstructionalTextWithHeaderLabel = alignInstructionalTextWithHeaderLabel;
        return this;
    }

    public LayoutManager createHeaderLayout(AbstractXmlHeader xmlHeader) {
        String topInset = "0";
        String leftInset = "0";
        String bottomInset = "0";
        String rightInset = "0";
        if (this._useMarginInset) {
            topInset = String.valueOf(this.getTopMargin());
            leftInset = String.valueOf(this.getLeftMargin());
            bottomInset = String.valueOf(this.getBottomMargin());
            rightInset = String.valueOf(this.getRightMargin());
        }
        return new MigLayout(new LC().insets(topInset, leftInset, bottomInset, rightInset).minWidth("1px"), new AC().gap("rel"), new AC().gap(String.valueOf(6)));
    }

    public HeaderPanel buildHeaderPanel(Component component) {
        HeaderPanel headerPanel = component != null && component instanceof JPanel ? new HeaderPanel((JComponent)((JPanel)component)) : new HeaderPanel();
        if (this.getInstructionalText().length() > 0) {
            headerPanel.setStaticHelpText(this.getInstructionalText());
        }
        headerPanel.setComponentBorderPainted(this.getDisplayBorder());
        headerPanel.setComponentIndented(this.getIndent());
        Header header = headerPanel.getHeader();
        if (this.getHeaderLabel() != null) {
            header.setText(this.getHeaderLabel());
        }
        if (this.getIcon() != null) {
            header.setIcon(this.getIcon());
        }
        if (this.getCollapsible()) {
            header.setLevel(Header.Level.SUB);
        } else {
            header.setLevel(Header.Level.PAGE);
        }
        header.setExpanded(this.getExpanded());
        return headerPanel;
    }

    public JComponent buildPageHeader() {
        if (this.getAlignInstructionalTextWithHeaderLabel()) {
            return this.buildHeaderComponent();
        }
        Header headerPanel = new Header();
        headerPanel.setLevel(Header.Level.PAGE);
        headerPanel.setText(this.getHeaderLabel());
        headerPanel.setBorder(BorderFactory.createEmptyBorder());
        if (this.getIcon() != null) {
            headerPanel.setIcon(this.getIcon());
        }
        return headerPanel;
    }

    public JComponent buildHeaderComponent() {
        HeaderComponent headerComponent = new HeaderComponent();
        if (this.getInstructionalText().length() > 0) {
            headerComponent.setDescription(this.getInstructionalText());
        }
        if (this.getHeaderLabel() != null) {
            headerComponent.setTitle(this.getHeaderLabel());
        }
        if (this.getIcon() != null) {
            headerComponent.setIcon(this.getIcon());
        }
        return headerComponent;
    }

    private class HeaderComponent
    extends JComponent
    implements Accessible {
        private JLabel _headerIcon;
        private JLabel _headerTitle;
        private RichHintLabel _headerDescription;

        private HeaderComponent() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
            this._headerIcon = new JLabel();
            this._headerTitle = new JLabel();
            this._headerTitle.setFont(this._headerTitle.getFont());
            this._headerDescription = new RichHintLabel();
            this.add((Component)this._headerIcon, new GridBagConstraints(0, 0, 1, 0, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this._headerTitle, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 6, 0, 0), 0, 0));
            this.add((Component)this._headerDescription, new GridBagConstraints(1, 1, 0, 0, 1.0, 1.0, 18, 1, new Insets(6, 6, 0, 0), 0, 0));
        }

        @Override
        public void addNotify() {
            super.addNotify();
            Font f = this._headerTitle.getFont();
            if (f != null && !f.isBold()) {
                this._headerTitle.setFont(f.deriveFont(f.getStyle() ^ 1));
            }
        }

        private void setIcon(Icon icon) {
            Icon oldIcon = this.getIcon();
            if (icon != oldIcon) {
                this._headerIcon.setIcon(icon);
            }
        }

        private Icon getIcon() {
            return this._headerIcon.getIcon();
        }

        private void setTitle(String title) {
            String oldTitle = this.getTitle();
            if (title != oldTitle) {
                this._headerTitle.setText(title);
            }
        }

        private String getTitle() {
            return this._headerTitle.getText();
        }

        private void setDescription(String description) {
            String oldDescription = this.getDescription();
            if (description != oldDescription) {
                this._headerDescription.setText(description);
            }
        }

        private String getDescription() {
            return this._headerDescription.getText();
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleHeader();
            }
            return this.accessibleContext;
        }

        private class AccessibleHeader
        extends JComponent.AccessibleJComponent {
            private AccessibleHeader() {
                super(HeaderComponent.this);
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.PANEL;
            }
        }
    }
}

