/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.services;

import java.net.URL;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.bali.xml.gui.jdev.JDevTextBufferSource;
import oracle.bali.xml.model.services.VersionControlService;
import oracle.bali.xml.share.TextBufferSource;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.vcs.VCSManager;
import oracle.ide.vcs.VCSTask;
import oracle.ideimpl.vcs.VCSUtil;

public final class JDevVersionControlService
extends VersionControlService {
    private static JDevVersionControlService _sInstance = new JDevVersionControlService();
    private static Logger _sLogger = null;

    public static JDevVersionControlService getInstance() {
        return _sInstance;
    }

    public boolean supportsCheckOut(TextBufferSource source) {
        boolean supportsCheckOut = false;
        try {
            TextNode sourceNode = this.getTextNode(source);
            if (sourceNode != null) {
                URL url;
                VCSManager vcsManager = VCSManager.getVCSManager();
                supportsCheckOut = vcsManager.isAutoCheckOutEnabled(url = sourceNode.getURL()) && vcsManager.canCheckOut(url);
            }
        }
        catch (RuntimeException rE) {
            supportsCheckOut = false;
            JDevVersionControlService._getLogger().log(Level.WARNING, "Unexpected exception encountered in JDevVersionControlService", rE);
        }
        return supportsCheckOut;
    }

    public boolean performCheckOut(TextBufferSource source, boolean canModifyUndoStack) {
        boolean success = false;
        try {
            TextNode sourceNode = this.getTextNode(source);
            if (sourceNode != null) {
                success = SwingUtilities.isEventDispatchThread() ? (canModifyUndoStack ? VCSUtil.checkOutOnUndoStack((Node)sourceNode) : (Boolean)VCSManager.getVCSManager().checkOutUsingUI(new VCSTask(new URL[]{sourceNode.getURL()}){}).get()) : VCSManager.getVCSManager().checkOut(new URL[]{sourceNode.getURL()});
            }
        }
        catch (CancellationException cE) {
            success = false;
        }
        catch (InterruptedException iE) {
            success = false;
        }
        catch (ExecutionException eE) {
            success = false;
            JDevVersionControlService._getLogger().log(Level.WARNING, "Unexpected exception encountered in JDevVersionControlService", eE);
        }
        catch (RuntimeException rE) {
            success = false;
            JDevVersionControlService._getLogger().log(Level.WARNING, "Unexpected exception encountered in JDevVersionControlService", rE);
        }
        return success;
    }

    public TextNode getTextNode(TextBufferSource textBufferSource) {
        if (textBufferSource instanceof JDevTextBufferSource) {
            return ((JDevTextBufferSource)textBufferSource).getTextNode();
        }
        return null;
    }

    private static Logger _getLogger() {
        if (_sLogger == null) {
            _sLogger = Logger.getLogger(JDevVersionControlService.class.getName());
        }
        return _sLogger;
    }

    private JDevVersionControlService() {
    }
}

