/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.selection;

import java.net.URL;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.selection.XmlSelectionElement;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.task.NonDomMutationTransactionTask;
import oracle.ide.model.Element;
import oracle.ide.model.ElementRecognizer;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.util.Assert;
import org.w3c.dom.Document;

public final class XmlSelectionElementRecognizer
extends ElementRecognizer {
    private static final ElementRecognizer _sRecognizer = new XmlSelectionElementRecognizer();

    public static ElementRecognizer getRecognizer() {
        return _sRecognizer;
    }

    public Class recognize(URL url) {
        if (url == null || !"xmlselection".equals(url.getProtocol())) {
            return null;
        }
        return XmlSelectionElementRecognizer.class;
    }

    public Node create(URL url, Class type) throws IllegalAccessException, InstantiationException {
        throw new InstantiationException();
    }

    public Element create(final URL url, Project project) throws IllegalAccessException, InstantiationException {
        if (url == null || !"xmlselection".equals(url.getProtocol())) {
            throw new InstantiationException();
        }
        try {
            String srcSpec = url.getPath();
            URL srcURL = URLFactory.newURL((String)srcSpec);
            Node ideNode = NodeFactory.findOrCreate((URL)srcURL);
            if (!(ideNode instanceof XMLSourceNode)) {
                throw new InstantiationException();
            }
            XMLSourceNode sourceNode = (XMLSourceNode)ideNode;
            JDevXmlContext xmlContext = JDevXmlContext.getXmlContext(sourceNode, project);
            new NonDomMutationTransactionTask(){

                protected void performTask(AbstractModel model) {
                    Selection selection = model.getSelection();
                    selection.clear();
                    String query = url.getQuery();
                    if (query != null) {
                        Document d = model.getDocument();
                        String[] args = query.indexOf("&") == -1 ? new String[]{query} : query.split("&");
                        for (int i = 0; i < args.length; ++i) {
                            try {
                                org.w3c.dom.Node selNode = XmlSelectionElementRecognizer._getNode(d, args[i]);
                                if (selNode == null) continue;
                                selection.add(selNode);
                                continue;
                            }
                            catch (Exception e) {
                                Assert.printStackTrace((Throwable)e);
                            }
                        }
                    }
                }
            }.run((AbstractModel)xmlContext.getModel());
            return new XmlSelectionElement(xmlContext);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            throw new InstantiationException();
        }
    }

    private XmlSelectionElementRecognizer() {
    }

    private static org.w3c.dom.Node _getNode(Document doc, String s) {
        String[] intStrings = s.indexOf("_") == -1 ? new String[]{s} : s.split("_");
        int[] ints = new int[intStrings.length];
        for (int i = 0; i < intStrings.length; ++i) {
            ints[i] = Integer.valueOf(intStrings[i]);
        }
        return DomUtils.getNodeFromPath((Document)doc, (int[])ints);
    }
}

