/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.overviewEditor;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.TabbedPaneUI;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.xml.gui.jdev.JDevViewHostedGui;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.overviewEditor.AbstractOverviewEditorXmlGui;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlHeaderOption;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlPanelWrapper;
import oracle.javatools.ui.HeaderPanel;
import oracle.javatools.ui.plaf.FlatTabbedPaneUI;

public class OverviewEditorPanel
extends JPanel
implements Scrollable {
    private RecursiveMouseListener _mouseListener;
    private JTabbedPane _tabbedPane;
    private XmlPanelWrapper _selectedPanelWrapper;
    private JPanel _selectedPanel;
    private ChangeListener _changeListener;
    private Map<Component, XmlPanelWrapper> _xmlPanelWrapperMap;
    private AbstractOverviewEditorXmlGui _xmlGui;
    private boolean _updateXmlComponentsFlag = true;

    public OverviewEditorPanel(Map<Component, XmlPanelWrapper> xmlPanelWrapperMap, AbstractOverviewEditorXmlGui xmlGui) {
        this._xmlPanelWrapperMap = xmlPanelWrapperMap;
        this._xmlGui = xmlGui;
        this.setLayout(new BorderLayout());
        this.setName("OverviewEditor");
        this.setupContextMenuListener(xmlGui);
        List<XmlPanelWrapper> xmlPanelWrapperList = xmlGui.getPanelWrapperList();
        if (xmlPanelWrapperList.size() == 1) {
            Iterator<XmlPanelWrapper> xmlPanelWrapperItor = xmlPanelWrapperList.iterator();
            if (xmlPanelWrapperItor.hasNext()) {
                XmlPanelWrapper xmlPanelWrapper;
                this._selectedPanelWrapper = xmlPanelWrapper = xmlPanelWrapperItor.next();
                xmlPanelWrapper.setParentXmlGui(xmlGui);
                xmlPanelWrapper.getXmlGui().shown();
                xmlPanelWrapper.createXmlComponents();
                xmlPanelWrapper.updateXmlComponentsFromModel();
                XmlHeaderOption xmlHeaderOption = new XmlHeaderOption().setHeaderLabel(xmlPanelWrapper.getLabel()).setCollapsible(false);
                this._selectedPanel = xmlPanelWrapper.getLayoutPolicy().addPageHeader(xmlPanelWrapper.getPanel(), xmlHeaderOption);
                this.setBackground(Color.WHITE);
                this.add((Component)this._selectedPanel, "Center");
            }
            return;
        }
        this._tabbedPane = new JTabbedPane();
        this._tabbedPane.setName("OverviewEditorTabbedPane");
        this._tabbedPane.setUI((TabbedPaneUI)new FlatTabbedPaneUI());
        this._tabbedPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this._tabbedPane, "Center");
        this._changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                OverviewEditorPanel.this.selectPanelTab();
                Dimension preferredSize = OverviewEditorPanel.this._selectedPanel.getPreferredSize();
                OverviewEditorPanel.this._tabbedPane.setPreferredSize(preferredSize);
            }
        };
        this._tabbedPane.addChangeListener(this._changeListener);
        for (XmlPanelWrapper xmlPanelWrapper : this._xmlGui.getPanelWrapperList()) {
            this._tabbedPane.add(xmlPanelWrapper.getLabel(), xmlPanelWrapper.getPanel());
        }
    }

    private void setupContextMenuListener(final JDevViewHostedGui gui) {
        MouseInputAdapter contextMenuListener = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JDevXmlContext.showContextMenu(gui, e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JDevXmlContext.showContextMenu(gui, e);
                }
            }
        };
        this._mouseListener = new RecursiveMouseListener(contextMenuListener);
        this._mouseListener.attach(this);
    }

    public void selectPanelTab() {
        if (this._selectedPanelWrapper != null) {
            this._selectedPanelWrapper.getXmlGui().hidden();
        }
        this._selectedPanel = (JPanel)this._tabbedPane.getSelectedComponent();
        if (this._selectedPanel == null) {
            return;
        }
        this._selectedPanelWrapper = this._xmlPanelWrapperMap.get(this._selectedPanel);
        this._selectedPanelWrapper.getXmlGui().shown();
        if (this._selectedPanelWrapper.getXmlComponentWrapperMap().isEmpty()) {
            this._selectedPanelWrapper.createXmlComponents();
            this._selectedPanelWrapper.updateXmlComponentsFromModel();
        } else if (this._updateXmlComponentsFlag) {
            this._selectedPanelWrapper.updateXmlComponentsFromModel();
        }
    }

    public String getHelpTopicId() {
        Component selected = this._tabbedPane != null ? this._tabbedPane.getSelectedComponent() : this._selectedPanel;
        if (selected instanceof JScrollPane) {
            selected = ((JScrollPane)selected).getViewport().getView();
        }
        if (selected instanceof HeaderPanel && (selected = ((HeaderPanel)selected).getHostedComponent()) instanceof JPanel) {
            selected = ((Container)selected).getComponent(0);
        }
        return HelpUtils.getHelpID((Component)selected);
    }

    public void dispose() {
        if (this._mouseListener != null) {
            this._mouseListener.detach(this);
        }
        if (this._changeListener != null) {
            this._tabbedPane.removeChangeListener(this._changeListener);
            this._changeListener = null;
        }
        if (this._tabbedPane != null) {
            for (Map.Entry<Component, XmlPanelWrapper> entries : this._xmlPanelWrapperMap.entrySet()) {
                entries.getValue().dispose();
            }
            this._tabbedPane.removeAll();
        }
        this.removeAll();
        this._selectedPanelWrapper = null;
        this._selectedPanel = null;
    }

    public JTabbedPane getTabbedPane() {
        return this._tabbedPane;
    }

    public void setSelectedIndex(int selectedIndex, boolean updateXmlComponentsFlag) {
        this._updateXmlComponentsFlag = updateXmlComponentsFlag;
        this.getTabbedPane().setSelectedIndex(selectedIndex);
        this._updateXmlComponentsFlag = true;
    }

    public Map<Component, XmlPanelWrapper> getPanelWrapperMap() {
        return this._xmlPanelWrapperMap;
    }

    public void scrollToComponent(Component c) {
        if (c == null) {
            return;
        }
        Rectangle compBounds = c.getBounds();
        Rectangle visibleRect = this.getVisibleRect();
        Rectangle newCompBounds = SwingUtilities.convertRectangle(c, compBounds, this);
        if (newCompBounds.y < visibleRect.y || newCompBounds.y + newCompBounds.height > visibleRect.y + visibleRect.height) {
            newCompBounds.x = 0;
            newCompBounds.height = visibleRect.height;
            final Rectangle r = newCompBounds;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OverviewEditorPanel.this.scrollRectToVisible(r);
                }
            });
        }
    }

    public void handleShown() {
        this._selectedPanelWrapper.getXmlGui().shown();
        if (this._selectedPanelWrapper.getXmlComponentWrapperMap().isEmpty()) {
            this._selectedPanelWrapper.createXmlComponents();
        }
        this._selectedPanelWrapper.updateXmlComponentsFromModel();
    }

    public void handleHidden() {
        this._selectedPanelWrapper.getXmlGui().hidden();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return visibleRect.height >> 4;
            }
            case 0: {
                return visibleRect.width >> 4;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return visibleRect.height;
            }
            case 0: {
                return visibleRect.width;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        Container parent = SwingUtilities.getUnwrappedParent(this);
        if (parent instanceof JViewport) {
            return parent.getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        Container parent = SwingUtilities.getUnwrappedParent(this);
        if (parent instanceof JViewport) {
            return parent.getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    final class RecursiveMouseListener {
        private final MouseInputListener _target;
        private final AWTEventListener _baseListener;
        private Container _attachedContainer;

        public RecursiveMouseListener(MouseInputListener target) {
            this._target = target;
            this._baseListener = new MyAwtListener();
        }

        public void attach(Container container) {
            if (this._attachedContainer != null) {
                throw new IllegalStateException("Already attached to " + this._attachedContainer);
            }
            this._attachedContainer = container;
            Toolkit.getDefaultToolkit().addAWTEventListener(this._baseListener, 48L);
        }

        public void detach(Container container) {
            if (this._attachedContainer != container) {
                throw new IllegalArgumentException("Not attached to " + container);
            }
            Toolkit.getDefaultToolkit().removeAWTEventListener(this._baseListener);
            this._attachedContainer = null;
        }

        private final class MyAwtListener
        implements AWTEventListener {
            private MyAwtListener() {
            }

            @Override
            public void eventDispatched(AWTEvent event) {
                if (!SwingUtilities.isDescendingFrom((Component)event.getSource(), RecursiveMouseListener.this._attachedContainer)) {
                    return;
                }
                int id = event.getID();
                MouseEvent me = (MouseEvent)event;
                switch (id) {
                    case 500: {
                        RecursiveMouseListener.this._target.mouseClicked(me);
                        break;
                    }
                    case 504: {
                        RecursiveMouseListener.this._target.mouseEntered(me);
                        break;
                    }
                    case 505: {
                        RecursiveMouseListener.this._target.mouseExited(me);
                        break;
                    }
                    case 506: {
                        RecursiveMouseListener.this._target.mouseDragged(me);
                        if (OverviewEditorPanel.this.getTabbedPane() == null || OverviewEditorPanel.this._selectedPanel == null) break;
                        OverviewEditorPanel.this.getTabbedPane().setPreferredSize(OverviewEditorPanel.this._selectedPanel.getPreferredSize());
                        break;
                    }
                    case 503: {
                        RecursiveMouseListener.this._target.mouseMoved(me);
                        break;
                    }
                    case 501: {
                        RecursiveMouseListener.this._target.mousePressed(me);
                        break;
                    }
                    case 502: {
                        RecursiveMouseListener.this._target.mouseReleased(me);
                    }
                }
            }
        }
    }
}

