/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.inspector.layout;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.xml.gui.base.inspector.PropertyModelUtils;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.inspector.layout.CustomGUIComponent;
import org.w3c.dom.Node;

public abstract class BaseGuiComponent
extends CustomGUIComponent {
    private static final Logger _LOGGER = Logger.getLogger(BaseGuiComponent.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInitialize(PropertyModel model) {
        int row = PropertyModelUtils.findRowForXmlKey((PropertyModel)model, (XmlKey)this.getRepresentativePropertyKey());
        if (row < 0) {
            return;
        }
        try {
            JDevXmlContext xmlContext = (JDevXmlContext)PropertyModelUtils.getXmlContext((PropertyModel)model, (int)row);
            Node node = PropertyModelUtils.getAncestorNode((PropertyModel)model, (int)row);
            XmlModel xmlModel = xmlContext.getModel();
            xmlModel.acquireReadLock();
            try {
                this.initializeOnNode(xmlContext, node);
            }
            finally {
                xmlModel.releaseReadLock();
            }
        }
        catch (Exception e) {
            _LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpdate(PropertyModel model) {
        int row = PropertyModelUtils.findRowForXmlKey((PropertyModel)model, (XmlKey)this.getRepresentativePropertyKey());
        if (row < 0) {
            return;
        }
        try {
            JDevXmlContext xmlContext = (JDevXmlContext)PropertyModelUtils.getXmlContext((PropertyModel)model, (int)row);
            Node node = PropertyModelUtils.getAncestorNode((PropertyModel)model, (int)row);
            XmlModel xmlModel = xmlContext.getModel();
            xmlModel.acquireReadLock();
            try {
                this.updateOnNode(xmlContext, node);
            }
            finally {
                xmlModel.releaseReadLock();
            }
        }
        catch (Exception e) {
            _LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void onApply(PropertyModel model) {
    }

    protected abstract void initializeOnNode(JDevXmlContext var1, Node var2);

    protected void updateOnNode(JDevXmlContext xmlContext, Node node) {
    }

    protected abstract XmlKey getRepresentativePropertyKey();
}

