/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.extension.metadata;

import java.net.URL;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import oracle.bali.xml.metadata.MetadataSchemaRegistry;

public class XmlMetadataLanguageExtensionElementVisitor
extends ElementVisitor {
    private static final String NS = "http://xmlns.oracle.com/ide/extension";
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "xml-metadata-language-extension-hook");
    private static final ElementName SCHEMA_PROVIDER = new ElementName("http://xmlns.oracle.com/ide/extension", "schema-provider");
    private static final ElementName INDEXING_MD_PROVIDER = new ElementName("http://xmlns.oracle.com/ide/extension", "indexing-metadata-provider");
    private static final ElementName INDEXING_FUNC_MD_PROVIDER = new ElementName("http://xmlns.oracle.com/ide/extension", "indexing-function-metadata-provider");
    private final ElementVisitor _providerHandler = new ProviderHandler();

    public final void start(ElementStartContext context) {
        context.registerChildVisitor(SCHEMA_PROVIDER, this._providerHandler);
        context.registerChildVisitor(INDEXING_MD_PROVIDER, this._providerHandler);
        context.registerChildVisitor(INDEXING_FUNC_MD_PROVIDER, this._providerHandler);
    }

    public final void end(ElementEndContext context) {
    }

    private final class ProviderHandler
    extends ElementVisitor {
        private ProviderHandler() {
        }

        public final void end(ElementEndContext context) {
            String value = context.getText().trim();
            ClassLoader loader = (ClassLoader)context.getScopeData().get("classLoader");
            URL url = loader.getResource(value);
            ElementName elementName = context.getElementName();
            if (SCHEMA_PROVIDER.equals((Object)elementName)) {
                MetadataSchemaRegistry.getInstance().registerSchema(url);
            } else if (INDEXING_MD_PROVIDER.equals((Object)elementName)) {
                MetadataSchemaRegistry.getInstance().registerIndexingMetadata(url);
            } else if (INDEXING_FUNC_MD_PROVIDER.equals((Object)elementName)) {
                MetadataSchemaRegistry.getInstance().registerIndexingFunctionMD(url);
            }
        }
    }
}

