/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.dependency;

import java.net.URL;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.dependency.ExternalIdDeclaration;
import oracle.bali.xml.gui.jdev.dependency.JDevDependencyContext;
import oracle.bali.xml.gui.jdev.dependency.XmlIndexReference;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.dependency.CommandResult;
import oracle.bali.xml.model.dependency.Declaration;
import oracle.bali.xml.model.dependency.DependencyContext;
import oracle.bali.xml.model.dependency.ValueInfo;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.javatools.status.Severity;
import org.w3c.dom.Node;

public abstract class ExternalIdReference
extends XmlIndexReference {
    private Workspace _workspace = null;
    private Project _project = null;

    public ExternalIdReference(XmlContext xmlContext, Node node, int start, int end) {
        super(xmlContext, node, start, end);
        if (xmlContext instanceof JDevXmlContext) {
            JDevXmlContext jdevCxt = (JDevXmlContext)xmlContext;
            this._workspace = jdevCxt.getWorkspace();
            this._project = jdevCxt.getProject();
        }
    }

    public Workspace getWorkspace() {
        return this._workspace;
    }

    public Project getProject() {
        return this._project;
    }

    public URL getURL() {
        return this.getFileURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStartOffset() {
        JDevDependencyContext context = new JDevDependencyContext();
        XmlModel model = this.getXmlContext(context).getModel();
        model.acquireReadLock();
        try {
            DomRange range = this.getDomRange(context);
            int n = model.getTextOffset(range.getStart());
            return n;
        }
        finally {
            model.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEndOffset() {
        JDevDependencyContext context = new JDevDependencyContext();
        XmlModel model = this.getXmlContext(context).getModel();
        model.acquireReadLock();
        try {
            DomRange range = this.getDomRange(context);
            int n = model.getTextOffset(range.getEnd());
            return n;
        }
        finally {
            model.releaseReadLock();
        }
    }

    public Declaration findDeclaration(DependencyContext context) {
        String declId = this.getDeclarationId();
        if (declId == null) {
            return null;
        }
        return ExternalIdDeclaration.getDeclaration(new Context(this.getWorkspace(), this.getProject()), this.getDeclarationId());
    }

    public abstract String getDeclarationId();

    @Override
    public boolean isReferenceFor(DependencyContext context, Declaration declaration) {
        ExternalIdDeclaration idDecl;
        String idDeclId;
        return declaration instanceof ExternalIdDeclaration && (idDeclId = (idDecl = (ExternalIdDeclaration)declaration).getDeclarationId()) != null && idDeclId.equals(this.getDeclarationId());
    }

    protected abstract String getValueFromId(DependencyContext var1, String var2);

    protected boolean supportsUpdateReference() {
        return true;
    }

    protected CommandResult updateReferenceImpl(DependencyContext context, ValueInfo value) {
        String valueStr = this.getValueFromId(context, value.getNewValue());
        if (valueStr == null) {
            String format = this.getXmlContext(context).getTranslatedString("REFERENCE_UPDATE_FAILURE");
            String message = FastMessageFormat.formatMessage((String)format, (String)((String)this.getMetadata(context, "displayNameMetadata")));
            return new CommandResult(Severity.ERROR, message);
        }
        ValueInfo newValue = new ValueInfo(this.getValue(context), valueStr);
        return super.updateReferenceImpl(context, newValue);
    }
}

