/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.javatools.datatransfer.AbstractTransformingDataTransferPlugin;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;
import oracle.javatools.datatransfer.TransferUtils;
import oracle.javatools.logging.LogUtils;

public class FileListDataTransferPlugin
extends AbstractTransformingDataTransferPlugin {
    private static final Logger _LOGGER = Logger.getLogger(FileListDataTransferPlugin.class.getName());

    protected DataFlavor getSourceFlavor() {
        return DataFlavor.javaFileListFlavor;
    }

    protected void augmentImpl(AugmentableTransferable trans, Collection sourceDataInfos) {
        Iterator itor = sourceDataInfos.iterator();
        while (itor.hasNext()) {
            trans.augment((TransferDataInfo)new TDI((TransferDataInfo)itor.next()));
        }
    }

    private static class TDI
    extends TransferDataInfo {
        private TransferableContext _cached = null;
        private final TransferDataInfo _fileDataInfo;

        public TDI(TransferDataInfo fileDataInfo) {
            this._fileDataInfo = fileDataInfo;
        }

        public TransferDataInfo getFileDataInfo() {
            return this._fileDataInfo;
        }

        public Object getData(FetchMode mode, boolean asReference) throws IOException {
            Object fileData;
            if (this._cached == null && mode == FetchMode.STANDARD && (fileData = this._fileDataInfo.getData(mode, asReference)) instanceof List) {
                List fileList = (List)fileData;
                this._cached = new TransferableContext(null);
                for (Object o : fileList) {
                    if (!(o instanceof File)) continue;
                    File file = (File)o;
                    try {
                        Node node = NodeFactory.findOrCreate((URL)file.toURL());
                        if (_LOGGER.isLoggable(Level.FINER)) {
                            _LOGGER.log(Level.FINER, "TransferableContext plugin: file={0} node={1}", new Object[]{file, node});
                        }
                        if (node == null) continue;
                        this._cached.add((Object)node);
                    }
                    catch (InstantiationException e) {
                        this._err(e, file);
                    }
                    catch (IllegalAccessException e) {
                        this._err(e, file);
                    }
                }
            }
            return this._cached;
        }

        public DataFlavor getDataFlavor() {
            return TransferableContext.contextFlavor;
        }

        public Object getMetadata(Object key) {
            return this._fileDataInfo.getMetadata(key);
        }

        public float getSuitabilityRank() {
            return TransferUtils.lowerRank((float)this._fileDataInfo.getSuitabilityRank());
        }

        private void _err(Exception e, File f) {
            LogUtils.log((Logger)_LOGGER, (Level)Level.WARNING, (String)"Exception creating node for file {0}", (Object)f, (Throwable)e);
        }
    }
}

