/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.ceditor;

import java.awt.Point;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.util.XdfGoToDeclarationAction;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.dependency.DependencyUtils;
import oracle.ide.Context;
import oracle.ide.ceditor.AbstractBrowseClickPlugin;
import oracle.ide.ceditor.CodeEditor;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.NumberRange;

public class XmlBrowseClickPlugin
extends AbstractBrowseClickPlugin {
    protected void performDeclarationClick(Point clickPoint) {
        Context ideContext;
        JDevXmlContext context;
        CodeEditor ce;
        BasicEditorPane editor = this.getEditorPane();
        if (editor != null && (ce = CodeEditor.getCodeEditor((BasicEditorPane)editor)) != null && (context = JDevXmlContext.getXmlContext(ideContext = ce.getContext())) != null && !DependencyUtils.DISABLE_XDF) {
            XdfGoToDeclarationAction.goToDeclaration(context, -1);
        }
    }

    protected NumberRange getIdentifierAtOffset(int offset) {
        return XmlBrowseClickPlugin.getXmlIdentifierAtOffset(this.getEditorPane(), offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static NumberRange getXmlIdentifierAtOffset(BasicEditorPane editor, int offset) {
        Context ideContext;
        JDevXmlContext context;
        CodeEditor ce;
        if (editor != null && (ce = CodeEditor.getCodeEditor((BasicEditorPane)editor)) != null && (context = JDevXmlContext.getXmlContext(ideContext = ce.getContext())) != null) {
            XmlModel model = context.getModel();
            model.acquireReadLock();
            try {
                int[] startEnd = new int[]{-1, -1};
                DomRange range = null;
                if (!DependencyUtils.DISABLE_XDF) {
                    range = XdfGoToDeclarationAction.getDomRangeIfCanGoToDeclaration(context, offset);
                }
                if (range != null) {
                    startEnd[0] = model.getTextOffset(range.getStart());
                    startEnd[1] = model.getTextOffset(range.getEnd());
                }
                if (startEnd[0] >= 0 && startEnd[1] >= 0) {
                    NumberRange numberRange = new NumberRange(startEnd[0], startEnd[1]);
                    return numberRange;
                }
            }
            finally {
                model.releaseReadLock();
            }
        }
        return null;
    }
}

