/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.ceditor;

import java.beans.PropertyChangeEvent;
import java.util.List;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.keymap.EditorKeyStrokes;
import oracle.ide.ceditor.keymap.KeymapManager;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.xml.parser.v2.XMLComment;

public class ToggleCommentPlugin
implements EditorPlugin,
Controller,
ActionHookInvoker {
    public ToggleCommentPlugin() {
        this._initializeToggleAction();
    }

    public void install(BasicEditorPane editor) {
        editor.addActionHookInvoker((ActionHookInvoker)this);
    }

    public void deinstall(BasicEditorPane editor) {
        editor.removeActionHookInvoker((ActionHookInvoker)this);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        Node sourceNode = context.getNode();
        if (sourceNode instanceof XMLSourceNode) {
            XmlModel model = JDevXmlContext.getXmlContext(context).getModel();
            DomRange range = this._getDomRange(context);
            if (this._isReadOnly(model) || range.isEmptyRange()) {
                return true;
            }
            List nodes = range.getNodesInRange(model.getTreeTraversal());
            if (nodes.get(0) instanceof XMLComment) {
                model.uncomment(range);
            } else {
                model.commentOut(range, true);
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        Node sourceNode = context.getNode();
        if (sourceNode instanceof XMLSourceNode) {
            XmlModel model = JDevXmlContext.getXmlContext(context).getModel();
            DomRange range = this._getDomRange(context);
            action.setEnabled(!this._isReadOnly(model) && !range.isEmptyRange());
            return true;
        }
        return false;
    }

    public boolean invokeAction(String actionKey) {
        if ("toggle-java-comments".equals(actionKey)) {
            IdeAction action = IdeAction.find((String)actionKey);
            Editor editor = EditorManager.getEditorManager().getCurrentEditor();
            Context context = editor.getContext();
            return this.handleEvent(action, context);
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    private void _initializeToggleAction() {
        KeymapManager keymapManager = KeymapManager.getInstance();
        EditorKeyStrokes editorContext = keymapManager.getEditorKeyStrokes();
        IdeAction action = editorContext.lookupAction("toggle-java-comments");
        action.addController((Controller)this);
        action.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DomRange _getDomRange(Context context) {
        BasicEditorPane editor = ToggleCommentPlugin._getEditorPane(context);
        XmlModel model = JDevXmlContext.getXmlContext(context).getModel();
        DomModel domModel = JDevXmlContext.getXmlContext(context).getModel().getDomModel();
        DomRange range = null;
        domModel.acquireReadLock();
        try {
            DomPosition start = domModel.getDomPosition(editor.getSelectionStart());
            DomPosition end = domModel.getDomPosition(editor.getSelectionEnd());
            if (start.isInside() && DomUtils.isDescendant((TreeTraversal)model.getTreeTraversal(), (org.w3c.dom.Node)end.getTargetNode(), (org.w3c.dom.Node)start.getTargetNode())) {
                start = start.getBeforePosition();
            }
            range = DomRange.create((DomPosition)start, (DomPosition)end, (TreeTraversal)model.getTreeTraversal());
        }
        finally {
            domModel.releaseReadLock();
        }
        return range;
    }

    private boolean _isReadOnly(XmlModel model) {
        model.acquireReadLock();
        try {
            boolean bl = model.isReadOnly();
            return bl;
        }
        finally {
            model.releaseReadLock();
        }
    }

    private static BasicEditorPane _getEditorPane(Context context) {
        BasicEditorPane editor = null;
        View view = context.getView();
        if (view instanceof CodeEditor) {
            editor = ((CodeEditor)view).getFocusedEditorPane();
        }
        return editor;
    }
}

